/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.dbinspector.checks;

import com.oracle.premigration.commons.enums.LockdownProfile;
import com.oracle.premigration.commons.enums.MigrationMethod;
import com.oracle.premigration.commons.enums.TargetCloud;
import com.oracle.premigration.dbinspector.Check;
import com.oracle.premigration.dbinspector.CheckResult;
import com.oracle.premigration.dbinspector.DatabaseObject;
import com.oracle.premigration.dbinspector.ExecutionContext;
import com.oracle.premigration.dbinspector.FilterableCheck;
import com.oracle.premigration.helpers.SqlUtils;
import com.oracle.premigration.logger.PremigrationLogger;
import com.oracle.premigration.reports.CheckFiltrationMetadata;
import java.util.Arrays;

public class has_refs_to_user_objects_in_sys
extends FilterableCheck {
    private static final PremigrationLogger log = PremigrationLogger.getLogger(has_refs_to_user_objects_in_sys.class.getName());

    public has_refs_to_user_objects_in_sys() {
        this.getLockdownProfiles().addAll(Arrays.asList(LockdownProfile.NONE, LockdownProfile.NOT_AUTONOMOUS));
        this.getTargetCloud().addAll(Arrays.asList(TargetCloud.ATPS, TargetCloud.ADWS, TargetCloud.ATPD, TargetCloud.ADWD));
        this.getMigrationMethods().addAll(Arrays.asList(MigrationMethod.DATAPUMP, MigrationMethod.DATAPUMP_DBLINK, MigrationMethod.GOLDENGATE));
        this.setScope(Check.Scope.SCHEMA);
        this.setDeclarativeResult(CheckResult.BLOCKER);
    }

    @Override
    public void initFiltrationMetadata() {
        this.setFiltrationMetadata(CheckFiltrationMetadata.builder().schemaOwnerColumn("OWNER").objectNameColumn("NAME").objectTypeColumn("TYPE").build());
    }

    @Override
    public void prepare(ExecutionContext exeCtx) {
        boolean hasOracleMaintained = exeCtx.hasDatabaseObject(DatabaseObject.builder().schema("SYS").table("DBA_OBJECTS").column("ORACLE_MAINTAINED").build());
        if (hasOracleMaintained) {
            String whereClause = SqlUtils.createWhereClauseForColumn(exeCtx, "A.OWNER");
            String sqlQuery = "WITH USER_OBJECTS_IN_SYS AS   ( SELECT  owner,  object_name,  subobject_name,  object_type FROM  sys.dba_objects WHERE  owner IN('SYS','SYSTEM')  AND oracle_maintained = 'N'  AND object_type NOT IN ('LOB', 'LOB PARTITION', 'CONTEXT', 'CONTAINER',                          'LOB SUBPARTITION', 'DIRECTORY')  AND object_id IS NOT NULL  AND object_name NOT LIKE 'UTL!_%' ESCAPE '!'  AND object_name NOT LIKE 'WRH$%'  AND object_name NOT LIKE 'WRP$%'  AND object_name NOT LIKE 'WRI$%'  AND object_name NOT LIKE 'WRM%'  AND object_name NOT LIKE 'QT%!_BUFFER' ESCAPE '!'  AND object_name NOT LIKE 'SYS!_%' ESCAPE '!'  AND object_name NOT LIKE 'SYS%NT%'  AND object_name NOT LIKE 'AQ$%$%'  AND object_name NOT LIKE 'AQ%SRVNTFN%'  AND object_name NOT LIKE 'OFS$%OBJ%DATA'  AND object_name NOT LIKE 'ADBD$DBFS%'  AND object_name NOT LIKE '%SFS$!_FST%' ESCAPE '!'  AND object_name NOT LIKE 'SCHEMA!_VERSION!_REG%' ESCAPE '!'  AND object_name NOT LIKE 'KUPC$DATAPUMP!_QUETAB%' ESCAPE '!'  AND object_name NOT LIKE 'DMB%'  AND object_name NOT LIKE 'DBMS!_%' ESCAPE '!'  AND object_name NOT LIKE 'DBMSHP!_%' ESCAPE '!'  AND object_name NOT LIKE 'AQ$!_%' ESCAPE '!'  AND object_name NOT LIKE 'AQ!_%' ESCAPE '!'  AND object_name NOT LIKE 'SYS$SERVICE!_METRICS%' ESCAPE '!'  AND object_name NOT LIKE 'SQLT$%'  AND object_name NOT LIKE 'TRCA$%'  AND object_name NOT IN ('FGA_LOG$', 'NON$CDB',                          'DBFS_ATTRIBUTES', 'ORA$AUTOTASK_JOB_CLASS',                          'UPGRADE_LIB', 'SCHEDULER$_EVENT_QUEUE',                           'KGL_TEST_LIB', 'XMLTABLEINDEX_LIB')  AND NOT (object_type IN ('TABLE', 'TABLE PARTITION') AND           (object_name IN             ('JAVASNM_TMP$','JAVANAMESTATUS$','NET$_ACL',             'WALLET$_ACL','ORA_BUNDLE_FIXCONTROL_STATE$',             'TTS_TBS$', 'TTS_USR$', 'V$LCM_AUDIT',             'XDB_INSTALLATION_TAB', 'PROXY$', 'ADBD_PATCH_STATUS',             'SQLPLUS_PRODUCT_PROFILE') OR            object_name LIKE 'AURORA$%' OR            object_name LIKE 'JAVA%' OR            object_name LIKE 'DBMS!_XPLAN%' ESCAPE '!' OR            object_name LIKE 'KUPC$DATAPUMP!_QUETAB!_%' ESCAPE '!' OR            object_name LIKE 'REGISTRY$%' OR            object_name LIKE 'PRVT!_EPGCTAB!_%' ESCAPE '!' OR            object_name LIKE 'KU$!_EXPDP!_IMPDP!_MASTER%' ESCAPE '!'))  AND NOT (object_type  = 'INDEX' AND           object_name IN ('UTL_RECOMP_SORT_IDX1','DAM_CONFIG_PARAM_UK1',                           'SCHEDULER$_EVENT_QTAB_HIST', 'I_PROXY$', 'I_AUD3',                            'RQ$CONFIG_PK', 'RQ$SCRIPT_PK', 'UK_SCRIPTACCESS'))  AND NOT (object_type = 'TYPE' AND           (object_name LIKE 'AWR!_OBJECT!_INFO!_%' ESCAPE '!' OR            object_name LIKE 'ODCI%' OR            object_name LIKE 'JOB!_DEF%' ESCAPE '!' OR            object_name LIKE 'extra!_attribute%' ESCAPE '!' OR            object_name LIKE 'anydata%!_T' ESCAPE '!' OR            object_name LIKE 'column_value%!_T' ESCAPE '!' OR            object_name LIKE 'datetime!_format%!_T' ESCAPE '!' OR            object_name LIKE 'new!_values%!_T' ESCAPE '!' OR            object_name LIKE 'old!_value%!_COLL' ESCAPE '!' OR            object_name LIKE 'old!_values%!_T' ESCAPE '!' OR            object_name LIKE '%!_LCR%!_T' ESCAPE '!' OR            object_name LIKE 'XDP!_%' ESCAPE '!' OR            object_name LIKE 'XMLTABLEINDEX%' OR            object_name LIKE 'LCR$!_ROW!_%' ESCAPE '!' OR            object_name LIKE 'SQLCONNECTION%' OR            object_name LIKE 'SQLCOMP%' OR            object_name LIKE 'SQLCONSTANT%' OR            object_name LIKE 'SQLCURSOR%' OR            object_name LIKE 'SQLDATA%' OR            object_name LIKE 'SQLDEF%' OR            object_name LIKE 'SQLDEPENDENCY%' OR            object_name LIKE 'SQLIN%' OR            object_name LIKE 'SQLLONG%' OR            object_name LIKE 'SQLPARENT%' OR            object_name LIKE 'SQLPERSIST%' OR            object_name LIKE 'SQLPROP%' OR            object_name LIKE 'SQLSHORT%' OR            object_name LIKE 'SQLVALUE%' OR            object_name LIKE 'SQLWSTR%' OR            object_name LIKE 'SQLREMOTE%' OR            object_name LIKE 'SQLMETADATA%' OR            object_name LIKE 'SQLERROR%' OR            object_name LIKE 'SYSTP%' OR            object_name IN ('ALERT_TYPE','DBMS_XS_PRIVID_LIST',                            'XNP_MESSAGE_TYPE', 'XMLGENFORMATTYPE',                            'MSG_PROP_T', 'CHNF$_REG_INFO', 'SCHEDULER$_EVENT_INFO',                            'SQLBOOLEANSEQUENCE', 'SQLDOUBLESEQUENCE', 'SQLDYNAMICDEFINITIONSTRUCT',                            'SQLFLOATSEQUENCE', 'SQLJOINDEFINITIONSTRUCT', 'SQLOLAPIEXCEPTION',                            'SQLINVALIDINDEXSPECIFICATIONEX', 'SQLMULTIPLIERBLOCKSTRUCT',                            'SQLRANGEDEFINITIONSTRUCT', 'SQLVERSIONINFOSTRUCT',                            'SQLUNMATCHEDINPUTSEXCEPTION', 'SQLSTRINGSEQUENCE', 'SQLSERVERSTRUCT',                            'SQLOCTETSEQUENCE', 'SQLEXPRESSEXCEPTION', 'SQLDOMAINENUM',                            'SQLBASEONLYDEFINITIONSTRUCT')))  AND NOT (object_type = 'SEQUENCE' AND                   object_name = 'UTL_RECOMP_SEQ')  AND NOT (object_type = 'SYNONYM' AND                   object_name LIKE 'DBA!_%' ESCAPE '!')  AND NOT (object_type = 'VIEW' AND                   (object_name LIKE 'VSFS$%' OR                    object_name LIKE 'AQ$AQ!_%' ESCAPE '!' OR                    object_name LIKE 'X!_$KS' ESCAPE '!' OR                    object_name LIKE 'V$CACHE%' OR                    object_name LIKE 'GV$%' OR                    object_name LIKE 'EXU7%' OR                    object_name LIKE 'DBA!_%' ESCAPE '!' OR                    object_name IN ('JAVA_DEV_STATUS','V$XS_SESSION_ROLE',                                              'KU$_VIEW_STATUS_VIEW', 'X_$KCBFWAIT',                                              'V_$TEMPSTATXS', 'V_$FILESTATXS', 'V_$SQLXS',                                              'V$FALSE_PING', 'V$PING', 'USER_SOURCE_TAB_COLUMNS',                                              'USER_ADVISOR_DIRECTIVES', 'GV$PING', 'GV$FALSE_PING',                                              'DBA_SOURCE_TAB_COLUMNS', 'DATABASE_SERVICES',                                              'ALL_SOURCE_TAB_COLUMNS')))  AND NOT (object_type IN ('FUNCTION', 'PROCEDURE') AND                   (object_name LIKE 'PFN!_X$%' ESCAPE '!' OR                    object_name LIKE 'BLAST%' OR                    object_name LIKE 'TBLAST!_%' ESCAPE '!' OR                    object_name LIKE 'OWNER!_MIGRATE!_UPDATE!_%' ESCAPE '!' OR                    object_name LIKE 'VALIDATE!_%' ESCAPE '!' OR                    object_name LIKE 'UPGRADE!_SYSTEM!_%' ESCAPE '!' OR                    object_name LIKE 'PREUP%' OR                    object_name IN ('DIR_EXISTS_AND_IS_WRITABLE', 'VERSION_SCRIPT',                                              'REVOKE_PRIV')))  AND NOT (object_type = 'RESOURCE PLAN' AND                   (object_name IN ('DWCS_PLAN', 'PAAS_PLAN', 'SYSTEM_PLAN') OR                    object_name LIKE 'ORA$AUTOTASK!_%' ESCAPE '!'))  AND NOT (object_type = 'TRIGGER' AND                   object_name IN ('ATP_DBFS_MOUNT', 'ATP_DBFS_UNMOUNT',                                             'OLTP_LOGON'))  AND NOT (object_type IN ('JOB', 'JOB CLASS', 'CONSUMER GROUP') AND                   (object_name IN ('LOW', 'MEDIUM', 'HIGH',                                              'TP', 'TPURGENT', 'ORA$DIAGNOSTICS', 'OFS_MOUNT_JOB',                                              'AUTO_TASK_CONSUMER_GROUP', 'GATHER_STATS_JOB',                                              'AUTO_TASKS_JOB_CLASS', 'AUTO_SPACE_ADVISOR_JOB') OR                    object_name LIKE 'ORA$AUTOTASK!_%' ESCAPE '!' OR                    object_name LIKE 'ORA$!_ATSK%' ESCAPE '!' OR                    object_name LIKE 'IDX_RB$CLASS!_%' ESCAPE '!'))  AND NOT (object_type IN ('JAVA RESOURCE', 'JAVA CLASS', 'JAVA SOURCE', 'JAVA DATA') AND                   (object_name LIKE '%SoftHashMap%' OR                    object_name LIKE 'XSU12!_%' ESCAPE '!' OR                    object_name LIKE '%xdk!_version%' ESCAPE '!' OR                    object_name LIKE '%AQAPI!_BUILT%' ESCAPE '!' OR                    object_name LIKE 'prv//////%' OR                    object_name = 'PreupCreateDir' OR                     object_name = 'sqlLogCreateDir'))  AND NOT (object_type IN ('QUEUE', 'RULE', 'RULE SET') AND                    object_name LIKE 'KUPC$!_' ESCAPE '!')  AND NOT (object_type IN ('PACKAGE', 'PACKAGE BODY') AND                   (object_name LIKE 'CWM2!_OLAP!_%' ESCAPE '!' OR                    object_name IN ('SDO_RDF_EXP_IMP', 'SQLJUTL2', 'BLAST_CUR',                                    'PRVT_EPGC', 'PRVT_EGUTL', 'USER_LOCK', 'DBMSNCDB',                                    'DATAPROVIDERINTERFACE', 'DATABASEINTERFACE',                                    'CURSORMANAGERINTERFACE', 'CONNECTIONINTERFACE',                                    'DEFINITIONMANAGERINTERFACE', 'SERVERINTERFACE',                                    'METADATAPROVIDERINTERFACE')                   )          )  ) SELECT A.OWNER, A.TYPE, A.NAME, A.REFERENCED_OWNER, A.REFERENCED_TYPE, A.REFERENCED_NAME   FROM SYS.DBA_DEPENDENCIES A, USER_OBJECTS_IN_SYS B " + whereClause + "  AND B.OWNER = A.REFERENCED_OWNER   AND B.OBJECT_NAME = A.REFERENCED_NAME UNION SELECT A.OWNER, 'SYNONYM' AS TYPE, SYNONYM_NAME AS NAME, A.TABLE_OWNER REFERENCED_OWNER, B.OBJECT_TYPE REFERENCED_TYPE, A.TABLE_NAME REFERENCED_NAME   FROM SYS.DBA_SYNONYMS A, USER_OBJECTS_IN_SYS B " + whereClause + "  AND A.TABLE_OWNER = B.OWNER   AND A.TABLE_NAME = B.OBJECT_NAME UNION ALL SELECT A.OWNER, A.TYPE, A.NAME, A.REFERENCED_OWNER, A.REFERENCED_TYPE, A.REFERENCED_NAME    FROM SYS.DBA_DEPENDENCIES A, SYS.DBA_SYNONYMS B, USER_OBJECTS_IN_SYS C " + whereClause + "  AND B.OWNER NOT IN ('SYS','SYSTEM','PUBLIC')   AND B.TABLE_OWNER IN ('SYS','SYSTEM')   AND B.OWNER = A.REFERENCED_OWNER   AND B.SYNONYM_NAME = A.REFERENCED_NAME   AND C.OWNER = B.TABLE_OWNER   AND C.OBJECT_NAME = B.TABLE_NAME ";
            this.setSqlQuery(sqlQuery);
        } else {
            this.skipCheck(this.lang.txt("CHECK_SKIPPED_BECAUSE_OBJECT_MISSING", this.getName(), "ORACLE_MAINTAINED", "COLUMN"));
        }
    }
}

