/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.dbinspector.checks;

import com.oracle.premigration.commons.enums.LockdownProfile;
import com.oracle.premigration.commons.enums.MigrationMethod;
import com.oracle.premigration.commons.enums.TargetCloud;
import com.oracle.premigration.dbinspector.Check;
import com.oracle.premigration.dbinspector.CheckResult;
import com.oracle.premigration.dbinspector.DatabaseObject;
import com.oracle.premigration.dbinspector.ExecutionContext;
import com.oracle.premigration.helpers.SqlUtils;
import com.oracle.premigration.helpers.Utilities;
import com.oracle.premigration.logger.PremigrationLogger;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;

public class has_noexport_object_grants
extends Check {
    private static final PremigrationLogger log = PremigrationLogger.getLogger(has_noexport_object_grants.class.getName());

    public has_noexport_object_grants() {
        this.getLockdownProfiles().addAll(Arrays.asList(LockdownProfile.PAAS_ATPD, LockdownProfile.ADW_ADWD, LockdownProfile.OLTP_ATPS, LockdownProfile.DWCS_ADWS, LockdownProfile.ADB_UNSUPPORTED, LockdownProfile.NONE, LockdownProfile.NOT_AUTONOMOUS));
        this.getTargetCloud().addAll(Arrays.asList(TargetCloud.ADWD, TargetCloud.ADWS, TargetCloud.ATPD, TargetCloud.ATPS, TargetCloud.DEFAULT));
        this.getMigrationMethods().addAll(Arrays.asList(MigrationMethod.DATAPUMP, MigrationMethod.DATAPUMP_DBLINK, MigrationMethod.GOLDENGATE));
        this.setScope(Check.Scope.SCHEMA);
        this.setDeclarativeResult(CheckResult.WARNING);
    }

    @Override
    public void prepare(ExecutionContext exeCtx) {
        try {
            String dbaRolesClause;
            boolean hasOracleMaintained;
            boolean hasKuObjGrantViewColumn = exeCtx.hasDatabaseObject(DatabaseObject.builder().schema("SYS").view("KU$_OBJGRANT_VIEW").column("PRIVNAME").build());
            if (!hasKuObjGrantViewColumn) {
                this.skipCheck(this.lang.txt("CHECK_SKIPPED_BECAUSE_OBJECT_MISSING", this.getName(), "KU$_OBJGRANT_VIEW.PRIVNAME", "COLUMN"), CheckResult.WARNING);
                return;
            }
            String whereClause = SqlUtils.createWhereClauseForColumn(exeCtx, "KUOJV.GRANTEE");
            List<String> excludeSchemas = SqlUtils.getExcludedSchemaDefaults(exeCtx);
            if (!excludeSchemas.contains("SYS")) {
                excludeSchemas.add("SYS");
            }
            if (hasOracleMaintained = exeCtx.hasDatabaseObject(DatabaseObject.builder().schema("SYS").table("DBA_ROLES").column("ORACLE_MAINTAINED").build())) {
                String whereRolesClause = SqlUtils.createWhereClauseForColumn(exeCtx, "GRANTEE");
                dbaRolesClause = " OR KUOJV.GRANTEE IN (SELECT ROLE FROM SYS.DBA_ROLES WHERE SYS.DBA_ROLES.ORACLE_MAINTAINED <> 'Y' AND ROLE IN (SELECT GRANTED_ROLE FROM SYS.DBA_ROLE_PRIVS " + whereRolesClause + ")) ";
            } else {
                dbaRolesClause = "";
            }
            String baseObjectPredicate = SqlUtils.createAndClause("KUOJV.BASE_OBJ.OWNER_NAME", true, excludeSchemas);
            String sqlQuery = "SELECT KUOJV.GRANTEE,   KUOJV.BASE_OBJ.OWNER_NAME AS OBJECT_OWNER,   KUOJV.BASE_OBJ.NAME AS OBJECT_NAME,   KUOJV.PRIVNAME AS PRIVILEGE,   KUOJV.GRANTOR  FROM SYS.KU$_OBJGRANT_VIEW KUOJV " + whereClause + " AND KUOJV.GRANTEE IN (SELECT USERNAME FROM SYS.DBA_USERS) " + dbaRolesClause + " AND NOT (KUOJV.BASE_OBJ.OWNER_NAME = 'SYS' AND KUOJV.BASE_OBJ.NAME LIKE 'QT%!_BUFFER' ESCAPE '!') " + baseObjectPredicate + " ORDER BY GRANTEE, OBJECT_OWNER, OBJECT_NAME, PRIVILEGE, GRANTOR";
            this.setSqlQuery(sqlQuery);
        }
        catch (SQLException e) {
            String msg = Utilities.getErrorText("ERROR2000", e, this.getName());
            log.severe(msg, e);
            this.skipCheck(msg, CheckResult.FATAL);
        }
    }
}

