/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.dbinspector.checks;

import com.oracle.premigration.commons.enums.LockdownProfile;
import com.oracle.premigration.commons.enums.MigrationMethod;
import com.oracle.premigration.commons.enums.TargetCloud;
import com.oracle.premigration.dbinspector.Check;
import com.oracle.premigration.dbinspector.CheckResult;
import com.oracle.premigration.dbinspector.ExecutionContext;
import com.oracle.premigration.helpers.SqlUtils;
import com.oracle.premigration.helpers.Utilities;
import com.oracle.premigration.logger.PremigrationLogger;
import java.util.Arrays;
import java.util.List;

public class has_low_streams_pool_size
extends Check {
    private static final PremigrationLogger log = PremigrationLogger.getLogger(has_low_streams_pool_size.class.getName());
    private static final List<String> PARAMS = Arrays.asList("streams_pool_size", "sga_target");

    public has_low_streams_pool_size() {
        this.getLockdownProfiles().addAll(Arrays.asList(LockdownProfile.PAAS_ATPD, LockdownProfile.ADW_ADWD, LockdownProfile.ADB_UNSUPPORTED, LockdownProfile.NONE, LockdownProfile.NOT_AUTONOMOUS));
        this.getTargetCloud().addAll(Arrays.asList(TargetCloud.ATPS, TargetCloud.ATPD, TargetCloud.ADWD, TargetCloud.ADWS, TargetCloud.DEFAULT));
        this.getMigrationMethods().addAll(Arrays.asList(MigrationMethod.DATAPUMP, MigrationMethod.DATAPUMP_DBLINK, MigrationMethod.GOLDENGATE));
        this.setScope(Check.Scope.UNIVERSAL);
    }

    @Override
    public void prepare(ExecutionContext exeCtx) {
        this.setSqlQuery("SELECT LOWER(NAME) AS NAME,CAST(VALUE AS VARCHAR2(100)) AS VALUE FROM V$PARAMETER " + SqlUtils.createWhereInClause("LOWER(NAME)", PARAMS));
    }

    @Override
    public CheckResult determineResult() {
        int TEN_MB = 0xA00000;
        if (this.getRelevantObjectsData() == null || this.getRelevantObjectsData().isEmpty()) {
            return CheckResult.WARNING;
        }
        Long streamsPoolSize = null;
        Long sgaTarget = null;
        block10: for (int i = 0; i < PARAMS.size(); ++i) {
            Long numValue;
            String key = this.getRelevantObjectsData().get(i).get("NAME");
            String strValue = this.getRelevantObjectsData().get(i).get("VALUE");
            try {
                numValue = strValue == null || strValue.isEmpty() ? null : Long.valueOf(Long.parseLong(strValue));
            }
            catch (Exception e) {
                String checkFailMsg = Utilities.getErrorText("ERROR2001", e, key, this.getName());
                this.setErrorMessage(checkFailMsg);
                log.severe(checkFailMsg, e);
                return CheckResult.WARNING;
            }
            switch (key) {
                case "streams_pool_size": {
                    streamsPoolSize = numValue;
                    continue block10;
                }
                case "sga_target": {
                    sgaTarget = numValue;
                    continue block10;
                }
                default: {
                    throw new IllegalArgumentException("Unexpected key: " + key);
                }
            }
        }
        log.trace("using " + sgaTarget + " as " + "sga_target");
        log.trace("using " + streamsPoolSize + " as " + "streams_pool_size");
        if (streamsPoolSize != null && sgaTarget != null && streamsPoolSize != 0L && sgaTarget != 0L && streamsPoolSize < 0xA00000L) {
            return CheckResult.WARNING;
        }
        if (streamsPoolSize == null && sgaTarget != null && sgaTarget != 0L) {
            return CheckResult.WARNING;
        }
        if (streamsPoolSize != null && sgaTarget != null && streamsPoolSize != 0L && sgaTarget == 0L && streamsPoolSize < 0xA00000L) {
            return CheckResult.WARNING;
        }
        if (streamsPoolSize != null && sgaTarget != null && streamsPoolSize == 0L) {
            return CheckResult.WARNING;
        }
        return CheckResult.PASS;
    }
}

