/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.dbinspector.checks;

import com.oracle.premigration.commons.enums.LockdownProfile;
import com.oracle.premigration.commons.enums.MigrationMethod;
import com.oracle.premigration.commons.enums.TargetCloud;
import com.oracle.premigration.dbinspector.Check;
import com.oracle.premigration.dbinspector.CheckResult;
import com.oracle.premigration.dbinspector.DatabaseObject;
import com.oracle.premigration.dbinspector.ExecutionContext;
import com.oracle.premigration.logger.PremigrationLogger;
import java.util.Arrays;

public class has_common_objects
extends Check {
    private static final PremigrationLogger log = PremigrationLogger.getLogger(has_common_objects.class.getName());

    public has_common_objects() {
        this.getLockdownProfiles().addAll(Arrays.asList(LockdownProfile.NONE, LockdownProfile.NOT_AUTONOMOUS));
        this.getTargetCloud().addAll(Arrays.asList(TargetCloud.ATPS, TargetCloud.ADWS, TargetCloud.ATPD, TargetCloud.ADWD, TargetCloud.DEFAULT));
        this.getMigrationMethods().addAll(Arrays.asList(MigrationMethod.DATAPUMP, MigrationMethod.DATAPUMP_DBLINK, MigrationMethod.GOLDENGATE));
        this.setScope(Check.Scope.INSTANCE);
        this.setDeclarativeResult(CheckResult.BLOCKER);
    }

    @Override
    public void prepare(ExecutionContext exeCtx) {
        boolean hasCommonColumn = exeCtx.hasDatabaseObject(DatabaseObject.builder().schema("SYS").table("DBA_USERS").column("COMMON").build());
        if (hasCommonColumn) {
            this.setSqlQuery("SELECT USERNAME AS OBJECT_NAME, 'USER' AS OBJECT_TYPE FROM SYS.DBA_USERS WHERE (COMMON='YES' OR UPPER(USERNAME) LIKE 'C##%') AND ORACLE_MAINTAINED <> 'Y'  UNION ALL  SELECT ROLE AS OBJECT_NAME, 'ROLE' AS OBJECT_TYPE FROM SYS.DBA_ROLES R WHERE (COMMON='YES' OR UPPER(ROLE) LIKE 'C##%') AND ORACLE_MAINTAINED <> 'Y'  UNION ALL  SELECT UNIQUE PROFILE AS OBJECT_NAME, 'PROFILE' AS OBJECT_TYPE FROM SYS.DBA_PROFILES WHERE COMMON='YES' OR UPPER(PROFILE) LIKE 'C##%' AND UPPER(PROFILE) NOT IN ('ORA_ADMIN_PROFILE','ORA_APP_PROFILE','ORA_MANDATORY_PROFILE')");
        } else {
            String skipReason = this.lang.txt("CHECK_SKIPPED_BECAUSE_OBJECT_MISSING", this.getName(), "COMMON", "COLUMN");
            this.skipCheck(skipReason, CheckResult.PASS);
        }
    }
}

