/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.dbinspector.checks;

import com.oracle.premigration.commons.enums.LockdownProfile;
import com.oracle.premigration.commons.enums.MigrationMethod;
import com.oracle.premigration.commons.enums.TargetCloud;
import com.oracle.premigration.dbinspector.Check;
import com.oracle.premigration.dbinspector.CheckResult;
import com.oracle.premigration.dbinspector.ExecutionContext;
import com.oracle.premigration.dbinspector.FilterableCheck;
import com.oracle.premigration.helpers.SqlUtils;
import com.oracle.premigration.reports.CheckFiltrationMetadata;
import java.util.Arrays;

public class has_basic_file_lobs
extends FilterableCheck {
    public has_basic_file_lobs() {
        this.getLockdownProfiles().addAll(Arrays.asList(LockdownProfile.NONE, LockdownProfile.NOT_AUTONOMOUS));
        this.getTargetCloud().addAll(Arrays.asList(TargetCloud.ADWD, TargetCloud.ADWS, TargetCloud.ATPD, TargetCloud.ATPS));
        this.getMigrationMethods().addAll(Arrays.asList(MigrationMethod.DATAPUMP, MigrationMethod.DATAPUMP_DBLINK, MigrationMethod.GOLDENGATE));
        this.setScope(Check.Scope.SCHEMA);
        this.setDeclarativeResult(CheckResult.INFORMATIONAL);
    }

    @Override
    public void initFiltrationMetadata() {
        this.setFiltrationMetadata(CheckFiltrationMetadata.builder().schemaOwnerColumn("OWNER").objectNameColumn("TABLE_NAME").objectTypeFixed("TABLE").build());
    }

    @Override
    public void prepare(ExecutionContext exeCtx) {
        String whereClause = SqlUtils.createWhereClauseForColumn(exeCtx, "LOBS.OWNER");
        String sqlQuery = "SELECT LOBS.OWNER, LOBS.TABLE_NAME, LOBS.COLUMN_NAME FROM SYS.DBA_LOBS LOBS, SYS.DBA_TABLES TABS " + whereClause + " AND LOBS.SECUREFILE = 'NO'  AND TABS.OWNER=LOBS.OWNER AND TABS.TABLE_NAME = LOBS.TABLE_NAME  AND NVL(TABS.TEMPORARY, 'N') <>'Y'  ORDER BY 1,2,3";
        this.setSqlQuery(sqlQuery);
    }
}

