/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.commons.lang;

import com.oracle.premigration.commons.io.StdUtil;
import com.oracle.premigration.exceptions.ConfigurationError;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

public class Language
implements Serializable {
    private static final long serialVersionUID = 358849365485784974L;
    private static Language instance = null;
    private final Map<String, String> nativeDictionary;
    private final Map<String, String> englishDictionary = new HashMap<String, String>();
    private final List<String> resourceFiles = new ArrayList<String>();
    private final List<String> supportedLanguages = Arrays.asList(SupportedLanguage.LANG_EN.getLanguage(), SupportedLanguage.LANG_ES.getLanguage(), SupportedLanguage.LANG_DE.getLanguage(), SupportedLanguage.LANG_FR.getLanguage(), SupportedLanguage.LANG_IT.getLanguage(), SupportedLanguage.LANG_JA.getLanguage(), SupportedLanguage.LANG_KO.getLanguage(), SupportedLanguage.LANG_PT.getLanguage() + "_" + SupportedCountry.COUNTRY_BR.getCountry(), SupportedLanguage.LANG_ZH.getLanguage() + "_" + SupportedCountry.COUNTRY_CN.getCountry(), SupportedLanguage.LANG_ZH.getLanguage() + "_" + SupportedCountry.COUNTRY_TW.getCountry());
    private String lang;

    private Language(String lang, String country) {
        this.lang = this.getLang(lang, country);
        this.nativeDictionary = lang.equalsIgnoreCase(SupportedLanguage.LANG_EN.getLanguage()) ? this.englishDictionary : new HashMap<String, String>();
    }

    private String getLang(String lang, String country) {
        if (lang == null) {
            return SupportedLanguage.LANG_EN.getLanguage();
        }
        SupportedLanguage sLang = SupportedLanguage.getSupportedLanguage(lang);
        switch (sLang) {
            case LANG_PT: {
                return SupportedLanguage.LANG_PT.getLanguage() + "_" + SupportedCountry.COUNTRY_BR.getCountry();
            }
            case LANG_ZH: {
                if (country == null) {
                    return SupportedLanguage.LANG_ZH.getLanguage() + "_" + SupportedCountry.COUNTRY_CN.getCountry();
                }
                if (country.equals(SupportedCountry.COUNTRY_TW.getCountry())) {
                    return SupportedLanguage.LANG_ZH.getLanguage() + "_" + SupportedCountry.COUNTRY_TW.getCountry();
                }
                return SupportedLanguage.LANG_ZH.getLanguage() + "_" + SupportedCountry.COUNTRY_CN.getCountry();
            }
        }
        return lang;
    }

    public static Language getInstance() {
        if (instance != null) {
            return instance;
        }
        instance = new Language(System.getProperty("user.language"), System.getProperty("user.country"));
        return instance;
    }

    public static void reset() {
        instance = null;
    }

    public static synchronized Language getInstanceWithDefaultResources() {
        Language lang = Language.getInstance();
        if (lang.englishDictionary.size() > 0) {
            return lang;
        }
        return lang.addResource("/general_messages").addResource("/check_messages").addResource("/error_messages").addResource("/text_report").populate();
    }

    public Language addResource(String resource) {
        this.resourceFiles.add(resource);
        return this;
    }

    public Language populate() {
        if (this.lang == null || this.lang.toLowerCase().equals("c")) {
            StdUtil.errPrintf("Language [%s] cannot be determined, defaulting to English\n", this.lang);
            this.lang = SupportedLanguage.LANG_EN.getLanguage();
        } else if (!this.supportedLanguages.contains(this.lang)) {
            StdUtil.errPrintf("Unsupported language [%s], defaulting to English\n", this.lang);
            this.lang = SupportedLanguage.LANG_EN.getLanguage();
        }
        if (this.resourceFiles.size() == 0) {
            StdUtil.errPrintln("No dictionary file loaded!");
            throw new IllegalStateException("No dictionary file loaded!");
        }
        try {
            for (String resource : this.resourceFiles) {
                String enPath = resource + ".properties";
                try (InputStream is = this.getClass().getResourceAsStream(enPath);){
                    this.populateDictionary(new PropertyResourceBundle(new InputStreamReader(is, StandardCharsets.UTF_8)), this.englishDictionary);
                }
                if (this.lang.equalsIgnoreCase(SupportedLanguage.LANG_EN.getLanguage())) continue;
                String path = resource + "_" + this.lang + ".properties";
                InputStream is = this.getClass().getResourceAsStream(path);
                Throwable throwable = null;
                try {
                    if (is == null) continue;
                    this.populateDictionary(new PropertyResourceBundle(new InputStreamReader(is, StandardCharsets.UTF_8)), this.nativeDictionary);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (is == null) continue;
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    is.close();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ConfigurationError("Unable to load message files.");
        }
        return this;
    }

    private void populateDictionary(ResourceBundle source, Map<String, String> dictionary) {
        Enumeration<String> keys = source.getKeys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            String oldVal1 = dictionary.put(key, source.getString(key));
            if (oldVal1 == null) continue;
            StdUtil.println("Overlapping Resource File (" + key + "). Exiting...");
            throw new IllegalStateException("Overlapping Resource File (" + key + "). Exiting...");
        }
    }

    public String txt(String StringKey) {
        if (this.nativeDictionary.containsKey(StringKey)) {
            return this.nativeDictionary.get(StringKey);
        }
        return this.entxt(StringKey);
    }

    public String txt(String StringKey, Object ... values) {
        if (this.nativeDictionary.containsKey(StringKey)) {
            if (values.length > 0) {
                return MessageFormat.format(this.nativeDictionary.get(StringKey), values);
            }
            return this.nativeDictionary.get(StringKey);
        }
        return this.entxt(StringKey, values);
    }

    public String entxt(String StringKey) {
        if (this.englishDictionary.containsKey(StringKey)) {
            return this.englishDictionary.get(StringKey);
        }
        return StringKey;
    }

    public String entxt(String StringKey, Object ... values) {
        if (this.englishDictionary.containsKey(StringKey)) {
            if (values.length > 0) {
                return MessageFormat.format(this.englishDictionary.get(StringKey), values);
            }
            return this.englishDictionary.get(StringKey);
        }
        return StringKey;
    }

    public static interface LangChoice {
        public String choice(String var1, Object ... var2);
    }

    public static enum SupportedCountry {
        COUNTRY_BR("BR"),
        COUNTRY_CN("CN"),
        COUNTRY_TW("TW");

        private final String country;

        private SupportedCountry(String country) {
            this.country = country;
        }

        public String getCountry() {
            return this.country;
        }
    }

    public static enum SupportedLanguage {
        LANG_EN("en"),
        LANG_ES("es"),
        LANG_DE("de"),
        LANG_FR("fr"),
        LANG_IT("it"),
        LANG_JA("ja"),
        LANG_KO("ko"),
        LANG_PT("pt"),
        LANG_ZH("zh");

        private final String language;

        private SupportedLanguage(String lang) {
            this.language = lang;
        }

        public String getLanguage() {
            return this.language;
        }

        public static SupportedLanguage getSupportedLanguage(String lang) {
            switch (lang) {
                case "es": {
                    return LANG_ES;
                }
                case "de": {
                    return LANG_DE;
                }
                case "fr": {
                    return LANG_FR;
                }
                case "it": {
                    return LANG_IT;
                }
                case "ja": {
                    return LANG_JA;
                }
                case "ko": {
                    return LANG_KO;
                }
                case "pt": {
                    return LANG_PT;
                }
                case "zh": {
                    return LANG_ZH;
                }
            }
            return LANG_EN;
        }
    }
}

