/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.commons.enums;

import java.util.ArrayList;
import java.util.List;

public enum Version {
    V10_1_0_2,
    V11_2_0_4,
    V12_1_0_1,
    V12_1_0_2,
    V12_2_0_1,
    V12_2_0_2,
    V18_1_0_0,
    V19_1_0_0,
    V19_6_0_0;

    List<Integer> versionInts;
    String dottedVersion = this.name().substring(1).replace("_", ".");

    private Version() {
        this.versionInts = Version.toList(this.dottedVersion);
    }

    public List<Integer> asList() {
        return this.versionInts;
    }

    public int compare(Version b) {
        return Version.compare(this.asList(), b.asList());
    }

    public int compare(String version) {
        List<Integer> b = Version.toList(version);
        return Version.compare(this.asList(), b);
    }

    public static int compare(List<Integer> a, List<Integer> b) {
        while (a.size() < b.size()) {
            a.add(0);
        }
        while (b.size() < a.size()) {
            b.add(0);
        }
        for (int i = 0; i < a.size(); ++i) {
            int b1;
            int a1 = a.get(i);
            if (a1 > (b1 = b.get(i).intValue())) {
                return 1;
            }
            if (a1 >= b1) continue;
            return -1;
        }
        return 0;
    }

    public static boolean betweenInclusive(String version, Version lowerBound, Version upperBound) {
        List<Integer> a = Version.toList(version);
        return Version.compare(a, lowerBound.asList()) >= 0 && Version.compare(a, upperBound.asList()) <= 0;
    }

    public static List<Integer> toList(String versionStr) {
        String[] split;
        ArrayList<Integer> version = new ArrayList<Integer>();
        String trimVersion = versionStr.trim();
        String canonicalVersion = trimVersion.endsWith(".") ? trimVersion + "0" : trimVersion;
        for (String element : split = canonicalVersion.split("\\.")) {
            version.add(Integer.parseInt(element));
        }
        return version;
    }

    public String toString() {
        return this.dottedVersion;
    }
}

