/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.cli;

import com.oracle.premigration.cli.CliOption;
import com.oracle.premigration.commons.EnvironmentContext;
import com.oracle.premigration.commons.enums.MigrationMethod;
import com.oracle.premigration.commons.enums.ReportFormat;
import com.oracle.premigration.commons.enums.TargetCloud;
import com.oracle.premigration.helpers.Utilities;
import com.oracle.premigration.logger.PremigrationLogger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;

public class CommandLineArgs {
    private static final PremigrationLogger log = PremigrationLogger.getLogger(CommandLineArgs.class.getName());
    private final String username;
    private final char[] password;
    private final String connectString;
    private final boolean sysdba;
    private final String pdbName;
    private final List<String> schemas;
    private final List<String> excludeSchemas;
    private final boolean help;
    private final boolean version;
    private final boolean simpleVersion;
    private final String compareVersion;
    private final boolean checkForUpdates;
    private final String outdir;
    private final String outFilePrefix;
    private TargetCloud targetCloud;
    private final List<MigrationMethod> migrationMethods;
    private final List<ReportFormat> reportFormats;
    private final boolean fetchTargetProps;
    private final String analysisPropertiesFile;
    private final boolean sqlInTextReport;
    private Integer maxTextRows;
    private final Level loggingLevel;
    private final boolean forceFull;
    private Integer maxRelevantObjects;

    public void nullifyPassword() {
        if (this.password != null) {
            Arrays.fill(this.password, '\u0000');
        }
    }

    public void nullifyAllSchemaNames() {
        if (this.schemas != null) {
            this.schemas.clear();
        }
        if (this.excludeSchemas != null) {
            this.excludeSchemas.clear();
        }
    }

    public String getReconstitutedArgs() {
        StringBuilder argBuf = new StringBuilder();
        if (this.connectString != null) {
            argBuf.append("--").append(CliOption.CONNECT_STRING.getLongOpt()).append(" ").append(this.connectString);
        }
        if (this.targetCloud != null) {
            argBuf.append(" --").append(CliOption.TARGET_CLOUD.getLongOpt()).append(" ").append(this.targetCloud);
        }
        if (this.username != null) {
            argBuf.append(" --").append(CliOption.USERNAME.getLongOpt()).append(" ").append(this.username);
        }
        if (this.sysdba) {
            argBuf.append(" --").append(CliOption.SYSDBA.getLongOpt());
        }
        if (this.fetchTargetProps) {
            argBuf.append(" --").append(CliOption.GETTARGETPROPS.getLongOpt());
        }
        if (this.analysisPropertiesFile != null) {
            argBuf.append(" --").append(CliOption.ANALYSISPROPS.getLongOpt()).append(" ").append(this.analysisPropertiesFile);
        }
        if (this.pdbName != null) {
            argBuf.append(" --").append(CliOption.PDBNAME.getLongOpt()).append(" ").append(this.pdbName);
        }
        if (this.forceFull) {
            argBuf.append(" --").append(CliOption.FULL.getLongOpt());
        }
        if (this.schemas != null && !this.schemas.isEmpty()) {
            argBuf.append(" --").append(CliOption.SCHEMAS.getLongOpt()).append(" ").append(Utilities.join(" ", this.schemas));
        }
        if (this.excludeSchemas != null && !this.excludeSchemas.isEmpty()) {
            argBuf.append(" --").append(CliOption.EXCLUDE_SCHEMAS.getLongOpt()).append(" ").append(Utilities.join(" ", this.excludeSchemas));
        }
        if (this.outdir != null && this.outdir.length() != 0) {
            argBuf.append(" --").append(CliOption.OUTDIR.getLongOpt()).append(" ").append(this.outdir);
        }
        if (this.loggingLevel != null) {
            argBuf.append(" --").append(CliOption.LOGGINGLEVEL.getLongOpt()).append(" ").append(this.loggingLevel.getName());
        }
        if (this.outFilePrefix != null) {
            argBuf.append(" --").append(CliOption.OUTFILEPREFIX.getLongOpt()).append(" ").append(this.outFilePrefix);
        }
        if (this.migrationMethods != null && !this.migrationMethods.isEmpty()) {
            argBuf.append(" --").append(CliOption.MIGRATION_METHOD.getLongOpt()).append(" ").append(Utilities.join(" ", this.migrationMethods));
        }
        if (this.reportFormats != null && !this.reportFormats.isEmpty()) {
            argBuf.append(" --").append(CliOption.REPORT_FORMAT.getLongOpt());
            for (ReportFormat reportFormat : this.reportFormats) {
                argBuf.append(" ").append(reportFormat);
            }
        }
        if (this.maxTextRows != null) {
            argBuf.append(" --").append(CliOption.MAXTEXTROWS.getLongOpt()).append(" ").append(this.maxTextRows);
        }
        if (this.maxRelevantObjects != null) {
            argBuf.append(" --").append(CliOption.MAXRELEVANTOBJECTS.getLongOpt()).append(" ").append(this.maxRelevantObjects);
        }
        if (this.sqlInTextReport) {
            argBuf.append(" --").append(CliOption.SQL_IN_TEXT_REPORT.getLongOpt());
        }
        if (this.help) {
            argBuf.append(" --").append(CliOption.HELP.getLongOpt());
        }
        if (this.version) {
            argBuf.append(" --").append(CliOption.VERSION.getLongOpt());
        }
        if (this.simpleVersion) {
            argBuf.append(" --").append(CliOption.SIMPLE_VERSION.getLongOpt());
        }
        if (this.compareVersion != null && !this.compareVersion.isEmpty()) {
            argBuf.append(" --").append(CliOption.COMPARE_VERSION.getLongOpt()).append(" ").append(this.compareVersion);
        }
        if (this.checkForUpdates) {
            argBuf.append(" --").append(CliOption.UPDATE_CHECK.getLongOpt());
        }
        return argBuf.toString();
    }

    public void validate(EnvironmentContext envCtx) {
        String errorMessage;
        if (this.maxTextRows != null && !this.reportFormats.contains(ReportFormat.TEXT)) {
            errorMessage = Utilities.getErrorText("ERROR1009", new String[0]);
            Utilities.printAndLogErrorMessage(errorMessage, envCtx, Level.INFO);
            this.maxTextRows = null;
        }
        if (this.maxTextRows != null && this.maxTextRows < 0) {
            errorMessage = Utilities.getErrorText("ERROR1008", "--" + CliOption.MAXTEXTROWS.getLongOpt());
            Utilities.printAndLogErrorMessage(errorMessage, envCtx, Level.INFO);
            this.maxTextRows = null;
        }
        if (this.maxRelevantObjects != null && this.maxRelevantObjects < 0) {
            errorMessage = Utilities.getErrorText("ERROR1008", "--" + CliOption.MAXRELEVANTOBJECTS.getLongOpt());
            log.info(errorMessage);
            System.err.println(errorMessage);
            this.maxRelevantObjects = null;
        }
        if (this.maxTextRows != null && this.maxRelevantObjects != null && this.maxRelevantObjects < this.maxTextRows) {
            errorMessage = Utilities.getErrorText("ERROR1012", new String[0]);
            Utilities.printAndLogErrorMessage(errorMessage, envCtx, Level.INFO);
            this.maxTextRows = this.maxRelevantObjects;
        }
        if (this.maxTextRows == null && this.maxRelevantObjects != null && this.reportFormats.contains(ReportFormat.TEXT)) {
            this.maxTextRows = this.maxRelevantObjects;
        }
        if (this.migrationMethods != null && this.migrationMethods.contains(MigrationMethod.DATAPUMP) && this.migrationMethods.contains(MigrationMethod.DATAPUMP_DBLINK)) {
            errorMessage = Utilities.getErrorText("ERROR1010", new String[0]);
            Utilities.printAndLogErrorMessage(errorMessage, envCtx, Level.INFO);
            this.migrationMethods.remove(MigrationMethod.DATAPUMP);
        }
    }

    CommandLineArgs(String username, char[] password, String connectString, boolean sysdba, String pdbName, List<String> schemas, List<String> excludeSchemas, boolean help, boolean version, boolean simpleVersion, String compareVersion, boolean checkForUpdates, String outdir, String outFilePrefix, TargetCloud targetCloud, List<MigrationMethod> migrationMethods, List<ReportFormat> reportFormats, boolean fetchTargetProps, String analysisPropertiesFile, boolean sqlInTextReport, Integer maxTextRows, Level loggingLevel, boolean forceFull, Integer maxRelevantObjects) {
        this.username = username;
        this.password = password;
        this.connectString = connectString;
        this.sysdba = sysdba;
        this.pdbName = pdbName;
        this.schemas = schemas;
        this.excludeSchemas = excludeSchemas;
        this.help = help;
        this.version = version;
        this.simpleVersion = simpleVersion;
        this.compareVersion = compareVersion;
        this.checkForUpdates = checkForUpdates;
        this.outdir = outdir;
        this.outFilePrefix = outFilePrefix;
        this.targetCloud = targetCloud;
        this.migrationMethods = migrationMethods;
        this.reportFormats = reportFormats;
        this.fetchTargetProps = fetchTargetProps;
        this.analysisPropertiesFile = analysisPropertiesFile;
        this.sqlInTextReport = sqlInTextReport;
        this.maxTextRows = maxTextRows;
        this.loggingLevel = loggingLevel;
        this.forceFull = forceFull;
        this.maxRelevantObjects = maxRelevantObjects;
    }

    public static CommandLineArgsBuilder builder() {
        return new CommandLineArgsBuilder();
    }

    public String getUsername() {
        return this.username;
    }

    public char[] getPassword() {
        return this.password;
    }

    public String getConnectString() {
        return this.connectString;
    }

    public boolean isSysdba() {
        return this.sysdba;
    }

    public String getPdbName() {
        return this.pdbName;
    }

    public List<String> getSchemas() {
        return this.schemas;
    }

    public List<String> getExcludeSchemas() {
        return this.excludeSchemas;
    }

    public boolean isHelp() {
        return this.help;
    }

    public boolean isVersion() {
        return this.version;
    }

    public boolean isSimpleVersion() {
        return this.simpleVersion;
    }

    public String getCompareVersion() {
        return this.compareVersion;
    }

    public boolean isCheckForUpdates() {
        return this.checkForUpdates;
    }

    public String getOutdir() {
        return this.outdir;
    }

    public String getOutFilePrefix() {
        return this.outFilePrefix;
    }

    public TargetCloud getTargetCloud() {
        return this.targetCloud;
    }

    public List<MigrationMethod> getMigrationMethods() {
        return this.migrationMethods;
    }

    public List<ReportFormat> getReportFormats() {
        return this.reportFormats;
    }

    public boolean isFetchTargetProps() {
        return this.fetchTargetProps;
    }

    public String getAnalysisPropertiesFile() {
        return this.analysisPropertiesFile;
    }

    public boolean isSqlInTextReport() {
        return this.sqlInTextReport;
    }

    public Integer getMaxTextRows() {
        return this.maxTextRows;
    }

    public Level getLoggingLevel() {
        return this.loggingLevel;
    }

    public boolean isForceFull() {
        return this.forceFull;
    }

    public Integer getMaxRelevantObjects() {
        return this.maxRelevantObjects;
    }

    public void setTargetCloud(TargetCloud targetCloud) {
        this.targetCloud = targetCloud;
    }

    public void setMaxTextRows(Integer maxTextRows) {
        this.maxTextRows = maxTextRows;
    }

    public void setMaxRelevantObjects(Integer maxRelevantObjects) {
        this.maxRelevantObjects = maxRelevantObjects;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CommandLineArgs)) {
            return false;
        }
        CommandLineArgs other = (CommandLineArgs)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isSysdba() != other.isSysdba()) {
            return false;
        }
        if (this.isHelp() != other.isHelp()) {
            return false;
        }
        if (this.isVersion() != other.isVersion()) {
            return false;
        }
        if (this.isSimpleVersion() != other.isSimpleVersion()) {
            return false;
        }
        if (this.isCheckForUpdates() != other.isCheckForUpdates()) {
            return false;
        }
        if (this.isFetchTargetProps() != other.isFetchTargetProps()) {
            return false;
        }
        if (this.isSqlInTextReport() != other.isSqlInTextReport()) {
            return false;
        }
        if (this.isForceFull() != other.isForceFull()) {
            return false;
        }
        Integer this$maxTextRows = this.getMaxTextRows();
        Integer other$maxTextRows = other.getMaxTextRows();
        if (this$maxTextRows == null ? other$maxTextRows != null : !((Object)this$maxTextRows).equals(other$maxTextRows)) {
            return false;
        }
        Integer this$maxRelevantObjects = this.getMaxRelevantObjects();
        Integer other$maxRelevantObjects = other.getMaxRelevantObjects();
        if (this$maxRelevantObjects == null ? other$maxRelevantObjects != null : !((Object)this$maxRelevantObjects).equals(other$maxRelevantObjects)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        if (!Arrays.equals(this.getPassword(), other.getPassword())) {
            return false;
        }
        String this$connectString = this.getConnectString();
        String other$connectString = other.getConnectString();
        if (this$connectString == null ? other$connectString != null : !this$connectString.equals(other$connectString)) {
            return false;
        }
        String this$pdbName = this.getPdbName();
        String other$pdbName = other.getPdbName();
        if (this$pdbName == null ? other$pdbName != null : !this$pdbName.equals(other$pdbName)) {
            return false;
        }
        List<String> this$schemas = this.getSchemas();
        List<String> other$schemas = other.getSchemas();
        if (this$schemas == null ? other$schemas != null : !((Object)this$schemas).equals(other$schemas)) {
            return false;
        }
        List<String> this$excludeSchemas = this.getExcludeSchemas();
        List<String> other$excludeSchemas = other.getExcludeSchemas();
        if (this$excludeSchemas == null ? other$excludeSchemas != null : !((Object)this$excludeSchemas).equals(other$excludeSchemas)) {
            return false;
        }
        String this$compareVersion = this.getCompareVersion();
        String other$compareVersion = other.getCompareVersion();
        if (this$compareVersion == null ? other$compareVersion != null : !this$compareVersion.equals(other$compareVersion)) {
            return false;
        }
        String this$outdir = this.getOutdir();
        String other$outdir = other.getOutdir();
        if (this$outdir == null ? other$outdir != null : !this$outdir.equals(other$outdir)) {
            return false;
        }
        String this$outFilePrefix = this.getOutFilePrefix();
        String other$outFilePrefix = other.getOutFilePrefix();
        if (this$outFilePrefix == null ? other$outFilePrefix != null : !this$outFilePrefix.equals(other$outFilePrefix)) {
            return false;
        }
        TargetCloud this$targetCloud = this.getTargetCloud();
        TargetCloud other$targetCloud = other.getTargetCloud();
        if (this$targetCloud == null ? other$targetCloud != null : !this$targetCloud.equals(other$targetCloud)) {
            return false;
        }
        List<MigrationMethod> this$migrationMethods = this.getMigrationMethods();
        List<MigrationMethod> other$migrationMethods = other.getMigrationMethods();
        if (this$migrationMethods == null ? other$migrationMethods != null : !((Object)this$migrationMethods).equals(other$migrationMethods)) {
            return false;
        }
        List<ReportFormat> this$reportFormats = this.getReportFormats();
        List<ReportFormat> other$reportFormats = other.getReportFormats();
        if (this$reportFormats == null ? other$reportFormats != null : !((Object)this$reportFormats).equals(other$reportFormats)) {
            return false;
        }
        String this$analysisPropertiesFile = this.getAnalysisPropertiesFile();
        String other$analysisPropertiesFile = other.getAnalysisPropertiesFile();
        if (this$analysisPropertiesFile == null ? other$analysisPropertiesFile != null : !this$analysisPropertiesFile.equals(other$analysisPropertiesFile)) {
            return false;
        }
        Level this$loggingLevel = this.getLoggingLevel();
        Level other$loggingLevel = other.getLoggingLevel();
        return !(this$loggingLevel == null ? other$loggingLevel != null : !((Object)this$loggingLevel).equals(other$loggingLevel));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CommandLineArgs;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isSysdba() ? 79 : 97);
        result = result * 59 + (this.isHelp() ? 79 : 97);
        result = result * 59 + (this.isVersion() ? 79 : 97);
        result = result * 59 + (this.isSimpleVersion() ? 79 : 97);
        result = result * 59 + (this.isCheckForUpdates() ? 79 : 97);
        result = result * 59 + (this.isFetchTargetProps() ? 79 : 97);
        result = result * 59 + (this.isSqlInTextReport() ? 79 : 97);
        result = result * 59 + (this.isForceFull() ? 79 : 97);
        Integer $maxTextRows = this.getMaxTextRows();
        result = result * 59 + ($maxTextRows == null ? 43 : ((Object)$maxTextRows).hashCode());
        Integer $maxRelevantObjects = this.getMaxRelevantObjects();
        result = result * 59 + ($maxRelevantObjects == null ? 43 : ((Object)$maxRelevantObjects).hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        result = result * 59 + Arrays.hashCode(this.getPassword());
        String $connectString = this.getConnectString();
        result = result * 59 + ($connectString == null ? 43 : $connectString.hashCode());
        String $pdbName = this.getPdbName();
        result = result * 59 + ($pdbName == null ? 43 : $pdbName.hashCode());
        List<String> $schemas = this.getSchemas();
        result = result * 59 + ($schemas == null ? 43 : ((Object)$schemas).hashCode());
        List<String> $excludeSchemas = this.getExcludeSchemas();
        result = result * 59 + ($excludeSchemas == null ? 43 : ((Object)$excludeSchemas).hashCode());
        String $compareVersion = this.getCompareVersion();
        result = result * 59 + ($compareVersion == null ? 43 : $compareVersion.hashCode());
        String $outdir = this.getOutdir();
        result = result * 59 + ($outdir == null ? 43 : $outdir.hashCode());
        String $outFilePrefix = this.getOutFilePrefix();
        result = result * 59 + ($outFilePrefix == null ? 43 : $outFilePrefix.hashCode());
        TargetCloud $targetCloud = this.getTargetCloud();
        result = result * 59 + ($targetCloud == null ? 43 : $targetCloud.hashCode());
        List<MigrationMethod> $migrationMethods = this.getMigrationMethods();
        result = result * 59 + ($migrationMethods == null ? 43 : ((Object)$migrationMethods).hashCode());
        List<ReportFormat> $reportFormats = this.getReportFormats();
        result = result * 59 + ($reportFormats == null ? 43 : ((Object)$reportFormats).hashCode());
        String $analysisPropertiesFile = this.getAnalysisPropertiesFile();
        result = result * 59 + ($analysisPropertiesFile == null ? 43 : $analysisPropertiesFile.hashCode());
        Level $loggingLevel = this.getLoggingLevel();
        result = result * 59 + ($loggingLevel == null ? 43 : ((Object)$loggingLevel).hashCode());
        return result;
    }

    public String toString() {
        return "CommandLineArgs(username=" + this.getUsername() + ", password=" + Arrays.toString(this.getPassword()) + ", connectString=" + this.getConnectString() + ", sysdba=" + this.isSysdba() + ", pdbName=" + this.getPdbName() + ", schemas=" + this.getSchemas() + ", excludeSchemas=" + this.getExcludeSchemas() + ", help=" + this.isHelp() + ", version=" + this.isVersion() + ", simpleVersion=" + this.isSimpleVersion() + ", compareVersion=" + this.getCompareVersion() + ", checkForUpdates=" + this.isCheckForUpdates() + ", outdir=" + this.getOutdir() + ", outFilePrefix=" + this.getOutFilePrefix() + ", targetCloud=" + this.getTargetCloud() + ", migrationMethods=" + this.getMigrationMethods() + ", reportFormats=" + this.getReportFormats() + ", fetchTargetProps=" + this.isFetchTargetProps() + ", analysisPropertiesFile=" + this.getAnalysisPropertiesFile() + ", sqlInTextReport=" + this.isSqlInTextReport() + ", maxTextRows=" + this.getMaxTextRows() + ", loggingLevel=" + this.getLoggingLevel() + ", forceFull=" + this.isForceFull() + ", maxRelevantObjects=" + this.getMaxRelevantObjects() + ")";
    }

    public static class CommandLineArgsBuilder {
        private String username;
        private char[] password;
        private String connectString;
        private boolean sysdba;
        private String pdbName;
        private List<String> schemas;
        private List<String> excludeSchemas;
        private boolean help;
        private boolean version;
        private boolean simpleVersion;
        private String compareVersion;
        private boolean checkForUpdates;
        private String outdir;
        private String outFilePrefix;
        private TargetCloud targetCloud;
        private ArrayList<MigrationMethod> migrationMethods;
        private ArrayList<ReportFormat> reportFormats;
        private boolean fetchTargetProps;
        private String analysisPropertiesFile;
        private boolean sqlInTextReport;
        private Integer maxTextRows;
        private Level loggingLevel;
        private boolean forceFull;
        private Integer maxRelevantObjects;

        CommandLineArgsBuilder() {
        }

        public CommandLineArgsBuilder username(String username) {
            this.username = username;
            return this;
        }

        public CommandLineArgsBuilder password(char[] password) {
            this.password = password;
            return this;
        }

        public CommandLineArgsBuilder connectString(String connectString) {
            this.connectString = connectString;
            return this;
        }

        public CommandLineArgsBuilder sysdba(boolean sysdba) {
            this.sysdba = sysdba;
            return this;
        }

        public CommandLineArgsBuilder pdbName(String pdbName) {
            this.pdbName = pdbName;
            return this;
        }

        public CommandLineArgsBuilder schemas(List<String> schemas) {
            this.schemas = schemas;
            return this;
        }

        public CommandLineArgsBuilder excludeSchemas(List<String> excludeSchemas) {
            this.excludeSchemas = excludeSchemas;
            return this;
        }

        public CommandLineArgsBuilder help(boolean help) {
            this.help = help;
            return this;
        }

        public CommandLineArgsBuilder version(boolean version) {
            this.version = version;
            return this;
        }

        public CommandLineArgsBuilder simpleVersion(boolean simpleVersion) {
            this.simpleVersion = simpleVersion;
            return this;
        }

        public CommandLineArgsBuilder compareVersion(String compareVersion) {
            this.compareVersion = compareVersion;
            return this;
        }

        public CommandLineArgsBuilder checkForUpdates(boolean checkForUpdates) {
            this.checkForUpdates = checkForUpdates;
            return this;
        }

        public CommandLineArgsBuilder outdir(String outdir) {
            this.outdir = outdir;
            return this;
        }

        public CommandLineArgsBuilder outFilePrefix(String outFilePrefix) {
            this.outFilePrefix = outFilePrefix;
            return this;
        }

        public CommandLineArgsBuilder targetCloud(TargetCloud targetCloud) {
            this.targetCloud = targetCloud;
            return this;
        }

        public CommandLineArgsBuilder migrationMethod(MigrationMethod migrationMethod) {
            if (this.migrationMethods == null) {
                this.migrationMethods = new ArrayList();
            }
            this.migrationMethods.add(migrationMethod);
            return this;
        }

        public CommandLineArgsBuilder migrationMethods(Collection<? extends MigrationMethod> migrationMethods) {
            if (migrationMethods == null) {
                throw new NullPointerException("migrationMethods cannot be null");
            }
            if (this.migrationMethods == null) {
                this.migrationMethods = new ArrayList();
            }
            this.migrationMethods.addAll(migrationMethods);
            return this;
        }

        public CommandLineArgsBuilder clearMigrationMethods() {
            if (this.migrationMethods != null) {
                this.migrationMethods.clear();
            }
            return this;
        }

        public CommandLineArgsBuilder reportFormat(ReportFormat reportFormat) {
            if (this.reportFormats == null) {
                this.reportFormats = new ArrayList();
            }
            this.reportFormats.add(reportFormat);
            return this;
        }

        public CommandLineArgsBuilder reportFormats(Collection<? extends ReportFormat> reportFormats) {
            if (reportFormats == null) {
                throw new NullPointerException("reportFormats cannot be null");
            }
            if (this.reportFormats == null) {
                this.reportFormats = new ArrayList();
            }
            this.reportFormats.addAll(reportFormats);
            return this;
        }

        public CommandLineArgsBuilder clearReportFormats() {
            if (this.reportFormats != null) {
                this.reportFormats.clear();
            }
            return this;
        }

        public CommandLineArgsBuilder fetchTargetProps(boolean fetchTargetProps) {
            this.fetchTargetProps = fetchTargetProps;
            return this;
        }

        public CommandLineArgsBuilder analysisPropertiesFile(String analysisPropertiesFile) {
            this.analysisPropertiesFile = analysisPropertiesFile;
            return this;
        }

        public CommandLineArgsBuilder sqlInTextReport(boolean sqlInTextReport) {
            this.sqlInTextReport = sqlInTextReport;
            return this;
        }

        public CommandLineArgsBuilder maxTextRows(Integer maxTextRows) {
            this.maxTextRows = maxTextRows;
            return this;
        }

        public CommandLineArgsBuilder loggingLevel(Level loggingLevel) {
            this.loggingLevel = loggingLevel;
            return this;
        }

        public CommandLineArgsBuilder forceFull(boolean forceFull) {
            this.forceFull = forceFull;
            return this;
        }

        public CommandLineArgsBuilder maxRelevantObjects(Integer maxRelevantObjects) {
            this.maxRelevantObjects = maxRelevantObjects;
            return this;
        }

        public CommandLineArgs build() {
            List<ReportFormat> reportFormats;
            List<MigrationMethod> migrationMethods;
            switch (this.migrationMethods == null ? 0 : this.migrationMethods.size()) {
                case 0: {
                    migrationMethods = Collections.emptyList();
                    break;
                }
                case 1: {
                    migrationMethods = Collections.singletonList(this.migrationMethods.get(0));
                    break;
                }
                default: {
                    migrationMethods = Collections.unmodifiableList(new ArrayList<MigrationMethod>(this.migrationMethods));
                }
            }
            switch (this.reportFormats == null ? 0 : this.reportFormats.size()) {
                case 0: {
                    reportFormats = Collections.emptyList();
                    break;
                }
                case 1: {
                    reportFormats = Collections.singletonList(this.reportFormats.get(0));
                    break;
                }
                default: {
                    reportFormats = Collections.unmodifiableList(new ArrayList<ReportFormat>(this.reportFormats));
                }
            }
            return new CommandLineArgs(this.username, this.password, this.connectString, this.sysdba, this.pdbName, this.schemas, this.excludeSchemas, this.help, this.version, this.simpleVersion, this.compareVersion, this.checkForUpdates, this.outdir, this.outFilePrefix, this.targetCloud, migrationMethods, reportFormats, this.fetchTargetProps, this.analysisPropertiesFile, this.sqlInTextReport, this.maxTextRows, this.loggingLevel, this.forceFull, this.maxRelevantObjects);
        }

        public String toString() {
            return "CommandLineArgs.CommandLineArgsBuilder(username=" + this.username + ", password=" + Arrays.toString(this.password) + ", connectString=" + this.connectString + ", sysdba=" + this.sysdba + ", pdbName=" + this.pdbName + ", schemas=" + this.schemas + ", excludeSchemas=" + this.excludeSchemas + ", help=" + this.help + ", version=" + this.version + ", simpleVersion=" + this.simpleVersion + ", compareVersion=" + this.compareVersion + ", checkForUpdates=" + this.checkForUpdates + ", outdir=" + this.outdir + ", outFilePrefix=" + this.outFilePrefix + ", targetCloud=" + this.targetCloud + ", migrationMethods=" + this.migrationMethods + ", reportFormats=" + this.reportFormats + ", fetchTargetProps=" + this.fetchTargetProps + ", analysisPropertiesFile=" + this.analysisPropertiesFile + ", sqlInTextReport=" + this.sqlInTextReport + ", maxTextRows=" + this.maxTextRows + ", loggingLevel=" + this.loggingLevel + ", forceFull=" + this.forceFull + ", maxRelevantObjects=" + this.maxRelevantObjects + ")";
        }
    }
}

