/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.scriptrunner.commands;

import java.sql.Connection;
import java.text.MessageFormat;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.IStoreCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.StoreRegistry;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;
import oracle.dbtools.raptor.scriptrunner.commands.Messages;

public class SetEditFile
extends CommandListener
implements IShowCommand,
IStoreCommand {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private String[] aliases = new String[]{"editf", "editfile"};

    @Override
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        String[] tokens = cmd.getSql().split("\\s+", 3);
        if (tokens.length != 3) {
            ctx.write(Messages.getString("SetEditFile.3"));
        } else {
            String token = tokens[2];
            if (token.startsWith("\"") && !token.endsWith("\"")) {
                ctx.write(MessageFormat.format("string \"{0}\" missing terminating quote (\").\n", token));
                ctx.write(Messages.getString("SetEditFile.4"));
                return true;
            }
            if (token.startsWith("'") && !token.endsWith("'")) {
                ctx.write(MessageFormat.format("string \"{0}\" missing terminating quote (').\n", token));
                ctx.write(Messages.getString("SetEditFile.5"));
                return true;
            }
            if (!token.startsWith("\"") && token.endsWith("\"") || !token.startsWith("'") && token.endsWith("'")) {
                ctx.write(MessageFormat.format("string \"{0}\" has trailing quote and missing starting quote.\n", token) + LINE_SEPARATOR);
                ctx.write(Messages.getString("SetEditFile.6"));
                return true;
            }
            String input = token;
            if (token.length() >= 2 && (token.startsWith("\"") && token.endsWith("\"") || token.startsWith("'") && token.endsWith("'"))) {
                input = input.substring(1, input.length() - 1);
            }
            if (input.trim().length() > 0) {
                ctx.putProperty("script.runner.file.editfile", input);
            } else {
                ctx.write(Messages.getString("SetEditFile.7"));
            }
        }
        return true;
    }

    @Override
    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public String[] getShowAliases() {
        return this.aliases;
    }

    @Override
    public boolean handleShow(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        ctx.write(MessageFormat.format("editfile \"{0}\"\n", ctx.getProperty("script.runner.file.editfile")));
        return false;
    }

    @Override
    public boolean needsDatabase() {
        return false;
    }

    @Override
    public boolean inShowAll() {
        return true;
    }

    @Override
    public String getStoreCommand(ScriptRunnerContext ctx) {
        return StoreRegistry.getCommand("editfile", MessageFormat.format("\"{0}\"", String.valueOf(ctx.getProperty("script.runner.file.editfile"))));
    }
}

