/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.scriptrunner.commands;

import java.sql.Connection;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import oracle.dbtools.commands.CloudStorageCommand;
import oracle.dbtools.http.CloudStorageUrl;
import oracle.dbtools.oci.OCIProfiles;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;
import oracle.dbtools.raptor.scriptrunner.commands.Messages;

public class SetCloudStorage
extends CommandListener
implements IShowCommand {
    private static final String CLEAR = "clear";
    private static final String DBMS_CLOUD = "dbms_cloud";
    private static final String OCI = "oci";
    private static final String SWIFT = "swift";
    private static final String QUALIFIER = "qualifier";
    private static final String Q = "q";
    public static final String ACCESS_METHOD = "access_method";
    public static final String CREDENTIAL = "credential";
    public static final String PASSWORD = "password";
    public static final String PROFILE = "profile";
    public static final String SECTION = "section";
    public static final String CLOUD_STR = "cloud_str";
    public static final String CLOUD_URL = "cloud_url";
    public static final String USER = "user";
    private static final String DQUOTE = "\"";
    private static final String SQUOTE = "'";
    private static final String NL = "\n";
    private static final String SPACE = " ";
    private Map<String, Object> _props = new HashMap<String, Object>();

    @Override
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        return false;
    }

    public boolean handleEventDisabled(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        String cmdTrimmed = cmd.getLoweredTrimmedNoWhitespaceSQL();
        if (cmdTrimmed.startsWith("setcloudstorage") || cmdTrimmed.startsWith("setcs") || cmdTrimmed.startsWith("setcloud_storage")) {
            String[] parts = cmd.getSQLOrig().split(SPACE);
            if (parts.length < 3 || parts.length == 3 && parts[2].equalsIgnoreCase(CLEAR)) {
                ctx.write(Messages.getString("CLOUDSTORAGECLEARED"));
                ctx.removeProperty("cloud.storage");
                return true;
            }
            this._props = (Map)ctx.getProperty("cloud.storage");
            if (this._props == null) {
                this._props = new HashMap<String, Object>();
            }
            boolean triedUrl = false;
            String[] bits = cmd.getSql().split("\\s+");
            int skip = 2;
            while (bits != null && bits.length > 0) {
                try {
                    switch (bits[skip].toLowerCase()) {
                        case "dbms_cloud": {
                            if (bits.length < skip + 2) {
                                this.writeFormatMissing(ctx, bits[skip]);
                                return true;
                            }
                            this._props.put(ACCESS_METHOD, DBMS_CLOUD);
                            this._props.put(CREDENTIAL, bits[skip + 1]);
                            bits = this.nextBits(bits, skip + 2);
                            ctx.putProperty("cloud.storage", this._props);
                            break;
                        }
                        case "oci": {
                            this._props.put(ACCESS_METHOD, OCI);
                            String section = "ROOT";
                            if (bits.length > skip + 1 && !this.isAnyOption(bits[skip + 1])) {
                                section = bits[skip + 1];
                                this._props.put(SECTION, section);
                                bits = this.nextBits(bits, skip + 2);
                            } else {
                                bits = this.nextBits(bits, skip + 1);
                            }
                            ctx.putProperty("cloud.storage", this._props);
                            this.validateProfile(ctx, section);
                            break;
                        }
                        case "swift": {
                            if (bits.length < skip + 3) {
                                this.writeFormatMissing(ctx, bits[skip]);
                                return true;
                            }
                            this._props.put(ACCESS_METHOD, SWIFT);
                            this._props.put(USER, bits[skip + 1]);
                            this._props.put(PASSWORD, bits[skip + 2]);
                            bits = this.nextBits(bits, skip + 3);
                            ctx.putProperty("cloud.storage", this._props);
                            break;
                        }
                        case "cloud_url": {
                            CloudStorageUrl cloudUrl;
                            if (bits.length < skip + 2) {
                                this.writeFormatMissing(ctx, bits[skip]);
                                return true;
                            }
                            try {
                                this._props.put(CLOUD_STR, bits[skip + 1]);
                                cloudUrl = new CloudStorageUrl(bits[skip + 1]);
                                this._props.put(CLOUD_URL, cloudUrl);
                            }
                            catch (Exception e) {
                                ctx.write(bits[skip + 1] + e.getLocalizedMessage());
                            }
                            bits = this.nextBits(bits, skip + 2);
                            ctx.putProperty("cloud.storage", this._props);
                            break;
                        }
                        default: {
                            CloudStorageUrl cloudUrl;
                            try {
                                this._props.put(CLOUD_STR, bits[skip]);
                                cloudUrl = new CloudStorageUrl(bits[skip]);
                                this._props.put(CLOUD_URL, cloudUrl);
                            }
                            catch (Exception e) {
                                ctx.write(bits[skip + 1] + e.getLocalizedMessage());
                            }
                            bits = this.nextBits(bits, skip + 1);
                            ctx.putProperty("cloud.storage", this._props);
                            break;
                        }
                    }
                }
                catch (Exception e) {
                    this.writeFormatBad(ctx, bits.length > 0 ? bits[skip] : "");
                    return true;
                }
                skip = 0;
            }
            return true;
        }
        return false;
    }

    private void writeFormatMissing(ScriptRunnerContext ctx, String option) {
        ctx.write(MessageFormat.format(Messages.getString("LOADMISSINGVALUE"), option) + NL);
    }

    private void writeFormatBad(ScriptRunnerContext ctx, String option) {
        ctx.write(MessageFormat.format(Messages.getString("LOADFORMATBAD"), option) + NL);
    }

    private String unQuote(String word) {
        if (word.startsWith(SQUOTE) && word.endsWith(SQUOTE)) {
            return word.substring(1, word.length() - 1);
        }
        if (word.startsWith(DQUOTE) && word.endsWith(DQUOTE)) {
            return word.substring(1, word.length() - 1);
        }
        return word;
    }

    private String[] nextBits(String[] bits, int skip) {
        if (bits.length > skip) {
            String[] rtn = new String[bits.length - skip];
            for (int j = 0; rtn.length > j; ++j) {
                rtn[j] = bits[j + skip];
            }
            return rtn;
        }
        return null;
    }

    private boolean isAnyOption(String word) {
        try {
            switch (word) {
                case "dbms_cloud": 
                case "oci": 
                case "swift": 
                case "cloud_url": {
                    return true;
                }
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    private boolean validateProfile(ScriptRunnerContext ctx, String section) {
        OCIProfiles profiles = new OCIProfiles();
        try {
            ArrayList<String> sections = profiles.getProfiles();
            return sections.contains(section);
        }
        catch (Exception e) {
            ctx.write("Profile Error:" + e.getLocalizedMessage());
            return false;
        }
    }

    @Override
    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public boolean handleShow(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        String cmdTrimmed = cmd.getLoweredTrimmedNoWhitespaceSQL();
        if (cmdTrimmed.startsWith("showcloudstorage") || cmdTrimmed.startsWith("showcs") || cmdTrimmed.startsWith("showcloud_storage")) {
            String[] parts = cmd.getSQLOrig().split(SPACE);
            String qualifier = null;
            if (parts.length > 3 && (parts[2].equalsIgnoreCase(QUALIFIER) || parts[2].equalsIgnoreCase(Q))) {
                qualifier = parts[3];
            }
            CloudStorageCommand csc = new CloudStorageCommand();
            csc.handleShow(ctx, qualifier);
            return true;
        }
        return false;
    }

    @Override
    public String[] getShowAliases() {
        return new String[]{"cloudstorage", "cs", "cloud_storage"};
    }

    @Override
    public boolean needsDatabase() {
        return false;
    }

    @Override
    public boolean inShowAll() {
        return true;
    }
}

