/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.console;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import oracle.dbtools.raptor.console.Formatter;
import oracle.dbtools.raptor.console.HistoryItem;

public class DefaultFormatter
implements Formatter {
    private final Mode mode;
    private final boolean showSessionOnly;
    private final Boolean showFails;
    private int maxNumberOfOccurances = 0;
    private int maxFormattedDurationLength = 0;
    private final Map<HistoryItem, String> formattedDurations = new HashMap<HistoryItem, String>();

    private DefaultFormatter(Mode mode, Boolean showFails, boolean showSessionOnly) {
        this.mode = mode;
        this.showFails = showFails;
        this.showSessionOnly = showSessionOnly;
    }

    @Override
    public boolean filter(Formatter.Context context, HistoryItem item) {
        if (item.status() == HistoryItem.Status.PENDING || !this.isShowFails(context) && item.status() == HistoryItem.Status.ERROR) {
            return false;
        }
        return !this.showSessionOnly || item.isCurrentSession();
    }

    @Override
    public void prepare(Formatter.Context context, HistoryItem item) {
        if (item.getNumberOfOccurances() > this.maxNumberOfOccurances) {
            this.maxNumberOfOccurances = item.getNumberOfOccurances();
        }
        String formattedDuration = this.getFormattedDuration(item.getDurationMillis());
        this.formattedDurations.put(item, formattedDuration);
        if (formattedDuration.length() > this.maxFormattedDurationLength) {
            this.maxFormattedDurationLength = formattedDuration.length();
        }
    }

    @Override
    public void writeHeader(Formatter.Context context) {
    }

    @Override
    public void writeRow(Formatter.Context context, int rowIndex, HistoryItem item) {
        int rowStartIndex = context.length();
        if (this.mode != Mode.SCRIPT) {
            context.append(String.format("%3d  ", rowIndex));
        }
        if (this.mode == Mode.LIST_OCCURANCES) {
            String format = this.maxNumberOfOccurances >= 0 && this.maxNumberOfOccurances < 10 ? "%d" : (this.maxNumberOfOccurances >= 10 && this.maxNumberOfOccurances < 100 ? "%2d" : (this.maxNumberOfOccurances > 100 && this.maxNumberOfOccurances < 1000 ? "%3d" : "%d"));
            context.append(MessageFormat.format("({0}) ", String.format(format, item.getNumberOfOccurances())));
        }
        if (this.mode == Mode.LIST_DURATION) {
            String formattedDuration = this.formattedDurations.get(item);
            int padSize = this.maxFormattedDurationLength - formattedDuration.length();
            String durationPad = this.getPadding(padSize);
            context.append('(');
            context.append(durationPad);
            context.append(formattedDuration);
            context.append(") ");
        }
        if (this.mode == Mode.SCRIPT || this.mode == Mode.LIST_FULL_LINE) {
            int rowOffset = context.length() - rowStartIndex;
            String continuationPad = null;
            if (this.mode == Mode.LIST_FULL_LINE) {
                StringBuilder continuationBuffer = new StringBuilder();
                continuationBuffer.append(this.getPadding(rowOffset - 3));
                continuationBuffer.append(">  ");
                continuationPad = continuationBuffer.toString();
            }
            boolean firstLine = true;
            int terminator = 0;
            for (String bufferLine : item.getMultiline()) {
                String trimmedBufferLine;
                if (firstLine) {
                    firstLine = false;
                } else {
                    context.append('\n');
                    if (this.mode == Mode.LIST_FULL_LINE) {
                        context.append(continuationPad);
                    }
                }
                context.append(context.highlightText(bufferLine));
                if (this.mode != Mode.SCRIPT || (trimmedBufferLine = bufferLine.trim()).length() <= 0) continue;
                terminator = trimmedBufferLine.charAt(trimmedBufferLine.length() - 1);
            }
            if (this.mode == Mode.SCRIPT) {
                switch (terminator) {
                    case 59: {
                        context.append("\n/\n\n");
                        break;
                    }
                    default: {
                        context.append("\n\n");
                        break;
                    }
                }
            } else {
                context.append("\n\n");
            }
        } else {
            String line = item.line().replace("\n", " ").replace("\r", "");
            if (line.length() >= context.getTerminalWidth()) {
                line = line.substring(0, context.getTerminalWidth());
            }
            context.append(context.highlightText(line));
            context.append('\n');
        }
    }

    @Override
    public void writeFooter(Formatter.Context context) {
    }

    private String getFormattedDuration(long durationMillis) {
        StringBuilder buffer = new StringBuilder();
        if (durationMillis > 0L) {
            long mins;
            long hrs = durationMillis / 3600000L % 24L;
            if (hrs > 0L) {
                durationMillis -= hrs * 1000L * 60L * 60L;
                buffer.append(String.format("%02d", hrs));
                buffer.append(':');
            }
            if ((mins = durationMillis / 60000L % 60L) > 0L) {
                durationMillis -= mins * 1000L * 60L;
                buffer.append(String.format("%02d", mins));
                buffer.append(':');
            }
            long secs = durationMillis / 1000L % 60L;
            buffer.append(String.format("%02d", secs));
            buffer.append('.');
            if ((durationMillis -= secs * 1000L) > 0L) {
                buffer.append(String.format("%03d", durationMillis));
            }
        }
        return buffer.toString();
    }

    private String getPadding(int length) {
        char[] padChars = new char[length];
        Arrays.fill(padChars, ' ');
        return new String(padChars);
    }

    private boolean isShowFails(Formatter.Context context) {
        return this.showFails != null ? this.showFails.booleanValue() : context.isSelectFailsDefault();
    }

    public static class Builder {
        private Mode mode = Mode.LIST_SUMMARY;
        private Boolean showFails = null;
        private boolean showSessionOnly = false;

        public Builder mode(Mode mode) {
            this.mode = mode;
            return this;
        }

        public Builder showFails(boolean showFails) {
            this.showFails = showFails;
            return this;
        }

        public Builder showSessionOnly(boolean showSessionOnly) {
            this.showSessionOnly = showSessionOnly;
            return this;
        }

        public Formatter build() {
            return new DefaultFormatter(this.mode, this.showFails, this.showSessionOnly);
        }
    }

    public static enum Mode {
        SCRIPT,
        LIST_SUMMARY,
        LIST_FULL_LINE,
        LIST_OCCURANCES,
        LIST_DURATION;

    }
}

