/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.plusplus.connections.db.storage;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.Properties;
import oracle.dbtools.plusplus.connections.db.storage.ConnectionStorage;
import oracle.dbtools.plusplus.connections.db.storage.StoreException;
import oracle.dbtools.plusplus.connections.db.storage.Wallet;
import oracle.dbtools.util.Logger;
import oracle.security.pki.OracleWallet;

public final class NamedConnectionDefinition {
    public static final String DISPLAY_NAME_KEY = "displayName";
    public static final String TYPE_KEY = "type";
    public static final String USER_NAME_KEY = "userName";
    public static final String URL_KEY = "url";
    public static final String CONNECTION_STRING_KEY = "connectionString";
    public static final String BASIC_ORACLE = "ORACLE_BASIC";
    public static final String ADVANCED_ORACLE = "ORACLE_DATABASE";
    public static final String DBTOOLS_PROPERTIES = "dbtools.properties";
    public static final String OJDBC_PROPERTIES = "ojdbc.properties";
    public static final String CONNECTION_PROPERTIES = "connection.properties";
    public static final String WALLET_FILE = "cwallet.sso";
    public static final String TNSNAMES_FILE = "tnsnames.ora";
    private final String identifier;
    private final Path connectionDirectory;
    private final Properties dbtoolsProperties;
    private final Properties ojdbcProperties;
    private final Wallet wallet;

    public static Builder builder(String identifier) {
        return new Builder(identifier);
    }

    static NamedConnectionDefinition createConnectionDefinition(Path connectionDirectory) {
        NamedConnectionDefinition definition = null;
        String identifier = connectionDirectory.getFileName().toString();
        Path dbTools = connectionDirectory.resolve(DBTOOLS_PROPERTIES);
        Properties dbToolsProps = ConnectionStorage.loadProperties(dbTools);
        if (!dbToolsProps.isEmpty()) {
            Builder builder = new Builder(connectionDirectory).dbtoolsProperties(ConnectionStorage.loadProperties(dbTools));
            Path connectionProperties = connectionDirectory.resolve(OJDBC_PROPERTIES);
            if (!Files.isRegularFile(connectionProperties, new LinkOption[0])) {
                connectionProperties = connectionDirectory.resolve(CONNECTION_PROPERTIES);
            }
            builder = builder.ojdbcProperties(ConnectionStorage.loadProperties(connectionProperties));
            Path wallet = connectionDirectory.resolve(WALLET_FILE);
            if (Files.exists(wallet, new LinkOption[0])) {
                try {
                    builder = builder.wallet(wallet);
                }
                catch (IOException e) {
                    Logger.severe(ConnectionStorage.class, e);
                }
            }
            definition = builder.build();
        }
        return definition;
    }

    private NamedConnectionDefinition(String identifier, Path connectionDirectory, Properties dbToolsProperties, Properties ojdbcProperties, Wallet wallet) {
        this.identifier = identifier;
        this.connectionDirectory = connectionDirectory;
        this.dbtoolsProperties = dbToolsProperties;
        this.ojdbcProperties = ojdbcProperties;
        this.wallet = wallet;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public Properties getDbtoolsProperties() {
        return this.dbtoolsProperties;
    }

    public Properties getOjdbcProperties() {
        return this.ojdbcProperties;
    }

    public Wallet getWallet() {
        return this.wallet;
    }

    public Path getConnectionDirectory() {
        return this.connectionDirectory;
    }

    public String getConnectionType() {
        String type = null;
        if (this.dbtoolsProperties != null) {
            type = this.dbtoolsProperties.getProperty(TYPE_KEY);
        }
        return type != null ? type : "UNKNOWN";
    }

    public String getConnectionName() {
        String name = null;
        if (this.dbtoolsProperties != null) {
            name = this.dbtoolsProperties.getProperty(DISPLAY_NAME_KEY);
        }
        return name != null ? name : this.identifier;
    }

    void write(ConnectionStorage store) throws StoreException {
        if (!this.ojdbcProperties.isEmpty()) {
            store.storeObject(this.identifier, OJDBC_PROPERTIES, this.ojdbcProperties, NamedConnectionDefinition::outputProperties);
        }
        if (!this.dbtoolsProperties.isEmpty()) {
            store.storeObject(this.identifier, DBTOOLS_PROPERTIES, this.dbtoolsProperties, NamedConnectionDefinition::outputProperties);
        }
        store.storeObject(this.identifier, WALLET_FILE, this.wallet, Wallet::writeWallet);
    }

    public static void outputProperties(Properties props, OutputStream out) throws IOException {
        if (!props.isEmpty()) {
            props.store(out, "");
        }
    }

    public NamedConnectionDefinition clone(String newIdentifier) {
        this.copyDefinition(newIdentifier);
        return null;
    }

    public NamedConnectionDefinition clone(String newIdentifier, String username, char[] pwd) {
        this.copyDefinition(newIdentifier);
        return null;
    }

    private void copyDefinition(String newIdentifier) {
    }

    public static class Builder {
        private final Properties dbtools = new Properties();
        private final Properties ojdbc = new Properties();
        private Wallet wallet = Wallet.createEmptyWallet();
        private final String identifier;
        private Path connectionDirectory;

        private Builder(Path dir) {
            this.connectionDirectory = dir;
            this.identifier = this.connectionDirectory.getFileName().toString();
        }

        private Builder(String identifier) {
            this.identifier = identifier;
        }

        public Builder dbtoolsProperties(Properties props) {
            this.dbtools.putAll((Map<?, ?>)props);
            return this;
        }

        public Builder ojdbcProperties(Properties props) {
            this.ojdbc.putAll((Map<?, ?>)props);
            return this;
        }

        public Builder wallet(Path wallet) throws IOException {
            this.wallet = Wallet.createWallet(wallet);
            return this;
        }

        public Builder wallet(OracleWallet wallet) throws IOException {
            this.wallet = Wallet.createWallet(wallet);
            return this;
        }

        public NamedConnectionDefinition build() {
            return new NamedConnectionDefinition(this.identifier, this.connectionDirectory, this.dbtools, this.ojdbc, this.wallet);
        }
    }
}

