/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.plusplus.connections.db.imp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import oracle.dbtools.common.utils.ModelUtil;
import oracle.dbtools.connections.db.DatabaseProvider;
import oracle.dbtools.plusplus.connections.db.ConnectionIdentifiers;
import oracle.dbtools.plusplus.connections.db.MessageLogger;
import oracle.dbtools.plusplus.connections.db.helpers.ora.Constants;
import oracle.dbtools.plusplus.connections.db.imp.ImportedConnectionResult;
import oracle.dbtools.plusplus.connections.db.storage.ConnectionStorage;
import oracle.dbtools.plusplus.connections.db.storage.NamedConnectionDefinition;
import oracle.dbtools.plusplus.connections.db.storage.StoreException;
import oracle.dbtools.util.InputOutputStreams;
import oracle.security.pki.OracleSecretStore;
import oracle.security.pki.OracleSecretStoreException;
import oracle.security.pki.OracleWallet;

public abstract class ConnectionsConverter
implements Constants {
    public static final String SQLDEV_ADVANCED_PREFIX = "sqldev.advanced.";
    protected final String identifier;
    protected final DatabaseProvider definition;
    protected final MessageLogger logger;
    private final Properties dbToolsProperties = new Properties();
    private final Properties advancedProperties = new Properties();
    private final List<MigratedCredential> credentials = new ArrayList<MigratedCredential>();

    protected ConnectionsConverter(DatabaseProvider provider, MessageLogger logger) {
        this.definition = provider;
        this.logger = logger;
        this.identifier = ConnectionIdentifiers.createIdentifier(provider.getName()).toString();
    }

    public abstract ImportedConnectionResult convert() throws IOException;

    protected void processCredentials(String spec) throws IOException {
        String username = this.definition.getProperty("user");
        String pwd = this.definition.getProperty("password");
        String role = this.definition.getProperty("role");
        this.processCredentials(spec, username, pwd, role);
    }

    protected void processCredentials(String spec, String username, String pwd, String role) throws IOException {
        this.addDBToolsProperty("userName", username);
        if (ModelUtil.hasLength(username) && ModelUtil.hasLength(pwd)) {
            this.addCredentials(spec, username, pwd.toCharArray());
        }
        if (ModelUtil.hasLength(role)) {
            this.setRole(role);
        }
    }

    protected void copyValue(String key) {
        String value = this.definition.getProperty(key);
        this.addDBToolsProperty(key, value);
    }

    protected final String processDisplayName() {
        String displayName = this.definition.getName();
        this.addDBToolsProperty("displayName", displayName);
        return displayName;
    }

    protected void output(ConnectionStorage store) throws IOException {
        NamedConnectionDefinition.Builder builder = NamedConnectionDefinition.builder(this.identifier);
        if (!this.advancedProperties.isEmpty()) {
            builder.ojdbcProperties(this.advancedProperties);
        }
        if (!this.dbToolsProperties.isEmpty()) {
            builder.dbtoolsProperties(this.dbToolsProperties);
        }
        if (!this.credentials.isEmpty()) {
            OracleWallet wallet = new OracleWallet();
            wallet.createSSO();
            this.updateWallet(wallet);
            builder.wallet(wallet);
        }
        NamedConnectionDefinition definition = builder.build();
        store.storeDefinition(definition);
    }

    protected final void writeWallet(ConnectionStorage store, String identifier) throws IOException {
        if (!this.credentials.isEmpty()) {
            OracleWallet wallet = new OracleWallet();
            wallet.createSSO();
            this.updateWallet(wallet);
            store.storeObject(identifier, "cwallet.sso", wallet, (data, out) -> {
                try (InputStream is = data.getWalletArray(true);){
                    InputOutputStreams.instance().copy(is, out);
                }
            });
        }
    }

    protected final void writeAdvancedProperties(ConnectionStorage store, String identifier) throws StoreException {
        store.storeObject(identifier, "ojdbc.properties", this.advancedProperties, NamedConnectionDefinition::outputProperties);
    }

    protected final void writeDBToolsProperties(ConnectionStorage store, String identifier) throws StoreException {
        store.storeObject(identifier, "dbtools.properties", this.dbToolsProperties, NamedConnectionDefinition::outputProperties);
    }

    protected void outputAdvancedProperties(OutputStream out) throws IOException {
        NamedConnectionDefinition.outputProperties(this.advancedProperties, out);
    }

    protected void outputDBToolsProperties(OutputStream out) throws IOException {
        NamedConnectionDefinition.outputProperties(this.dbToolsProperties, out);
    }

    protected void updateWallet(OracleWallet wallet) throws IOException {
        try {
            String aliasKey;
            OracleSecretStore store = wallet.getSecretStore();
            int i = 1;
            while (store.containsAlias(aliasKey = "oracle.security.client.connect_string" + i)) {
                ++i;
            }
            for (MigratedCredential cred : this.credentials) {
                store.setSecret("oracle.security.client.connect_string" + i, cred.spec.toCharArray());
                store.setSecret("oracle.security.client.username" + i, cred.username.toCharArray());
                store.setSecret("oracle.security.client.password" + i, cred.pwd);
                ++i;
            }
            wallet.setSecretStore(store);
        }
        catch (OracleSecretStoreException e) {
            throw new IOException(e);
        }
    }

    protected final void addDBToolsProperty(String key, String value) {
        if (value != null) {
            this.dbToolsProperties.setProperty(key, value);
        }
    }

    protected final void addAdvancedProperty(String key, String value) {
        if (value != null) {
            this.advancedProperties.setProperty(key, value);
        }
    }

    protected final void setRole(String role) {
        if (role != null) {
            this.addAdvancedProperty("internal_logon", role);
        }
    }

    protected final void addCredentials(String key, String user, char[] pwd) {
        MigratedCredential credential = new MigratedCredential(key, user, pwd);
        this.credentials.add(credential);
    }

    private static final class MigratedCredential {
        private final String spec;
        private final String username;
        private final char[] pwd;

        private MigratedCredential(String spec, String username, char[] pwd) {
            this.spec = spec;
            this.username = username;
            if (pwd != null) {
                this.pwd = new char[pwd.length];
                System.arraycopy(pwd, 0, this.pwd, 0, pwd.length);
            } else {
                this.pwd = null;
            }
        }
    }
}

