/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.plusplus.connections.db.imp;

import oracle.dbtools.connections.db.DatabaseProvider;
import oracle.dbtools.plusplus.connections.db.MessageLogger;
import oracle.dbtools.plusplus.connections.db.helpers.ora.Constants;
import oracle.dbtools.plusplus.connections.db.imp.BaseOracleConverter;
import oracle.dbtools.plusplus.connections.db.imp.ConnectionsConverter;
import oracle.dbtools.plusplus.connections.db.imp.ConnectionsConverterFactory;

public class BasicConverterFactory
implements ConnectionsConverterFactory {
    @Override
    public boolean canConvert(DatabaseProvider provider) {
        return "oraJDBC".equals(provider.getProperty("subtype")) && "BASIC".equals(provider.getProperty("OracleConnectionType"));
    }

    @Override
    public ConnectionsConverter createConverter(DatabaseProvider provider, MessageLogger logging) {
        return new BasicConverter(provider, logging);
    }

    static class BasicConverter
    extends BaseOracleConverter
    implements Constants {
        private BasicConverter(DatabaseProvider provider, MessageLogger logging) {
            super(provider, logging);
        }

        @Override
        protected String processConnectionSpec() {
            this.addDBToolsProperty("type", "ORACLE_BASIC");
            return this.processBasicConfiguration();
        }
    }
}

