/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.plusplus.connections.db.helpers;

import java.sql.SQLException;
import java.util.Objects;
import java.util.Properties;
import java.util.ServiceLoader;
import oracle.dbtools.plusplus.connections.db.MessageLogger;
import oracle.dbtools.plusplus.connections.db.helpers.ConnectionHelper;
import oracle.dbtools.plusplus.connections.db.storage.NamedConnectionDefinition;
import oracle.dbtools.raptor.newscriptrunner.ConnectionDetails;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;

public interface ConnectionHelperFactory {
    public static final ServiceLoader<ConnectionHelperFactory> LOADER = ServiceLoader.load(ConnectionHelperFactory.class);

    public static ConnectionHelper createFallbackHelper() {
        return new ConnectionHelper(){

            @Override
            public Properties getDisplayProperties() {
                return new Properties();
            }

            @Override
            public void testConnection(String user) throws SQLException {
                throw new SQLException("Unsupported");
            }

            @Override
            public void completeConnectionDetails(ConnectionDetails cd) {
            }

            @Override
            public String getURL() {
                return "";
            }

            @Override
            public String getConnectionSpec() {
                return "";
            }
        };
    }

    public String getConnectionType();

    public ConnectionHelper createConnectionHelper(NamedConnectionDefinition var1, ScriptRunnerContext var2, MessageLogger var3);

    public static ConnectionHelper findHelper(NamedConnectionDefinition definition, ScriptRunnerContext ctx, MessageLogger logger) {
        ConnectionHelper helper = null;
        String type = definition.getConnectionType();
        for (ConnectionHelperFactory factory : LOADER) {
            if (!Objects.equals(type, factory.getConnectionType())) continue;
            try {
                helper = factory.createConnectionHelper(definition, ctx, logger);
            }
            catch (Exception ex) {
                logger.logError("Error creating ConnectionHelper", ex);
            }
            break;
        }
        if (helper == null) {
            helper = ConnectionHelperFactory.createFallbackHelper();
        }
        return helper;
    }
}

