/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.plusplus.connections.db;

import oracle.dbtools.common.utils.ModelUtil;
import oracle.dbtools.plusplus.connections.db.ConnectionSaverFactory;
import oracle.dbtools.plusplus.connections.db.ConnectionStoreCommand;
import oracle.dbtools.plusplus.connections.db.ConnectionStoreResources;
import oracle.dbtools.plusplus.connections.db.MessageLogger;
import oracle.dbtools.plusplus.connections.db.storage.ConnectionCloner;
import oracle.dbtools.plusplus.connections.db.storage.NamedConnectionDefinition;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.PasswordProperty;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.SealedString;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.URLProperty;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.UserProperty;

public class NamedConnectionSaverFactory
implements ConnectionSaverFactory {
    @Override
    public String getConnectorType() {
        return "NAME";
    }

    @Override
    public ConnectionSaverFactory.ConnectionSaver createConnectionSaver(ScriptRunnerContext ctx, MessageLogger logger) {
        return (connName, properties, user, skipPwd) -> {
            boolean saved = false;
            ConnectionCloner cloner = ConnectionCloner.createCloner(ctx, logger);
            String origName = properties.getValueOf(URLProperty.URL);
            NamedConnectionDefinition def = ConnectionStoreCommand.getConnectionDefinition(origName, logger);
            if (def == null) {
                logger.logUserMessage(ConnectionStoreResources.format("ERROR_LOADING_CONNECTION", origName));
            } else {
                cloner.setOrigin(def);
                cloner.setDestination(connName);
                cloner.cloneConnection();
                char[] pwd = null;
                if (!ModelUtil.hasLength(user)) {
                    SealedString o;
                    user = properties.getValueOf(UserProperty.USER);
                    if (!skipPwd && (o = properties.getValueOf(PasswordProperty.PASSWORD)) != null) {
                        pwd = ((Object)o).toString().toCharArray();
                    }
                }
                cloner.updateUser(user, pwd, !skipPwd);
                cloner.saveConnection();
                saved = true;
            }
            return saved;
        };
    }
}

