/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.plusplus.connections.db;

import java.util.logging.Level;
import oracle.dbtools.plusplus.connections.db.NamedConnections;
import oracle.dbtools.util.Logger;

public class MessageLogger {
    public static DefaultLoggerWrapper DEFAULT_LOGGER = MessageLogger.logger(NamedConnections.class);
    private final InteractiveLogger interactiveLogger;
    private final ErrorLogger errorLogger;
    private final TraceLogger traceLogger;

    public static DefaultLoggerWrapper logger(Class<?> cls) {
        return new DefaultLoggerWrapper(cls);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(MessageLogger source) {
        return new Builder(source);
    }

    private MessageLogger(InteractiveLogger interactiveLogger, ErrorLogger errorLogger, TraceLogger traceLogger) {
        this.interactiveLogger = interactiveLogger;
        this.errorLogger = errorLogger;
        this.traceLogger = traceLogger;
    }

    public void logUserMessage(String msg) {
        this.interactiveLogger.log(msg);
    }

    public void logError(String msg, Throwable t) {
        this.errorLogger.error(msg, t);
    }

    public void traceMessage(Level level, String msg) {
        this.traceLogger.trace(level, msg);
    }

    public void traceMessage(String msg) {
        this.traceMessage(Level.FINE, msg);
    }

    public static class Builder {
        private InteractiveLogger interactiveLogger;
        private ErrorLogger errorLogger;
        private TraceLogger traceLogger;

        private Builder() {
        }

        private Builder(MessageLogger source) {
            this.interactiveLogger = source.interactiveLogger;
            this.errorLogger = source.errorLogger;
            this.traceLogger = source.traceLogger;
        }

        public Builder interactiveLogger(InteractiveLogger interactiveLogger) {
            this.interactiveLogger = interactiveLogger;
            return this;
        }

        public Builder errorLogger(ErrorLogger errorLogger) {
            this.errorLogger = errorLogger;
            return this;
        }

        public Builder traceLogger(TraceLogger traceLogger) {
            this.traceLogger = traceLogger;
            return this;
        }

        public MessageLogger build() {
            if (this.interactiveLogger == null) {
                throw new IllegalStateException("MessageLogger requires InteractiveLogger");
            }
            if (this.errorLogger == null) {
                this.errorLogger = DEFAULT_LOGGER::error;
            }
            if (this.traceLogger == null) {
                this.traceLogger = DEFAULT_LOGGER::trace;
            }
            return new MessageLogger(this.interactiveLogger, this.errorLogger, this.traceLogger);
        }
    }

    public static final class DefaultLoggerWrapper
    implements ErrorLogger,
    TraceLogger {
        private final Class<?> referenceClass;

        private DefaultLoggerWrapper(Class<?> cls) {
            this.referenceClass = cls;
        }

        @Override
        public void error(String msg, Throwable t) {
            Logger.severe(this.referenceClass, msg, t);
        }

        @Override
        public void trace(Level level, String msg) {
            Logger.log(this.referenceClass, level, msg, null);
        }
    }

    public static interface TraceLogger {
        public void trace(Level var1, String var2);
    }

    public static interface ErrorLogger {
        public void error(String var1, Throwable var2);
    }

    public static interface InteractiveLogger {
        public void log(String var1);
    }
}

