/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.scriptrunner.commands.modeler;

import java.sql.Connection;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import oracle.dbtools.crest.model.metadata.MetaFileLoader;
import oracle.dbtools.crest.util.string.StringUtilities;
import oracle.dbtools.extension.SQLCLService;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.IHelp;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.scriptrunner.commands.modeler.Messages;
import oracle.dbtools.raptor.scriptrunner.commands.modeler.ModelerDDLGenerator;
import oracle.dbtools.raptor.scriptrunner.commands.modeler.ModelerReportGenerator;

public class ModelerCommand
extends CommandListener
implements IHelp,
SQLCLService {
    private static String MODELER = "modeler";
    private static String HELP = "help";
    private static String DDL = "ddl";
    private static String REPORT = "report";
    private static String NAME = "Modeler Command";

    public String getCommand() {
        return "MODELER";
    }

    public String getHelp() {
        return Messages.getString("MODELER_HELP_OVERVIEW") + Messages.getString("MODELER_HELP_DDL") + "\n" + Messages.getString("MODELER_HELP_REPORT");
    }

    public boolean isSqlPlus() {
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (!cmd.getLoweredTrimmedNoWhitespaceSQL().startsWith(MODELER)) return false;
        String sql = cmd.getSql();
        ArrayList<String> cmdParts = new ArrayList<String>();
        this.splitArgs(sql, cmdParts);
        int len = cmdParts.size();
        ArrayList<String> commands = new ArrayList<String>(){
            {
                this.add(DDL);
                this.add(REPORT);
                this.add(HELP);
            }
        };
        if (ModelerCommand.matches((String)MODELER, (String)cmdParts.get(0).toLowerCase())) {
            if (len < 2) {
                ctx.write(this.getHelp());
                return true;
            }
            if (commands.contains(cmdParts.get(1).toLowerCase())) {
                MetaFileLoader.DMWEB = true;
                if (cmdParts.get(1).equalsIgnoreCase(HELP)) {
                    if (len <= 2) {
                        ctx.write(this.getHelp());
                        return true;
                    } else if (len > 2 && cmdParts.get(2).equalsIgnoreCase(DDL)) {
                        ctx.write(Messages.getString("MODELER_HELP_DDL"));
                        return true;
                    } else {
                        if (len <= 2 || !cmdParts.get(2).equalsIgnoreCase(REPORT)) return true;
                        ctx.write(Messages.getString("MODELER_HELP_REPORT"));
                    }
                    return true;
                }
                if (cmdParts.get(1).equalsIgnoreCase(DDL)) {
                    if (len < 6) {
                        ctx.write(Messages.getString("MODELER_HELP_DDL"));
                        return true;
                    }
                    String designFileName = null;
                    String relModelName = null;
                    String outputFileName = null;
                    String systemTypesDir = null;
                    String settingsFileName = null;
                    String ddlConfigFileName = null;
                    String dbSiteName = null;
                    for (int i = 2; i < len; ++i) {
                        String option = cmdParts.get(i);
                        if (++i < len) {
                            String value = cmdParts.get(i);
                            if ("-DESIGN".equalsIgnoreCase(option) || "-D".equalsIgnoreCase(option)) {
                                designFileName = StringUtilities.removeQuotes((String)value.trim());
                                continue;
                            }
                            if ("-RELMODEL".equalsIgnoreCase(option) || "-RM".equalsIgnoreCase(option)) {
                                relModelName = StringUtilities.removeQuotes((String)value.trim());
                                continue;
                            }
                            if ("-OUTPUTFILE".equalsIgnoreCase(option) || "-O".equalsIgnoreCase(option)) {
                                outputFileName = StringUtilities.removeQuotes((String)value.trim());
                                continue;
                            }
                            if ("-SYSTEMTYPESDIR".equalsIgnoreCase(option) || "-TD".equalsIgnoreCase(option)) {
                                systemTypesDir = StringUtilities.removeQuotes((String)value.trim());
                                continue;
                            }
                            if ("-SETTINGSFILE".equalsIgnoreCase(option) || "-S".equalsIgnoreCase(option)) {
                                settingsFileName = StringUtilities.removeQuotes((String)value.trim());
                                continue;
                            }
                            if ("-DDLCONFIGFILE".equalsIgnoreCase(option) || "-C".equalsIgnoreCase(option)) {
                                ddlConfigFileName = StringUtilities.removeQuotes((String)value.trim());
                                continue;
                            }
                            if ("-DBSITE".equalsIgnoreCase(option) || "-DS".equalsIgnoreCase(option)) {
                                dbSiteName = StringUtilities.removeQuotes((String)value.trim());
                                continue;
                            }
                            ctx.write(MessageFormat.format(Messages.getString("INVALID_ARGUMENT"), option));
                            return true;
                        }
                        ctx.write(MessageFormat.format(Messages.getString("INVALID_ARGUMENT"), option));
                        return true;
                    }
                    if (designFileName == null) {
                        ctx.write(MessageFormat.format(Messages.getString("INVALID_ARGUMENT"), "-DESIGN"));
                        return true;
                    }
                    if (relModelName == null) {
                        ctx.write(MessageFormat.format(Messages.getString("INVALID_ARGUMENT"), "-RELMODEL"));
                        return true;
                    }
                    HashMap<String, String> arguments = new HashMap<String, String>();
                    arguments.put("-DESIGN", designFileName);
                    arguments.put("-RELMODEL", relModelName);
                    arguments.put("-OUTPUTFILE", outputFileName);
                    arguments.put("-SYSTEMTYPESDIR", systemTypesDir);
                    arguments.put("-SETTINGSFILE", settingsFileName);
                    arguments.put("-DDLCONFIGFILE", ddlConfigFileName);
                    arguments.put("-DBSITE", dbSiteName);
                    try {
                        ModelerDDLGenerator gen = new ModelerDDLGenerator(ctx, arguments);
                        gen.generateDDL();
                        return true;
                    }
                    catch (Exception e) {
                        ctx.write(MessageFormat.format(Messages.getString("MODELER_GENERIC_ERROR"), e.getMessage()));
                    }
                    return true;
                }
                if (!cmdParts.get(1).equalsIgnoreCase(REPORT)) return true;
                if (len < 10) {
                    ctx.write(Messages.getString("MODELER_HELP_REPORT"));
                    return true;
                }
                String designFileName = null;
                String reportType = null;
                String reportFileName = null;
                String outputPath = null;
                String relModelName = null;
                String reportTitle = null;
                String standardReportTemplate = null;
                String customReportTemplate = null;
                String reportConfTemplate = null;
                String reportCompanyName = null;
                String systemTypesDir = null;
                String settingsFileName = null;
                for (int i = 2; i < len; ++i) {
                    String option = cmdParts.get(i);
                    if (++i < len) {
                        String value = cmdParts.get(i);
                        if ("-DESIGN".equalsIgnoreCase(option) || "-D".equalsIgnoreCase(option)) {
                            designFileName = StringUtilities.removeQuotes((String)value.trim());
                            continue;
                        }
                        if ("-TYPE".equalsIgnoreCase(option) || "-TP".equalsIgnoreCase(option)) {
                            reportType = StringUtilities.removeQuotes((String)value.trim());
                            continue;
                        }
                        if ("-FILENAME".equalsIgnoreCase(option) || "-F".equalsIgnoreCase(option)) {
                            reportFileName = StringUtilities.removeQuotes((String)value.trim());
                            continue;
                        }
                        if ("-OUTPUTPATH".equalsIgnoreCase(option) || "-O".equalsIgnoreCase(option)) {
                            outputPath = StringUtilities.removeQuotes((String)value.trim());
                            continue;
                        }
                        if ("-RELMODEL".equalsIgnoreCase(option) || "-RM".equalsIgnoreCase(option)) {
                            relModelName = StringUtilities.removeQuotes((String)value.trim());
                            continue;
                        }
                        if ("-TITLE".equalsIgnoreCase(option) || "-TT".equalsIgnoreCase(option)) {
                            reportTitle = StringUtilities.removeQuotes((String)value.trim());
                            continue;
                        }
                        if ("-STANDARDTEMPLATE".equalsIgnoreCase(option) || "-ST".equalsIgnoreCase(option)) {
                            standardReportTemplate = StringUtilities.removeQuotes((String)value.trim());
                            continue;
                        }
                        if ("-CUSTOMTEMPLATE".equalsIgnoreCase(option) || "-CT".equalsIgnoreCase(option)) {
                            customReportTemplate = StringUtilities.removeQuotes((String)value.trim());
                            continue;
                        }
                        if ("-REPORTCONFTEMPLATE".equalsIgnoreCase(option) || "-C".equalsIgnoreCase(option)) {
                            reportConfTemplate = StringUtilities.removeQuotes((String)value.trim());
                            continue;
                        }
                        if ("-COMPANYNAME".equalsIgnoreCase(option) || "-CN".equalsIgnoreCase(option)) {
                            reportCompanyName = StringUtilities.removeQuotes((String)value.trim());
                            continue;
                        }
                        if ("-SYSTEMTYPESDIR".equalsIgnoreCase(option) || "-TD".equalsIgnoreCase(option)) {
                            systemTypesDir = StringUtilities.removeQuotes((String)value.trim());
                            continue;
                        }
                        if ("-SETTINGSFILE".equalsIgnoreCase(option) || "-S".equalsIgnoreCase(option)) {
                            settingsFileName = StringUtilities.removeQuotes((String)value.trim());
                            continue;
                        }
                        ctx.write(MessageFormat.format(Messages.getString("INVALID_ARGUMENT"), option));
                        return true;
                    }
                    ctx.write(MessageFormat.format(Messages.getString("INVALID_ARGUMENT"), option));
                    return true;
                }
                if (designFileName == null) {
                    ctx.write(MessageFormat.format(Messages.getString("INVALID_ARGUMENT"), "-DESIGN"));
                    return true;
                }
                if (reportType == null) {
                    ctx.write(MessageFormat.format(Messages.getString("INVALID_ARGUMENT"), "-TYPE"));
                    return true;
                }
                if (reportFileName == null) {
                    ctx.write(MessageFormat.format(Messages.getString("INVALID_ARGUMENT"), "-FILENAME"));
                    return true;
                }
                if (outputPath == null) {
                    ctx.write(MessageFormat.format(Messages.getString("INVALID_ARGUMENT"), "-OUTPUTPATH"));
                    return true;
                }
                if ((reportType.equalsIgnoreCase("TablesAndViews") || reportType.equalsIgnoreCase("Tables") || reportType.equalsIgnoreCase("TableViews")) && relModelName == null) {
                    ctx.write(MessageFormat.format(Messages.getString("INVALID_ARGUMENT"), "-RELMODEL"));
                    return true;
                }
                HashMap<String, String> arguments = new HashMap<String, String>();
                arguments.put("-DESIGN", designFileName);
                arguments.put("-TYPE", reportType);
                arguments.put("-FILENAME", reportFileName);
                arguments.put("-OUTPUTPATH", outputPath);
                arguments.put("-RELMODEL", relModelName);
                arguments.put("-TITLE", reportTitle);
                arguments.put("-STANDARDTEMPLATE", standardReportTemplate);
                arguments.put("-CUSTOMTEMPLATE", customReportTemplate);
                arguments.put("-REPORTCONFTEMPLATE", reportConfTemplate);
                arguments.put("-COMPANYNAME", reportCompanyName);
                arguments.put("-SYSTEMTYPESDIR", systemTypesDir);
                arguments.put("-SETTINGSFILE", settingsFileName);
                try {
                    ModelerReportGenerator gen = new ModelerReportGenerator(ctx, arguments);
                    gen.generateReport();
                    return true;
                }
                catch (Exception e) {
                    ctx.write(MessageFormat.format(Messages.getString("MODELER_GENERIC_ERROR"), e.getMessage()));
                }
                return true;
            }
            ctx.write(this.getHelp());
            return true;
        }
        ctx.write(this.getHelp());
        return true;
    }

    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    public Class<? extends CommandListener> getCommandListener() {
        return ((Object)((Object)this)).getClass();
    }

    protected boolean splitArgs(String commandline, ArrayList<String> args) {
        int lineLength = commandline.length();
        int terminalIndex = lineLength - 1;
        boolean nullChar = false;
        StringBuilder arg = new StringBuilder();
        StringBuilder quoted = new StringBuilder();
        char quoteChar = '\u0000';
        for (int i = 0; i < lineLength; ++i) {
            char ch = commandline.charAt(i);
            if (quoteChar != '\u0000') {
                quoted.append(ch);
                if (ch == quoteChar) {
                    arg.append((CharSequence)quoted);
                    quoted = new StringBuilder();
                    quoteChar = '\u0000';
                }
            } else if (ch == '\"' || ch == '\'') {
                quoted.append(ch);
                quoteChar = ch;
            } else if (Character.isWhitespace(ch)) {
                if (arg.length() > 0) {
                    args.add(arg.toString());
                    arg = new StringBuilder();
                }
            } else {
                arg.append(ch);
            }
            if (i != terminalIndex || quoteChar == '\u0000') continue;
            arg.append(quoteChar);
            i -= quoted.length() - 1;
            quoted = new StringBuilder();
            quoteChar = '\u0000';
        }
        if (arg.length() > 0) {
            args.add(arg.toString());
        }
        return true;
    }

    public String getExtensionDescription() {
        return Messages.getString("EXT_DESC");
    }

    public String getExtensionName() {
        return NAME;
    }

    public String getExtensionVersion() {
        return Messages.getString("SQLclVersion.VERSION");
    }
}

