/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.jdbc.util;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.logging.Level;
import oracle.dbtools.jdbc.util.LogUtil;
import oracle.dbtools.jdbc.util.RestJdbcUnsupportedException;
import oracle.dbtools.jdbc.util.RestjdbcResources;
import oracle.dbtools.jdbc.util.SQLStateMapping;

public class ExceptionUtil {
    public static void logExceptionUnsupported(Connection conn, String methodName, String className) throws SQLException {
        LogUtil.logOrException(conn, Level.INFO, ExceptionUtil.exceptionMessageStr(true, methodName, className), new SQLFeatureNotSupportedException(ExceptionUtil.exceptionMessageStr(true, methodName, className), "0A000", 3000));
    }

    private static String exceptionMessageStr(boolean unsupport, String methodName, String className) {
        if (unsupport) {
            return RestjdbcResources.format("RESTJDBC_UNSUPPORTED", methodName, className);
        }
        return RestjdbcResources.format("RESTJDBC_NOTIMPLEMENTED", methodName, className);
    }

    public static void throwSQLException(int errorCode) throws SQLException {
        String ORA_error = "ORA_" + errorCode;
        throw new SQLException(RestjdbcResources.getString(ORA_error), SQLStateMapping.getSQLState(errorCode), errorCode);
    }

    public static void throwSQLException(int errorCode, String methodName) throws SQLException {
        String ORA_error = "ORA_" + errorCode;
        throw new SQLException(RestjdbcResources.getString(ORA_error) + ": " + methodName, SQLStateMapping.getSQLState(errorCode), errorCode);
    }

    public static void throwSQLException(String methodName, String className) throws SQLException {
        throw new RestJdbcUnsupportedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", methodName, className));
    }

    public static void throwSQLException(int errorCode, Exception e) throws SQLException {
        String ORA_error = "ORA_" + errorCode;
        throw new SQLException(RestjdbcResources.getString(ORA_error), SQLStateMapping.getSQLState(errorCode), errorCode, e);
    }
}

