/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudstorage.text;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;

public abstract class Strings<T extends Strings<T>> {
    protected final ArrayList<Object> sources = new ArrayList();
    protected IToStringAdapter toStringAdapter = defaultToStringAdapter;
    protected IFromStringAdapter<String> fromStringAdapter = defaultFromStringAdapter;
    protected boolean trim = false;
    private static final IToStringAdapter defaultToStringAdapter = new IToStringAdapter(){

        @Override
        public String toString(Object source) {
            if (source == null) {
                return null;
            }
            return source.toString();
        }
    };
    private static final IFromStringAdapter<String> defaultFromStringAdapter = new IFromStringAdapter<String>(){

        @Override
        public String fromString(String part) {
            if (part == null || part.isEmpty()) {
                return null;
            }
            return part;
        }
    };
    private static final String PAD = "                                       ";

    public static Split split(Object ... sources) {
        return new Split(sources);
    }

    public static Join join(Object ... sources) {
        return new Join(sources);
    }

    private Strings(Object ... sources) {
        this.and(sources);
    }

    public T and(Object ... moreSources) {
        this.sources.ensureCapacity(this.sources.size() + moreSources.length);
        for (Object source : moreSources) {
            if (source instanceof Iterable) {
                for (Object item : (Iterable)source) {
                    this.sources.add(item);
                }
                continue;
            }
            if (source instanceof Collection) {
                this.sources.addAll((Collection)source);
                continue;
            }
            this.sources.add(source);
        }
        return (T)this;
    }

    public T using(IToStringAdapter toStringAdapter) {
        this.toStringAdapter = toStringAdapter == null ? defaultToStringAdapter : toStringAdapter;
        Strings self = this;
        return (T)self;
    }

    public T trim() {
        this.trim = true;
        Strings self = this;
        return (T)self;
    }

    public static boolean isEmpty(Object value) {
        if (value == null) {
            return true;
        }
        String valueString = value.toString();
        return valueString == null || valueString.trim().isEmpty();
    }

    public static String toHex(byte[] a) {
        if (a == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(a.length * 2);
        for (int i = 0; i < a.length; ++i) {
            sb.append(Character.forDigit((a[i] & 0xF0) >> 4, 16));
            sb.append(Character.forDigit(a[i] & 0xF, 16));
        }
        return sb.toString();
    }

    public static String pad(Object value, int length) {
        String msg = value.toString();
        msg = PAD.substring(0, length - msg.length()) + msg;
        return msg;
    }

    public static String md5(String value) throws NoSuchAlgorithmException {
        MessageDigest md5er = MessageDigest.getInstance("MD5");
        byte[] digest = md5er.digest(value.getBytes());
        String md5 = Strings.toHex(digest);
        return md5;
    }

    public static String identity(Object value) {
        if (value == null) {
            return null;
        }
        return Integer.toHexString(System.identityHashCode(value));
    }

    public static interface IFromStringAdapter<F> {
        public F fromString(String var1);
    }

    public static interface IToStringAdapter {
        public String toString(Object var1);
    }

    public static class Join
    extends Strings<Join> {
        private boolean removeTrailingSep = true;

        private Join(Object[] sources) {
            super(sources);
        }

        public Join keepTrailingSeperator() {
            this.removeTrailingSep = false;
            return this;
        }

        public String with(String join) {
            boolean allNull = true;
            StringBuilder joined = new StringBuilder();
            for (Object object : this.sources) {
                String source = this.toStringAdapter.toString(object);
                if (source == null) continue;
                allNull = false;
                joined.append(source).append(join);
            }
            if (this.removeTrailingSep && joined.length() >= join.length()) {
                joined.setLength(joined.length() - join.length());
            }
            return allNull ? null : joined.toString();
        }

        public String toString() {
            return this.with(", ");
        }
    }

    public static class Split
    extends Strings<Split>
    implements Iterable<String> {
        private Split(Object[] sources) {
            super(sources);
        }

        public List<String> on(Pattern pattern) {
            return this.on(pattern.pattern);
        }

        public List<String> on(String splitPattern) {
            ArrayList<String> parts = new ArrayList<String>();
            for (Object source : this.sources) {
                if (source == null) continue;
                java.util.regex.Pattern regex = java.util.regex.Pattern.compile(splitPattern, 8);
                String[] moreParts = regex.split(source.toString());
                parts.ensureCapacity(parts.size() + moreParts.length);
                for (String part : moreParts) {
                    if (this.trim) {
                        part = part.trim();
                    }
                    if ((part = (String)this.fromStringAdapter.fromString(part)) == null) continue;
                    parts.add(part);
                }
            }
            return parts;
        }

        @Override
        public Iterator<String> iterator() {
            List<String> parts = this.on(Pattern.commaOrNewline);
            return parts.iterator();
        }

        public static enum Pattern {
            newline("[\\n\\r]"),
            newlines((Object)((Object)newline) + "+"),
            whitespace("\\s+"),
            comma(","),
            commaOrNewline((Object)((Object)comma) + "|" + (Object)((Object)newlines));

            private final String pattern;

            private Pattern(String pattern) {
                this.pattern = pattern;
            }

            public String toString() {
                return this.pattern;
            }
        }
    }
}

