/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudstorage.api.put;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.Future;
import oracle.cloudstorage.api.IReply;
import oracle.cloudstorage.api.IRequestBuilder;
import oracle.cloudstorage.api.delete.IDeleteObjectReply;
import oracle.cloudstorage.api.header.Header;
import oracle.cloudstorage.api.header.Map;
import oracle.cloudstorage.api.put.ExtractArchiveReply;
import oracle.cloudstorage.api.put.IExtractArchiveReply;
import oracle.cloudstorage.api.put.IPutContainerReply;
import oracle.cloudstorage.api.put.IPutDataReply;
import oracle.cloudstorage.api.put.IPutObjectReply;
import oracle.cloudstorage.api.put.IPutRequestBuilder;
import oracle.cloudstorage.api.put.PutContainerReply;
import oracle.cloudstorage.api.put.PutObjectReply;
import oracle.cloudstorage.api.put.PutRequestProcessor;
import oracle.cloudstorage.api.request.Method;
import oracle.cloudstorage.api.request.Scope;
import oracle.cloudstorage.api.request.processor.IContent;
import oracle.cloudstorage.api.request.processor.IProcessorFactory;
import oracle.cloudstorage.api.request.processor.IRequestProcessor;
import oracle.cloudstorage.api.request.processor.IResponse;
import oracle.cloudstorage.api.request.processor.ISendable;
import oracle.cloudstorage.api.request.processor.ScopedRequestProcessor;
import oracle.cloudstorage.api.request.processor.Sendable;
import oracle.cloudstorage.api.request.processor.SimpleXMLResponseParser;
import oracle.cloudstorage.api.retry.RetryException;
import oracle.cloudstorage.text.Marker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PutSendableProcessor
extends PutRequestProcessor {
    private static final Logger logger = LoggerFactory.getLogger(PutSendableProcessor.class);
    private static final String NUMBER_FILES_CREATED = "<number_files_created>";

    public PutSendableProcessor(IProcessorFactory processorFactory) {
        super(processorFactory);
    }

    @Override
    public IPutContainerReply container() throws RetryException {
        ScopedRequestProcessor<IRequestBuilder, IPutContainerReply> processor = new ScopedRequestProcessor<IRequestBuilder, IPutContainerReply>((IRequestProcessor)this){

            @Override
            protected IResponse executeRequest(IRequestBuilder request) {
                IResponse response = PutSendableProcessor.this.send(logger, Marker.put.and(Marker.jaxrs), this.getSendable());
                return response;
            }

            @Override
            protected IPutContainerReply buildReply(IResponse response, IReply.Context context) {
                java.util.Map<String, List<Object>> headers = response.getHeaders();
                int statusCode = response.getStatus();
                String message = response.getErrorContent();
                PutContainerReply reply = new PutContainerReply(headers, statusCode, message, context);
                return reply;
            }
        };
        IPutContainerReply reply = (IPutContainerReply)processor.execute(this.getBuilder());
        return reply;
    }

    @Override
    public IExtractArchiveReply archive() throws RetryException {
        ((IPutRequestBuilder)this.getBuilder()).getSendable().getHeaders().setHeader(Header.accept.provide("text/xml"));
        BodyProcessor<IExtractArchiveReply> processor = new BodyProcessor<IExtractArchiveReply>((IRequestProcessor)this){

            @Override
            protected IExtractArchiveReply buildReply(IResponse response, IReply.Context context) {
                return PutSendableProcessor.this.buildExtractArchiveReply(response, context);
            }
        };
        IExtractArchiveReply reply = (IExtractArchiveReply)processor.execute(this.getBuilder());
        return reply;
    }

    private IPutObjectReply buildObjectReply(IResponse response, long numberOfBytesRead, final IDeleteObjectReply deleteObjectReply, IReply.Context context) {
        java.util.Map<String, List<Object>> headers = response.getHeaders();
        int statusCode = response.getStatus();
        String message = response.getErrorContent();
        Future<String> futureMd5 = response.getFutureMd5();
        PutObjectReply reply = new PutObjectReply(headers, statusCode, message, numberOfBytesRead, futureMd5, context){

            @Override
            public IDeleteObjectReply getDeleteObjectReply() {
                return deleteObjectReply;
            }
        };
        return reply;
    }

    private IExtractArchiveReply buildExtractArchiveReply(IResponse response, IReply.Context context) {
        java.util.Map<String, List<Object>> headers = response.getHeaders();
        int statusCode = response.getStatus();
        String message = response.getErrorContent();
        String body = response.readContent();
        SimpleXMLResponseParser parser = new SimpleXMLResponseParser(body);
        int created = parser.getInt(NUMBER_FILES_CREATED);
        Future<String> futureMd5 = response.getFutureMd5();
        ExtractArchiveReply reply = new ExtractArchiveReply(headers, statusCode, message, futureMd5, context, created);
        parser.parseErrors(reply);
        return reply;
    }

    @Override
    protected IPutObjectReply atomicObject(final IContent content, final IDeleteObjectReply deleteObjectReply) throws RetryException {
        BodyProcessor<IPutObjectReply> processor = new BodyProcessor<IPutObjectReply>((IRequestProcessor)this){

            @Override
            protected IPutObjectReply buildReply(IResponse response, IReply.Context context) {
                long numberOfBytesRead = content == null ? 0L : content.getNumberOfBytesRead();
                return PutSendableProcessor.this.buildObjectReply(response, numberOfBytesRead, deleteObjectReply, context);
            }
        };
        IPutObjectReply reply = (IPutObjectReply)processor.execute(this.getBuilder());
        return reply;
    }

    abstract class BodyProcessor<P extends IPutDataReply>
    extends ScopedRequestProcessor<IPutRequestBuilder, P> {
        private final IContent content;
        private boolean reset;

        BodyProcessor(IRequestProcessor<?, ?> outer) {
            super(outer);
            this.reset = false;
            this.content = this.getSendable().getContent();
        }

        @Override
        protected boolean canRetry() {
            if (!this.content.hasBeenRead()) {
                return true;
            }
            this.reset = this.content.reset();
            return this.reset;
        }

        @Override
        public void releaseRequest() throws IOException {
            this.content.close();
        }

        @Override
        protected IResponse executeRequest(IPutRequestBuilder request) {
            ISendable sendable = this.getSendable();
            Map headers = sendable.getHeaders();
            String contentType = PutSendableProcessor.this.getContentType("*/*");
            headers.put(Header.contentType.provide(contentType));
            if (request.isExpect100ContinueEnabled()) {
                headers.put(Header.expect.provide());
            }
            IResponse response = PutSendableProcessor.this.send(logger, Marker.put.and(Marker.jaxrs), sendable);
            return response;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void onResponseClosed(IResponse response) {
            if (this.content.hasBeenRead() || this.reset) {
                this.reset = false;
                return;
            }
            IResponse cleanupResponse = null;
            try {
                try {
                    Sendable sendable = new Sendable((IRequestBuilder)PutSendableProcessor.this.getBuilder(), this.getSendable().getHeaders(), Method.head, Scope.account, PutSendableProcessor.this.getAccountUrl(), null, -3);
                    cleanupResponse = PutSendableProcessor.this.send(logger, Marker.put.and(Marker.jaxrs), sendable);
                    logger.debug(Marker.put.and(Marker.jaxrs), "Server reset by invoking HEAD on {}.", (Object)this.getUrl());
                }
                finally {
                    if (cleanupResponse != null) {
                        cleanupResponse.close();
                    }
                }
            }
            catch (Exception e) {
                logger.error(Marker.put.and(Marker.jaxrs), "Exception thrown resetting server for {} with response {}.", new Object[]{this, response, e});
            }
        }
    }
}

