/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudstorage.api;

import java.io.Closeable;
import java.io.InputStream;
import java.security.PrivateKey;
import java.util.concurrent.ExecutorService;
import oracle.cloudstorage.api.auth.IAuthRequestBuilder;
import oracle.cloudstorage.api.auth.IAuthStrategy;
import oracle.cloudstorage.api.get.IGetObjectReply;
import oracle.cloudstorage.api.header.Map;
import oracle.cloudstorage.api.put.IPutRequestBuilder;
import oracle.cloudstorage.api.request.processor.IProcessorFactory;
import oracle.cloudstorage.api.request.processor.IRequestBuilderRoot;
import oracle.cloudstorage.api.request.processor.ISender;
import oracle.cloudstorage.api.retry.IRetryStrategy;

public interface ISession
extends IRequestBuilderRoot,
Closeable,
ISender {
    public static final String LOG_HEADERS_MARKER = ISession.class.getName() + ".headersMarker";
    public static final String LOG_HEADERS_LOGGER = ISession.class.getName() + ".headersLogger";
    public static final String WRITER_INTERCEPTOR = ISession.class.getName() + ".writerInterceptor";

    @Override
    public void close() throws IllegalStateException;

    public void retry(IRetryStrategy var1);

    public void initKeepAlive(IAuthRequestBuilder var1);

    public String getStorageUrl();

    public String getStorageToken();

    public String getMaskedStorageToken();

    public long getReadTimeout();

    public long getConnectTimeout();

    public int getChunk();

    public int getDefaultBuffer();

    public IAuthStrategy getAuthStrategy();

    public IProcessorFactory getProcessorFactory();

    public void validateCipher();

    public InputStream encrypt(IPutRequestBuilder var1, InputStream var2);

    public InputStream decrypt(IGetObjectReply var1, InputStream var2);

    public String rotate(Map var1, PrivateKey var2);

    public IRetryStrategy getRetryStrategy();

    public IRetryStrategy getKeepAliveRetryStrategy();

    public ExecutorService getExecutor();
}

