/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.ssh.core;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import oracle.dbtools.raptor.ssh.core.HostDescriptor;
import oracle.dbtools.raptor.ssh.core.StoreEvent;
import oracle.dbtools.raptor.ssh.core.StoreListener;
import oracle.dbtools.raptor.ssh.core.TunnelDescriptor;

public abstract class Store {
    private List<StoreListener> listeners = new CopyOnWriteArrayList<StoreListener>();

    public void addStoreListener(StoreListener l) {
        this.listeners.add(l);
    }

    public void removeStoreListener(StoreListener l) {
        this.listeners.remove(l);
    }

    public abstract Collection<String> listHosts();

    public abstract HostDescriptor getHostDescriptor(String var1);

    public abstract Collection<String> listTunnels(String var1);

    public abstract TunnelDescriptor getTunnelDescriptor(String var1, String var2);

    public abstract void addHost(HostDescriptor var1);

    public abstract void removeHost(String var1);

    public abstract void updateHost(HostDescriptor var1, HostDescriptor var2);

    public abstract void addTunnel(HostDescriptor var1, TunnelDescriptor var2);

    public abstract void removeTunnel(HostDescriptor var1, String var2);

    public abstract void updateTunnel(HostDescriptor var1, TunnelDescriptor var2, TunnelDescriptor var3);

    protected void fireHostAddedEvent(HostDescriptor host) {
        StoreEvent e = null;
        for (StoreListener l : this.listeners) {
            if (e == null) {
                e = StoreEvent.createHostAddedEvent(this, host);
            }
            l.hostAdded(e);
        }
    }

    protected void fireHostRemovedEvent(HostDescriptor host) {
        StoreEvent e = null;
        for (StoreListener l : this.listeners) {
            if (e == null) {
                e = StoreEvent.createHostRemovedEvent(this, host);
            }
            l.hostRemoved(e);
        }
    }

    protected void fireHostChangedEvent(HostDescriptor host, HostDescriptor oldDesc) {
        StoreEvent e = null;
        for (StoreListener l : this.listeners) {
            if (e == null) {
                e = StoreEvent.createHostChangedEvent(this, host, oldDesc);
            }
            l.hostChanged(e);
        }
    }

    protected void fireTunnelAddedEvent(HostDescriptor host, TunnelDescriptor tunnel) {
        StoreEvent e = null;
        for (StoreListener l : this.listeners) {
            if (e == null) {
                e = StoreEvent.createTunnelAddedEvent(this, host, tunnel);
            }
            l.tunnelAdded(e);
        }
    }

    protected void fireTunnelRemovedEvent(HostDescriptor host, TunnelDescriptor tunnel) {
        StoreEvent e = null;
        for (StoreListener l : this.listeners) {
            if (e == null) {
                e = StoreEvent.createTunnelRemovedEvent(this, host, tunnel);
            }
            l.tunnelRemoved(e);
        }
    }

    protected void fireTunnelChangedEvent(HostDescriptor host, TunnelDescriptor tunnel, TunnelDescriptor oldDesc) {
        StoreEvent e = null;
        for (StoreListener l : this.listeners) {
            if (e == null) {
                e = StoreEvent.createTunnelChangedEvent(this, host, tunnel, oldDesc);
            }
            l.tunnelChanged(e);
        }
    }
}

