/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.commands;

import java.sql.Connection;
import java.sql.ResultSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import oracle.dbtools.commands.CommandMessages;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.LockManager;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.IHelp;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;
import oracle.dbtools.transfer.TransferMessages;
import oracle.dbtools.transfer.location.OracleDbmsCloudStorageLocation;

public class DbcCredCommand
extends CommandListener
implements IHelp,
IShowCommand {
    private static final String CLEAR = "clear";
    private static final String HELP = "help";
    private static final String SHOW = "show";
    private static final String CRED = "cred";
    private static final String CREATE = "create";
    private static final String DROP = "drop";
    private static final String ENABLE = "enable";
    private static final String DISABLE = "disable";
    private static final String LIST = "list";
    private static final String UPDATE = "update";
    private static final String USER = "user";
    private static final String PASS = "pass";
    private static final String PASSWORD = "password";
    private static final String USER_OCID = "user_ocid";
    private static final String TENANCY_OCID = "tenancy_ocid";
    private static final String PRIVATE_KEY = "private_key";
    private static final String PRIVATE_PATH = "private_path";
    private static final String PRIVATE_KEY_PATH = "private_key_path";
    private static final String PRINT = "print";
    private static final String FINGERPRINT = "fingerprint";
    private static final String NL = "\n";
    private static final String SPACE = " ";
    private static final String DOT = ".";
    private Connection _conn;
    private OracleDbmsCloudStorageLocation _dbmsCloudLocation;
    private Map<String, Object> _props = new HashMap<String, Object>();
    private static final String listAllCredentials = "select owner, credential_name, enabled from all_credentials where comments like '%DBMS_CLOUD.create_credential%'";

    public String getCommand() {
        return "DBCCRED";
    }

    public String getHelp() {
        return CommandMessages.getString("DBCC_CMD_HELP");
    }

    public boolean isSqlPlus() {
        return false;
    }

    /*
     * Exception decompiling
     */
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK], 2[TRYBLOCK]], but top level block is 74[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void listCredentials(ScriptRunnerContext ctx) {
        DBUtil dbUtil = null;
        boolean lock = false;
        if (this._conn == null) {
            ctx.write(TransferMessages.getString("DbmsCloud_CONN_NOT_AVAILABLE") + NL);
            return;
        }
        lock = LockManager.lock((Connection)this._conn);
        if (!lock) {
            ctx.write(TransferMessages.getString("DbmsCloud_CONN_NOT_AVAILABLE") + NL);
            return;
        }
        try {
            dbUtil = DBUtil.getInstance((Connection)this._conn);
            ResultSet rs = null;
            rs = dbUtil.executeQuery(listAllCredentials, Collections.EMPTY_MAP);
            boolean found = false;
            if (rs != null) {
                while (rs.next()) {
                    found = true;
                    ctx.write(rs.getString(1) + DOT);
                    ctx.write(rs.getString(2) + SPACE);
                    ctx.write(rs.getString(3).equals("TRUE") ? "ENABLED\n" : "DISABLED\n");
                }
                if (!found) {
                    ctx.write(TransferMessages.getString("DbmsCloud_NO_CREDS_AVAIL") + NL);
                }
            } else {
                ctx.write(TransferMessages.getString("DbmsCloud_NO_CREDS_AVAIL") + NL);
            }
        }
        catch (Throwable t2) {
            dbUtil.getLastException();
            ctx.write(CommandMessages.getString("DBC_CRED_LIST_ERR") + t2.getLocalizedMessage());
        }
        finally {
            if (lock) {
                LockManager.unlock((Connection)this._conn);
            }
        }
    }

    private String[] nextBits(String[] bits, int skip) {
        if (bits.length > skip) {
            String[] rtn = new String[bits.length - skip];
            for (int j = 0; rtn.length > j; ++j) {
                rtn[j] = bits[j + skip];
            }
            return rtn;
        }
        return null;
    }

    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    public boolean handleShow(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        String cmdTrimmed = cmd.getLoweredTrimmedNoWhitespaceSQL();
        if (cmdTrimmed.startsWith("showcs") || cmdTrimmed.startsWith("showcloudstorage") || cmdTrimmed.startsWith("showcloud_storage")) {
            this.handleShow(ctx, null);
            return true;
        }
        return false;
    }

    public void handleShow(ScriptRunnerContext ctx, String qualifier) {
        this._props = (Map)ctx.getProperty("cloud.storage");
        if (this._props == null) {
            this._props = new HashMap<String, Object>();
            ctx.putProperty("cloud.storage", this._props);
        } else {
            this._props.remove("qualifier");
        }
        this._props.put("qualifier", qualifier);
        DbcCredCommand.showParms(ctx, this._props);
    }

    public static void showParms(ScriptRunnerContext ctx, Map<String, Object> props) {
        String show = "";
        ctx.write(show);
        ctx.write("");
    }

    public String[] getShowAliases() {
        return new String[]{"dbcc", "dbc_cred", "dbccred"};
    }

    public boolean needsDatabase() {
        return true;
    }

    public boolean inShowAll() {
        return true;
    }
}

