/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.sqlcl.commands.dg;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import oracle.dbtools.sqlcl.commands.dg.DgResultMessage;
import oracle.dbtools.sqlcl.commands.dg.DgXmlObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DgResult
extends DgXmlObject {
    public List<DgResultMessage> resultMsgList = new ArrayList<DgResultMessage>();
    protected static final Logger LOGGER = Logger.getLogger(DgResult.class.getName());

    public DgResult(Document xmlDoc) {
        super(xmlDoc);
        Element rootElement = xmlDoc.getDocumentElement();
        assert (rootElement.getTagName().equalsIgnoreCase("RESULT"));
        NodeList msgNodeList = rootElement.getElementsByTagName("MESSAGE");
        for (int i_msg = 0; i_msg < msgNodeList.getLength(); ++i_msg) {
            Node msgElement = msgNodeList.item(i_msg);
            DgResultMessage rm = new DgResultMessage();
            this.resultMsgList.add(rm);
            NodeList nodes = msgElement.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                Element element = (Element)nodes.item(i);
                String name = element.getTagName();
                if ("SUCCESS".equalsIgnoreCase(name)) {
                    rm.severity = 0;
                    continue;
                }
                if ("WARNING".equalsIgnoreCase(name)) {
                    rm.severity = 16502;
                    this.parseErrorMsg(rm, element);
                    continue;
                }
                if ("FAILURE".equalsIgnoreCase(name)) {
                    rm.severity = 16501;
                    this.parseErrorMsg(rm, element);
                    continue;
                }
                LOGGER.info("Unknown tag name: " + name);
            }
        }
    }

    private void parseErrorMsg(DgResultMessage rm, Element element) {
        String val = element.getAttribute("error_num");
        if (val != null) {
            rm.errNum = Integer.valueOf(val);
        }
        rm.prefix = element.getAttribute("error_prefix");
        rm.tag1 = element.getAttribute("error_tag1");
        rm.tag2 = element.getAttribute("error_tag2");
        Node fmtElement = element.getElementsByTagName("ERROR_TEXT").item(0);
        if (fmtElement != null) {
            rm.errorMsgFmt = fmtElement.getTextContent();
        } else {
            rm.errorMsg = element.getTextContent();
        }
    }
}

