/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.jdwp;

import java.util.LinkedList;
import oracle.xml.jdwp.XSLJDWPCommandSet;
import oracle.xml.jdwp.XSLJDWPConstants;
import oracle.xml.jdwp.XSLJDWPException;
import oracle.xml.jdwp.XSLJDWPLocation;
import oracle.xml.jdwp.XSLJDWPPacket;
import oracle.xml.jdwp.XSLJDWPPacketStream;

public class XSLJDWPThreadReference
extends XSLJDWPCommandSet
implements XSLJDWPConstants {
    int status = 2;
    LinkedList frames;

    public XSLJDWPThreadReference() {
        this.init();
    }

    private void init() {
        this.status = 1;
    }

    @Override
    XSLJDWPPacket execute(XSLJDWPPacket xSLJDWPPacket) {
        this.cmd = xSLJDWPPacket;
        this.cmdStrm = new XSLJDWPPacketStream(this.cmd);
        XSLJDWPPacket xSLJDWPPacket2 = null;
        switch (this.getCommand()) {
            case 1: {
                xSLJDWPPacket2 = this.nameCmd();
                break;
            }
            case 4: {
                xSLJDWPPacket2 = this.statusCmd();
                break;
            }
            case 5: {
                xSLJDWPPacket2 = this.threadGroupCmd();
                break;
            }
            case 6: {
                xSLJDWPPacket2 = this.framesCmd();
                break;
            }
            case 7: {
                xSLJDWPPacket2 = this.frameCountCmd();
                break;
            }
            default: {
                xSLJDWPPacket2 = this.cmd.createErrorReply((short)99);
            }
        }
        return xSLJDWPPacket2;
    }

    XSLJDWPPacket nameCmd() {
        XSLJDWPPacketStream xSLJDWPPacketStream = new XSLJDWPPacketStream(this.cmd.createReply());
        try {
            xSLJDWPPacketStream.writeString("XSLTMain");
        }
        catch (XSLJDWPException xSLJDWPException) {
            return this.cmd.createErrorReply(xSLJDWPException.errorCode());
        }
        xSLJDWPPacketStream.close();
        return xSLJDWPPacketStream.packet();
    }

    XSLJDWPPacket statusCmd() {
        int n = this.cmdStrm.readThreadID();
        XSLJDWPPacketStream xSLJDWPPacketStream = new XSLJDWPPacketStream(this.cmd.createReply());
        xSLJDWPPacketStream.writeInt(this.getStatus());
        xSLJDWPPacketStream.writeInt(this.getSuspendStatus());
        xSLJDWPPacketStream.close();
        return xSLJDWPPacketStream.packet();
    }

    XSLJDWPPacket threadGroupCmd() {
        XSLJDWPPacketStream xSLJDWPPacketStream = new XSLJDWPPacketStream(this.cmd.createReply());
        xSLJDWPPacketStream.writeThreadGroupID(11);
        xSLJDWPPacketStream.close();
        return xSLJDWPPacketStream.packet();
    }

    XSLJDWPPacket framesCmd() {
        int n = this.cmdStrm.readThreadID();
        int n2 = this.cmdStrm.readInt();
        int n3 = this.cmdStrm.readInt();
        XSLJDWPPacketStream xSLJDWPPacketStream = new XSLJDWPPacketStream(this.cmd.createReply());
        XSLJDWPLocation[] xSLJDWPLocationArray = this.getFramesData(n, n2, n3);
        int n4 = xSLJDWPLocationArray.length;
        xSLJDWPPacketStream.writeInt(n4);
        for (int i = 0; i < n4; ++i) {
            xSLJDWPPacketStream.writeFrameID(n2 + this.frames.size() - i);
            xSLJDWPPacketStream.writeLocation(xSLJDWPLocationArray[i]);
        }
        xSLJDWPPacketStream.close();
        return xSLJDWPPacketStream.packet();
    }

    XSLJDWPPacket frameCountCmd() {
        int n = this.cmdStrm.readThreadID();
        XSLJDWPPacketStream xSLJDWPPacketStream = new XSLJDWPPacketStream(this.cmd.createReply());
        xSLJDWPPacketStream.writeInt(this.getFrameCountData(n));
        xSLJDWPPacketStream.close();
        return xSLJDWPPacketStream.packet();
    }

    synchronized int getStatus() {
        return this.status;
    }

    int getSuspendStatus() {
        if (this.jdwpvm.xsl.getSuspendCount() > 0) {
            return 1;
        }
        return 0;
    }

    private int getFrameCountData(int n) {
        if (this.frames == null) {
            this.frames = this.jdwpvm.xsl.getFrames();
        }
        return this.frames.size();
    }

    private XSLJDWPLocation[] getFramesData(int n, int n2, int n3) {
        if (this.frames == null) {
            this.frames = this.jdwpvm.xsl.getFrames();
        }
        int n4 = this.frames.size();
        int n5 = n3 == -1 ? n4 : (n3 > n4 ? n4 : n3);
        XSLJDWPLocation[] xSLJDWPLocationArray = new XSLJDWPLocation[n5];
        int n6 = 0;
        n5 = n4 - n5;
        for (int i = n4 - 1; i >= n5; --i) {
            xSLJDWPLocationArray[n6++] = (XSLJDWPLocation)this.frames.get(i);
        }
        return xSLJDWPLocationArray;
    }
}

