/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.scriptrunner.commands.liquibase;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.DriverManager;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Filter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import liquibase.CatalogAndSchema;
import liquibase.Contexts;
import liquibase.LabelExpression;
import liquibase.Liquibase;
import liquibase.RuntimeEnvironment;
import liquibase.Scope;
import liquibase.changelog.ChangeLogHistoryServiceFactory;
import liquibase.changelog.ChangeLogIterator;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.changelog.filter.ChangeSetFilter;
import liquibase.changelog.filter.ContextChangeSetFilter;
import liquibase.changelog.filter.DbmsChangeSetFilter;
import liquibase.changelog.filter.IgnoreChangeSetFilter;
import liquibase.changelog.filter.LabelChangeSetFilter;
import liquibase.changelog.filter.ShouldRunChangeSetFilter;
import liquibase.changelog.visitor.ChangeSetVisitor;
import liquibase.changelog.visitor.OracleSkippedChangeVisitor;
import liquibase.configuration.SqlclConfig;
import liquibase.configuration.SqlclConfigWrapper;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.DatabaseFactory;
import liquibase.database.ext.OracleDatabaseV2;
import liquibase.database.jvm.JdbcConnection;
import liquibase.diff.DiffResult;
import liquibase.diff.compare.CompareControl;
import liquibase.diff.output.DiffOutputControl;
import liquibase.diff.output.ObjectChangeFilter;
import liquibase.diff.output.StandardObjectChangeFilter;
import liquibase.diff.output.changelog.DiffToChangeLog;
import liquibase.exception.DatabaseException;
import liquibase.integration.commandline.Main;
import liquibase.lockservice.DatabaseChangeLogLock;
import liquibase.logging.LogService;
import liquibase.logging.core.JavaLogService;
import liquibase.resource.FileSystemResourceAccessor;
import liquibase.resource.ResourceAccessor;
import liquibase.structure.core.Data;
import liquibase.util.LiquibaseUtil;
import oracle.dbtools.common.utils.FileUtils;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.liquibase.exceptions.ProcessFailedException;
import oracle.dbtools.raptor.liquibase.exceptions.PropertyNotFoundException;
import oracle.dbtools.raptor.liquibase.generator.SchemaGenerator;
import oracle.dbtools.raptor.liquibase.logging.LogTableManager;
import oracle.dbtools.raptor.liquibase.utils.LbExceptionHandler;
import oracle.dbtools.raptor.liquibase.utils.LbFileUtils;
import oracle.dbtools.raptor.liquibase.utils.LbStringUtils;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.apex.InvalidParameterException;
import oracle.dbtools.raptor.scriptrunner.commands.liquibase.Messages;
import oracle.dbtools.util.Service;

public class LiquibaseActions {
    public static ArrayList<String> getAllApexParameters() {
        return LiquibaseActions.getConfig().getApexParms();
    }

    public static List<String> getAllErrors() {
        return LiquibaseActions.getConfig().getAllErrors();
    }

    public static HashMap<String, String> getAllLbParameters() {
        return LiquibaseActions.getConfig().getLbParms();
    }

    public static boolean getBoolenParameter(String name) {
        return Boolean.parseBoolean(LiquibaseActions.getLbParameter(name));
    }

    public static SqlclConfig getConfig() {
        return (SqlclConfig)SqlclConfigWrapper.SQLCL_CONFIG.getCurrentValue();
    }

    public static ScriptRunnerContext getContext() {
        return LiquibaseActions.getConfig().getContext();
    }

    public static String getLbParameter(String name) {
        return LiquibaseActions.getConfig().getLbParameter(name);
    }

    public static String getLbVersion() throws ProcessFailedException {
        StringBuilder sb = new StringBuilder();
        sb.append("\nLiquibase version:   " + LiquibaseUtil.getBuildVersion());
        sb.append("\nExtension Version:   " + Messages.getString("SQLclVersion.VERSION"));
        sb.append("\n\n");
        return sb.toString();
    }

    public static Liquibase getLiquibase(DatabaseConnection conn, String changelog, String cwd) throws ProcessFailedException {
        try {
            Path filePath;
            ArrayList<File> list = new ArrayList<File>();
            conn.setAutoCommit(false);
            changelog = changelog != null ? LbStringUtils.trim(changelog) : "";
            if (changelog.startsWith("../")) {
                changelog = changelog.replaceFirst("../", "");
                filePath = Paths.get(Paths.get(LiquibaseActions.getContext().prependCD(changelog), new String[0]).normalize().getParent().getParent() + File.separator + changelog, new String[0]);
            } else {
                filePath = Paths.get(changelog, new String[0]).isAbsolute() ? Paths.get(changelog, new String[0]).normalize() : Paths.get(LiquibaseActions.getContext().prependCD(changelog), new String[0]).normalize();
            }
            if (filePath != null && filePath.getRoot() != null) {
                list.add(filePath.getRoot().toFile());
            }
            if (filePath != null && filePath.getParent() != null) {
                list.add(filePath.getParent().toFile());
            }
            if (list.size() == 0) {
                list.add(Paths.get(".", new String[0]).toFile());
            }
            String fileName = filePath.getFileName().toString();
            File[] mypaths = new File[list.size()];
            list.toArray(mypaths);
            Liquibase liquibase = new Liquibase(fileName, (ResourceAccessor)new FileSystemResourceAccessor(mypaths), conn);
            Database database = liquibase.getDatabase();
            LiquibaseActions.resetErrors();
            LogTableManager.createUpdateLogTable(database);
            return liquibase;
        }
        catch (Exception e) {
            LbExceptionHandler.handleError(e, e.getStackTrace()[1].getMethodName(), false);
            if (e instanceof ProcessFailedException) {
                throw (ProcessFailedException)e;
            }
            throw new ProcessFailedException(e, Thread.currentThread().getStackTrace()[1].getMethodName());
        }
    }

    public static void resetErrors() {
        LiquibaseActions.getConfig().resetErrorList();
    }

    public static void setContext(ScriptRunnerContext ctx) {
        LiquibaseActions.getConfig().setContext(ctx);
    }

    public static void setLbParameter(String name, String value) throws PropertyNotFoundException {
        LiquibaseActions.getConfig().setLbParameter(name, value);
    }

    public static void setLogLevel(Level level) {
        Logger rootLogger = Logger.getLogger("");
        Logger liquibaseLogger = Logger.getLogger("liquibase");
        liquibaseLogger.setParent(rootLogger);
        JavaLogService logService = (JavaLogService)Scope.getCurrentScope().get((Enum)Scope.Attr.logService, LogService.class);
        logService.setParent(liquibaseLogger);
        if (level.intValue() < Level.INFO.intValue()) {
            rootLogger.setLevel(Level.INFO);
        } else {
            rootLogger.setLevel(level);
        }
        liquibaseLogger.setLevel(level);
        for (Handler handler : rootLogger.getHandlers()) {
            handler.setLevel(level);
            handler.setFilter((Filter)new Main.SecureLogFilter(logService.getFilter()));
        }
    }

    protected static String doRollbackWork(Connection conn, StringWriter writer) throws ProcessFailedException {
        StringBuilder sb = new StringBuilder();
        boolean isSqlCl = LiquibaseActions.getBoolenParameter("isSqlCl");
        LiquibaseActions.validate_action_table(conn);
        try {
            Liquibase liquibase = LiquibaseActions.getLiquibase((DatabaseConnection)new JdbcConnection(conn), LiquibaseActions.getLbParameter("changelog"), LiquibaseActions.getContext().prependCD(""));
            Database database = liquibase.getDatabase();
            SimpleDateFormat dtFmt = new SimpleDateFormat("MM/dd/yyyy");
            String mydate = LiquibaseActions.getLbParameter("date");
            int count = 0;
            Date date = null;
            try {
                count = Integer.valueOf(LiquibaseActions.getLbParameter("count"));
            }
            catch (Exception e) {
                count = 0;
            }
            try {
                date = dtFmt.parse(mydate);
            }
            catch (Exception e) {
                date = null;
            }
            if (date == null && count == 0) {
                throw new ProcessFailedException((Exception)new InvalidParameterException("ERROR: count or date must be supplied"), Thread.currentThread().getStackTrace()[1].getMethodName());
            }
            if (date != null && count > 0) {
                throw new ProcessFailedException((Exception)new InvalidParameterException("ERROR: either count or date must be supplied not both "), Thread.currentThread().getStackTrace()[1].getMethodName());
            }
            if (count > 0) {
                if (writer == null) {
                    liquibase.rollback(count, new Contexts(LiquibaseActions.getLbParameter("context")), new LabelExpression(LiquibaseActions.getLbParameter("label")));
                } else {
                    liquibase.rollback(count, new Contexts(LiquibaseActions.getLbParameter("context")), new LabelExpression(LiquibaseActions.getLbParameter("label")), (Writer)writer);
                }
            } else if (date != null) {
                if (writer == null) {
                    liquibase.rollback(date, new Contexts(LiquibaseActions.getLbParameter("context")), new LabelExpression(LiquibaseActions.getLbParameter("label")));
                } else {
                    liquibase.rollback(date, new Contexts(LiquibaseActions.getLbParameter("context")), new LabelExpression(LiquibaseActions.getLbParameter("label")), (Writer)writer);
                }
            } else {
                throw new ProcessFailedException((Exception)new InvalidParameterException("ERROR: Don't know how to apply rollback "), Thread.currentThread().getStackTrace()[1].getMethodName());
            }
            if (writer != null) {
                sb.append(writer);
            }
            if (database instanceof OracleDatabaseV2) {
                sb.append("######## ERROR SUMMARY ##################\n");
                sb.append("Errors encountered:" + LiquibaseActions.getAllErrors().size() + "\n\n");
                for (String error : LiquibaseActions.getAllErrors()) {
                    sb.append(error + "\n");
                }
            }
            if (LiquibaseActions.getBoolenParameter("log") && LiquibaseActions.getAllErrors().size() > 0) {
                String fileName = LiquibaseActions.getLbParameter("changelog") + "-ERRORS-" + new Date().getTime() + ".log";
                FileWriter fileWriter = new FileWriter(LiquibaseActions.getContext().prependCD("") + fileName);
                fileWriter.write("######## ERROR SUMMARY ##################\n");
                fileWriter.write("Errors encountered:" + LiquibaseActions.getAllErrors().size() + "\n\n");
                for (String error : LiquibaseActions.getAllErrors()) {
                    fileWriter.write(error + "\n");
                }
                ((Writer)fileWriter).close();
            }
            if (isSqlCl) {
                LiquibaseActions.getContext().write(sb.toString());
                return null;
            }
            return sb.toString();
        }
        catch (Exception e) {
            LbExceptionHandler.handleError(e, e.getStackTrace()[1].getMethodName(), false);
            if (e instanceof ProcessFailedException) {
                throw (ProcessFailedException)e;
            }
            throw new ProcessFailedException(e, Thread.currentThread().getStackTrace()[1].getMethodName());
        }
    }

    protected static String doUpdateWork(Connection conn, StringWriter writer) throws ProcessFailedException {
        boolean isSqlCl = LiquibaseActions.getBoolenParameter("isSqlCl");
        StringBuilder sb = new StringBuilder();
        LiquibaseActions.validate_action_table(conn);
        try {
            Liquibase liquibase = LiquibaseActions.getLiquibase((DatabaseConnection)new JdbcConnection(conn), LiquibaseActions.getLbParameter("changelog"), LiquibaseActions.getContext().prependCD(""));
            Database database = liquibase.getDatabase();
            if (LiquibaseActions.getBoolenParameter("log")) {
                String fileName = LiquibaseActions.getLbParameter("changelog") + "-" + new Date().getTime() + ".log";
                FileOutputStream fw = new FileOutputStream(LiquibaseActions.getContext().prependCD("") + fileName);
                BufferedOutputStream out = new BufferedOutputStream(fw);
                LiquibaseActions.getConfig().setOutputBuffer(out);
            }
            DatabaseChangeLog changeLog = liquibase.getDatabaseChangeLog();
            ChangeLogIterator changeLogIterator = LiquibaseActions.getStandardChangelogIterator(new Contexts(), new LabelExpression(LiquibaseActions.getLbParameter("label")), changeLog, database);
            ChangeLogHistoryServiceFactory.getInstance().getChangeLogService(database).generateDeploymentId();
            changeLogIterator.run((ChangeSetVisitor)new OracleSkippedChangeVisitor(ChangeLogHistoryServiceFactory.getInstance().getChangeLogService(database).getDeploymentId()), new RuntimeEnvironment(database, new Contexts(), new LabelExpression(LiquibaseActions.getLbParameter("label"))));
            if (writer == null) {
                liquibase.update(new Contexts(), new LabelExpression(LiquibaseActions.getLbParameter("label")));
            } else {
                liquibase.update(new Contexts(), new LabelExpression(LiquibaseActions.getLbParameter("label")), (Writer)writer);
            }
            if (writer != null) {
                sb.append(writer + "\n");
            }
            if (database instanceof OracleDatabaseV2) {
                sb.append("######## ERROR SUMMARY ##################\n");
                sb.append("Errors encountered:" + LiquibaseActions.getAllErrors().size() + "\n\n");
                for (String error : LiquibaseActions.getAllErrors()) {
                    sb.append("######## ERROR ##################\n");
                    sb.append(error);
                    sb.append("######## ERROR END ##################\n");
                }
                sb.append("######## END ERROR SUMMARY ##################\n");
            }
            if (LiquibaseActions.getAllErrors() != null && LiquibaseActions.getAllErrors().size() > 0 && isSqlCl) {
                String fileName = LiquibaseActions.getLbParameter("changelog") + "-ERRORS-" + new Date().getTime() + ".log";
                FileWriter fileWriter = new FileWriter(LiquibaseActions.getContext().prependCD("") + fileName);
                fileWriter.write(sb.toString());
                ((Writer)fileWriter).close();
            }
            if (isSqlCl) {
                LiquibaseActions.getContext().write(sb.toString());
                return null;
            }
            return sb.toString();
        }
        catch (Exception e) {
            LbExceptionHandler.handleError(e, e.getStackTrace()[1].getMethodName(), false);
            if (e instanceof ProcessFailedException) {
                throw (ProcessFailedException)e;
            }
            throw new ProcessFailedException(e, Thread.currentThread().getStackTrace()[1].getMethodName());
        }
    }

    protected static HashMap<String, String> genApexObjectChangelogsWork(Connection conn) throws ProcessFailedException {
        SchemaGenerator gen = new SchemaGenerator(conn);
        boolean isSqlCl = LiquibaseActions.getBoolenParameter("isSqlCl");
        StringBuilder sb = new StringBuilder();
        try {
            HashMap<String, String> logs = gen.getApexChangeLogs(LiquibaseActions.getAllLbParameters(), sb);
            if (isSqlCl) {
                gen.writeChangeLogMap(logs, LiquibaseActions.getContext());
                return null;
            }
            return logs;
        }
        catch (Exception e) {
            LbExceptionHandler.handleError(e, e.getStackTrace()[1].getMethodName(), false);
            if (e instanceof ProcessFailedException) {
                throw (ProcessFailedException)e;
            }
            throw new ProcessFailedException(e, Thread.currentThread().getStackTrace()[1].getMethodName());
        }
    }

    protected static String genControlFileWork(Connection conn) throws ProcessFailedException {
        boolean isSqlCl = LiquibaseActions.getBoolenParameter("isSqlCl");
        SchemaGenerator gen = new SchemaGenerator(conn);
        String fileName = ((SqlclConfig)SqlclConfigWrapper.SQLCL_CONFIG.getCurrentValue()).getControllerFileName() + ".XML".toLowerCase();
        try {
            String cwd = FileUtils.getCWD((ScriptRunnerContext)LiquibaseActions.getContext());
            Path path = Paths.get(cwd + "/" + fileName, new String[0]);
            int i = 1;
            String newFile = null;
            while (Files.exists(path, new LinkOption[0])) {
                newFile = fileName.replace(".", i + ".");
                ++i;
                path = Paths.get(cwd + "/" + newFile, new String[0]);
            }
            gen.getMasterLog();
            if (isSqlCl) {
                gen.writeMasterLog(path);
                LiquibaseActions.getContext().write(MessageFormat.format(Messages.getString("LB_FILE_CREATED"), path.getFileName().toString()));
                return null;
            }
            return gen.getMasterLog();
        }
        catch (Exception e) {
            LbExceptionHandler.handleError(e, e.getStackTrace()[1].getMethodName(), false);
            if (e instanceof ProcessFailedException) {
                throw (ProcessFailedException)e;
            }
            throw new ProcessFailedException(e, Thread.currentThread().getStackTrace()[1].getMethodName());
        }
    }

    protected static String genDbDocWork(Connection conn) throws ProcessFailedException {
        try {
            boolean isSqlCl = LiquibaseActions.getBoolenParameter("isSqlCl");
            Liquibase liquibase = LiquibaseActions.getLiquibase((DatabaseConnection)new JdbcConnection(conn), LiquibaseActions.getLbParameter("changelog"), LiquibaseActions.getContext().prependCD(""));
            Database database = liquibase.getDatabase();
            String dir = LiquibaseActions.getLbParameter("dir");
            if (dir.equalsIgnoreCase(".")) {
                dir = FileUtils.getCWD((ScriptRunnerContext)LiquibaseActions.getContext());
            } else if (dir.startsWith(".")) {
                dir = dir.replaceFirst(".", FileUtils.getCWD((ScriptRunnerContext)LiquibaseActions.getContext()));
            }
            liquibase.generateDocumentation(dir, new Contexts(LiquibaseActions.getLbParameter("context")), new LabelExpression(LiquibaseActions.getLbParameter("label")));
            StringBuffer sb = new StringBuffer();
            sb.append(MessageFormat.format(Messages.getString("LB_DBDOC_DONE"), dir));
            if (database instanceof OracleDatabaseV2) {
                sb.append("\n######## ERROR SUMMARY ##################\nErrors encountered:");
                sb.append("Errors encountered:" + LiquibaseActions.getAllErrors().size() + "\n\n");
                for (String error : LiquibaseActions.getAllErrors()) {
                    sb.append(error + "\n");
                }
            }
            if (isSqlCl) {
                LiquibaseActions.getContext().write(sb.toString());
                return null;
            }
            return sb.toString();
        }
        catch (Exception e) {
            LbExceptionHandler.handleError(e, e.getStackTrace()[1].getMethodName(), false);
            if (e instanceof ProcessFailedException) {
                throw (ProcessFailedException)e;
            }
            throw new ProcessFailedException(e, Thread.currentThread().getStackTrace()[1].getMethodName());
        }
    }

    protected static String genDbObjectChangelogWork(Connection conn) throws ProcessFailedException {
        String fName;
        boolean isSqlCl = LiquibaseActions.getBoolenParameter("isSqlCl");
        String name = LiquibaseActions.getLbParameter("name").contains("\"") ? Service.handleMixedCase((String)LiquibaseActions.getLbParameter("name"), (boolean)true) : LiquibaseActions.getLbParameter("name").toUpperCase();
        SchemaGenerator gen = new SchemaGenerator(conn);
        if (!isSqlCl) {
            return gen.getChangeLog(LiquibaseActions.getAllLbParameters());
        }
        String fileName = fName = (name + "_" + LiquibaseActions.getLbParameter("type") + ".xml").toLowerCase();
        int count = 1;
        File file = new File(LiquibaseActions.getContext().prependCD(FileUtils.decodeIfFile((String)fName)));
        while (file.exists()) {
            fileName = fName.replace(".xml", count++ + ".xml");
            file = new File(LiquibaseActions.getContext().prependCD(FileUtils.decodeIfFile((String)fileName)));
        }
        try {
            LiquibaseActions.setLbParameter("name", name);
            LiquibaseActions.setLbParameter("filename", fileName);
            gen.writeChangeLog(LiquibaseActions.getAllLbParameters());
            LiquibaseActions.getContext().write(MessageFormat.format(Messages.getString("LB_FILE_CREATED"), fileName));
            return null;
        }
        catch (Exception e) {
            LbExceptionHandler.handleError(e, e.getStackTrace()[1].getMethodName(), false);
            if (e instanceof ProcessFailedException) {
                throw (ProcessFailedException)e;
            }
            throw new ProcessFailedException(e, Thread.currentThread().getStackTrace()[1].getMethodName());
        }
    }

    protected static HashMap<String, String> genDbSchemaWork(Connection conn) throws ProcessFailedException {
        SchemaGenerator gen = new SchemaGenerator(conn);
        try {
            return gen.doSchemaExport();
        }
        catch (Exception e) {
            LbExceptionHandler.handleError(e, e.getStackTrace()[1].getMethodName(), false);
            if (e instanceof ProcessFailedException) {
                throw (ProcessFailedException)e;
            }
            throw new ProcessFailedException(e, Thread.currentThread().getStackTrace()[1].getMethodName());
        }
    }

    protected static HashMap<String, String> genDiffWork(Connection conn) throws ProcessFailedException {
        boolean isSqlCl = LiquibaseActions.getBoolenParameter("isSqlCl");
        StringBuilder sbLog = new StringBuilder();
        StringBuilder sbDiff = new StringBuilder();
        String difName = null;
        try {
            Connection c = DriverManager.getConnection("jdbc:oracle:thin:@" + LiquibaseActions.getLbParameter("url"), LiquibaseActions.getLbParameter("user"), LiquibaseActions.getLbParameter("password"));
            Liquibase liquibase = LiquibaseActions.getLiquibase((DatabaseConnection)new JdbcConnection(c), null, null);
            Database database = liquibase.getDatabase();
            Database source = DatabaseFactory.getInstance().findCorrectDatabaseImplementation((DatabaseConnection)new JdbcConnection(conn));
            Database dest = liquibase.getDatabase();
            DiffResult diff = liquibase.diff(source, dest, CompareControl.STANDARD);
            if (LiquibaseActions.getBoolenParameter("report")) {
                if (isSqlCl) {
                    difName = LbFileUtils.writeFile(LiquibaseActions.getContext(), ((SqlclConfig)SqlclConfigWrapper.SQLCL_CONFIG.getCurrentValue()).getDiffFileName(false), LbStringUtils.diffToString(diff));
                    LiquibaseActions.getContext().write(MessageFormat.format(Messages.getString("LB_FILE_CREATED"), difName));
                } else {
                    sbDiff.append(LbStringUtils.diffToString(diff));
                }
            } else if (isSqlCl) {
                difName = LbFileUtils.writeFile(LiquibaseActions.getContext(), ((SqlclConfig)SqlclConfigWrapper.SQLCL_CONFIG.getCurrentValue()).getDiffFileName(true), LbStringUtils.diffToChangeLog(diff));
                LiquibaseActions.getContext().write(MessageFormat.format(Messages.getString("LB_FILE_CREATED"), difName));
            } else {
                sbDiff.append(LbStringUtils.diffToChangeLog(diff));
            }
            if (database instanceof OracleDatabaseV2) {
                List<String> errors = LiquibaseActions.getAllErrors();
                sbLog.append("######## ERROR SUMMARY ##################\n");
                sbLog.append("Errors encountered:" + errors.size() + "\n\n");
                for (String error : errors) {
                    sbLog.append(error + "\n");
                }
                if (LiquibaseActions.getBoolenParameter("log") && errors.size() > 0) {
                    String fileName = LiquibaseActions.getLbParameter("changelog") + "-ERRORS-" + new Date().getTime() + ".log";
                    FileWriter fileWriter = new FileWriter(LiquibaseActions.getContext().prependCD("") + fileName);
                    fileWriter.write("######## ERROR SUMMARY ##################\n");
                    fileWriter.write("Errors encountered:" + errors.size() + "\n\n");
                    for (String error : errors) {
                        fileWriter.write(error + "\n");
                    }
                    ((Writer)fileWriter).close();
                }
            }
            HashMap<String, String> returnMap = new HashMap<String, String>();
            returnMap.put(((SqlclConfig)SqlclConfigWrapper.SQLCL_CONFIG.getCurrentValue()).getLogFileName(), sbLog.toString());
            returnMap.put(difName, sbDiff.toString());
            return returnMap;
        }
        catch (Exception e) {
            LbExceptionHandler.handleError(e, e.getStackTrace()[1].getMethodName(), false);
            if (e instanceof ProcessFailedException) {
                throw (ProcessFailedException)e;
            }
            throw new ProcessFailedException(e, Thread.currentThread().getStackTrace()[1].getMethodName());
        }
    }

    protected static String genOrdsObjectChangelogWork(Connection conn) throws ProcessFailedException, PropertyNotFoundException {
        boolean isSqlCl = LiquibaseActions.getBoolenParameter("isSqlCl");
        SchemaGenerator gen = new SchemaGenerator(conn);
        String fileName = null;
        if (!isSqlCl) {
            return gen.getOrdsChangeLog(LiquibaseActions.getAllLbParameters());
        }
        fileName = LiquibaseActions.getLbParameter("name") != null && !LiquibaseActions.getLbParameter("name").equals("") ? ("ords-rest_" + LiquibaseActions.getLbParameter("name")).toLowerCase() : "ords-rest_schema".toLowerCase();
        int count = 1;
        File file = new File(LiquibaseActions.getContext().prependCD(FileUtils.decodeIfFile((String)(fileName + ".xml"))));
        while (file.exists()) {
            fileName = (fileName + count++ + ".xml").toLowerCase();
            file = new File(LiquibaseActions.getContext().prependCD(FileUtils.decodeIfFile((String)fileName)));
        }
        fileName = file.getName();
        try {
            LiquibaseActions.setLbParameter("filename", fileName);
            gen.writeOrdsChangeLog(LiquibaseActions.getAllLbParameters());
            LiquibaseActions.getContext().write(MessageFormat.format(Messages.getString("LB_FILE_CREATED"), fileName));
            return null;
        }
        catch (Exception e) {
            LbExceptionHandler.handleError(e, e.getStackTrace()[1].getMethodName(), false);
            if (e instanceof ProcessFailedException) {
                throw (ProcessFailedException)e;
            }
            throw new ProcessFailedException(e, Thread.currentThread().getStackTrace()[1].getMethodName());
        }
    }

    protected static String genTableDataWork(Connection conn) throws ProcessFailedException {
        StandardObjectChangeFilter.FilterType type = null;
        StandardObjectChangeFilter filter = null;
        boolean isSqlCl = LiquibaseActions.getBoolenParameter("isSqlCl");
        try {
            String tableNamesPattern;
            Liquibase liquibase = LiquibaseActions.getLiquibase((DatabaseConnection)new JdbcConnection(conn), null, null);
            Database database = liquibase.getDatabase();
            CatalogAndSchema catalogAndSchema = new CatalogAndSchema(database.getDefaultCatalogName(), database.getDefaultSchemaName());
            DiffOutputControl diffOutputControl = new DiffOutputControl(false, false, false, null);
            if (LiquibaseActions.getLbParameter("object") != null) {
                type = LiquibaseActions.getLbParameter("filter") != null && LiquibaseActions.getLbParameter("filter").equalsIgnoreCase("exclude") ? StandardObjectChangeFilter.FilterType.EXCLUDE : StandardObjectChangeFilter.FilterType.INCLUDE;
                tableNamesPattern = LiquibaseActions.getLbParameter("object").toUpperCase();
                filter = new StandardObjectChangeFilter(type, tableNamesPattern);
                diffOutputControl.setObjectChangeFilter((ObjectChangeFilter)filter);
            } else if (LiquibaseActions.getLbParameter("filter") == null && LiquibaseActions.getLbParameter("object") == null) {
                type = StandardObjectChangeFilter.FilterType.EXCLUDE;
                tableNamesPattern = "DATABASECHANGELOG_ACTIONS,DATABASECHANGELOGLOCK,DATABASECHANGELOG";
                filter = new StandardObjectChangeFilter(type, "DATABASECHANGELOG_ACTIONS,DATABASECHANGELOGLOCK,DATABASECHANGELOG");
                diffOutputControl.setObjectChangeFilter((ObjectChangeFilter)filter);
            } else {
                throw new ProcessFailedException(null, "Invalid Parameters");
            }
            DiffToChangeLog diffToChangeLog = new DiffToChangeLog(diffOutputControl);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            PrintStream printStream = new PrintStream((OutputStream)out, true, "UTF-8");
            liquibase.generateChangeLog(catalogAndSchema, diffToChangeLog, printStream, new Class[]{Data.class});
            printStream.close();
            if (isSqlCl) {
                String name = LbFileUtils.writeFile(LiquibaseActions.getContext(), "data.xml", out.toString("UTF-8"));
                LiquibaseActions.getContext().write(MessageFormat.format(Messages.getString("LB_FILE_CREATED"), name));
                return null;
            }
            return out.toString("UTF-8");
        }
        catch (Exception e) {
            LbExceptionHandler.handleError(e, e.getStackTrace()[1].getMethodName(), false);
            if (e instanceof ProcessFailedException) {
                throw (ProcessFailedException)e;
            }
            throw new ProcessFailedException(e, Thread.currentThread().getStackTrace()[1].getMethodName());
        }
    }

    protected static String lbChangeLogSyncWork(Connection conn) throws ProcessFailedException {
        try {
            StringWriter sw = new StringWriter();
            boolean isSqlCl = LiquibaseActions.getBoolenParameter("isSqlCl");
            Liquibase liquibase = LiquibaseActions.getLiquibase((DatabaseConnection)new JdbcConnection(conn), LiquibaseActions.getLbParameter("changelog"), LiquibaseActions.getContext().prependCD(""));
            liquibase.changeLogSync(new Contexts(), new LabelExpression(LiquibaseActions.getLbParameter("label")), (Writer)sw);
            if (isSqlCl) {
                LiquibaseActions.getContext().write(sw.toString());
                LiquibaseActions.getContext().write(Messages.getString("LB_OPERATION_SUCCESS"));
                return null;
            }
            return sw.toString() + "\n -- " + Messages.getString("LB_OPERATION_SUCCESS");
        }
        catch (Exception e) {
            LbExceptionHandler.handleError(e, e.getStackTrace()[1].getMethodName(), false);
            if (e instanceof ProcessFailedException) {
                throw (ProcessFailedException)e;
            }
            throw new ProcessFailedException(e, Thread.currentThread().getStackTrace()[1].getMethodName());
        }
    }

    protected static String lbClearCheckSumsWork(Connection conn) throws ProcessFailedException {
        try {
            boolean isSqlCl = LiquibaseActions.getBoolenParameter("isSqlCl");
            Liquibase liquibase = LiquibaseActions.getLiquibase((DatabaseConnection)new JdbcConnection(conn), LiquibaseActions.getLbParameter("changelog"), LiquibaseActions.getContext().prependCD(""));
            liquibase.clearCheckSums();
            if (isSqlCl) {
                LiquibaseActions.getContext().write(MessageFormat.format(Messages.getString("LB_CHECK_SUCCESS"), LiquibaseActions.getLbParameter("changelog")));
                return null;
            }
            return MessageFormat.format(Messages.getString("LB_CHECK_SUCCESS"), LiquibaseActions.getLbParameter("changelog"));
        }
        catch (Exception e) {
            LbExceptionHandler.handleError(e, e.getStackTrace()[1].getMethodName(), false);
            if (e instanceof ProcessFailedException) {
                throw (ProcessFailedException)e;
            }
            throw new ProcessFailedException(e, Thread.currentThread().getStackTrace()[1].getMethodName());
        }
    }

    protected static String lbListLocksWork(Connection conn) throws ProcessFailedException {
        try {
            boolean isSqlCl = LiquibaseActions.getBoolenParameter("isSqlCl");
            Liquibase liquibase = LiquibaseActions.getLiquibase((DatabaseConnection)new JdbcConnection(conn), LiquibaseActions.getLbParameter("changelog"), LiquibaseActions.getContext().prependCD(""));
            DatabaseChangeLogLock[] locks = liquibase.listLocks();
            StringBuffer sb = new StringBuffer();
            if (locks.length > 0) {
                sb.append("\nID\t\tUSER\n");
                for (DatabaseChangeLogLock lock : locks) {
                    sb.append(Messages.getString(lock.getId() + "\t\t" + lock.getLockedBy() + "\n"));
                }
            } else {
                sb.append(Messages.getString("LB_NO_LOCKS"));
            }
            if (isSqlCl) {
                LiquibaseActions.getContext().write(sb.toString());
                return null;
            }
            return sb.toString();
        }
        catch (Exception e) {
            LbExceptionHandler.handleError(e, e.getStackTrace()[1].getMethodName(), false);
            if (e instanceof ProcessFailedException) {
                throw (ProcessFailedException)e;
            }
            throw new ProcessFailedException(e, Thread.currentThread().getStackTrace()[1].getMethodName());
        }
    }

    protected static String lbReleaseLocksWork(Connection conn) throws ProcessFailedException {
        boolean isSqlCl = LiquibaseActions.getBoolenParameter("isSqlCl");
        try {
            Liquibase liquibase = LiquibaseActions.getLiquibase((DatabaseConnection)new JdbcConnection(conn), LiquibaseActions.getLbParameter("changelog"), LiquibaseActions.getContext().prependCD(""));
            liquibase.forceReleaseLocks();
            if (isSqlCl) {
                LiquibaseActions.getContext().write(MessageFormat.format(Messages.getString("LB_LOCK_SUCCESS"), LiquibaseActions.getLbParameter("changelog")));
                return null;
            }
            return MessageFormat.format(Messages.getString("LB_LOCK_SUCCESS"), LiquibaseActions.getLbParameter("changelog"));
        }
        catch (Exception e) {
            LbExceptionHandler.handleError(e, e.getStackTrace()[1].getMethodName(), false);
            if (e instanceof ProcessFailedException) {
                throw (ProcessFailedException)e;
            }
            throw new ProcessFailedException(e, Thread.currentThread().getStackTrace()[1].getMethodName());
        }
    }

    protected static String lbStatusWork(Connection conn) throws ProcessFailedException {
        try {
            boolean isSqlCl = LiquibaseActions.getBoolenParameter("isSqlCl");
            Liquibase liquibase = LiquibaseActions.getLiquibase((DatabaseConnection)new JdbcConnection(conn), LiquibaseActions.getLbParameter("changelog"), LiquibaseActions.getContext().prependCD(""));
            StringWriter sw = new StringWriter();
            liquibase.reportStatus(true, LiquibaseActions.getLbParameter("context"), (Writer)sw);
            if (isSqlCl) {
                LiquibaseActions.getContext().write(sw.toString());
                return null;
            }
            return sw.toString();
        }
        catch (Exception e) {
            LbExceptionHandler.handleError(e, e.getStackTrace()[1].getMethodName(), false);
            if (e instanceof ProcessFailedException) {
                throw (ProcessFailedException)e;
            }
            throw new ProcessFailedException(e, Thread.currentThread().getStackTrace()[1].getMethodName());
        }
    }

    protected static String lbValidateWork(Connection conn) throws ProcessFailedException {
        try {
            boolean isSqlCl = LiquibaseActions.getBoolenParameter("isSqlCl");
            Liquibase liquibase = LiquibaseActions.getLiquibase((DatabaseConnection)new JdbcConnection(conn), LiquibaseActions.getLbParameter("changelog"), LiquibaseActions.getContext().prependCD(""));
            liquibase.validate();
            if (isSqlCl) {
                LiquibaseActions.getContext().write(MessageFormat.format(Messages.getString("LB_FILE_VALID"), LiquibaseActions.getLbParameter("changelog")));
                return null;
            }
            return MessageFormat.format(Messages.getString("LB_FILE_VALID"), LiquibaseActions.getLbParameter("changelog"));
        }
        catch (Exception e) {
            LbExceptionHandler.handleError(e, e.getStackTrace()[1].getMethodName(), false);
            if (e instanceof ProcessFailedException) {
                throw (ProcessFailedException)e;
            }
            throw new ProcessFailedException(e, Thread.currentThread().getStackTrace()[1].getMethodName());
        }
    }

    private static ChangeLogIterator getStandardChangelogIterator(Contexts contexts, LabelExpression labelExpression, DatabaseChangeLog changeLog, Database database) throws DatabaseException {
        return new ChangeLogIterator(changeLog, new ChangeSetFilter[]{new ShouldRunChangeSetFilter(database, true), new ContextChangeSetFilter(contexts), new LabelChangeSetFilter(labelExpression), new DbmsChangeSetFilter(database), new IgnoreChangeSetFilter()});
    }

    private static void validate_action_table(Connection conn) {
        DBUtil dbUtil = DBUtil.getInstance((Connection)conn);
        String tab_exists = dbUtil.executeReturnOneCol("select count(*) from user_tables where table_name='DATABASECHANGELOG_ACTIONS'");
        if (tab_exists != null && Integer.parseInt(tab_exists) == 0) {
            LiquibaseActions.getConfig().setCreateActionTable(true);
        }
    }

    public String doRollback(Connection conn, String changelog, int count) throws ProcessFailedException {
        try {
            LiquibaseActions.setLbParameter("isSqlCl", "false");
            LiquibaseActions.setLbParameter("changelog", changelog);
            LiquibaseActions.setLbParameter("count", String.valueOf(count));
        }
        catch (PropertyNotFoundException e) {
            LbExceptionHandler.handleError(e, e.getStackTrace()[1].getMethodName(), false);
            throw new ProcessFailedException(e, Thread.currentThread().getStackTrace()[1].getMethodName());
        }
        return LiquibaseActions.doRollbackWork(conn, null);
    }

    public String doRollback(Connection conn, String changelog, String date) throws ProcessFailedException {
        try {
            LiquibaseActions.setLbParameter("isSqlCl", "false");
            LiquibaseActions.setLbParameter("changelog", changelog);
            LiquibaseActions.setLbParameter("date", date);
        }
        catch (PropertyNotFoundException e) {
            LbExceptionHandler.handleError(e, e.getStackTrace()[1].getMethodName(), false);
            throw new ProcessFailedException(e, Thread.currentThread().getStackTrace()[1].getMethodName());
        }
        return LiquibaseActions.doRollbackWork(conn, null);
    }

    public String doRollbackSql(Connection conn, String changelog, int count, StringWriter writer) throws ProcessFailedException {
        try {
            LiquibaseActions.setLbParameter("isSqlCl", "false");
            LiquibaseActions.setLbParameter("changelog", changelog);
            LiquibaseActions.setLbParameter("count", String.valueOf(count));
        }
        catch (PropertyNotFoundException e) {
            LbExceptionHandler.handleError(e, e.getStackTrace()[1].getMethodName(), false);
            throw new ProcessFailedException(e, Thread.currentThread().getStackTrace()[1].getMethodName());
        }
        return LiquibaseActions.doRollbackWork(conn, writer);
    }

    public String doRollbackSql(Connection conn, String changelog, String date, StringWriter writer) throws ProcessFailedException {
        try {
            LiquibaseActions.setLbParameter("isSqlCl", "false");
            LiquibaseActions.setLbParameter("changelog", changelog);
            LiquibaseActions.setLbParameter("date", date);
        }
        catch (PropertyNotFoundException e) {
            LbExceptionHandler.handleError(e, e.getStackTrace()[1].getMethodName(), false);
            throw new ProcessFailedException(e, Thread.currentThread().getStackTrace()[1].getMethodName());
        }
        return LiquibaseActions.doRollbackWork(conn, writer);
    }

    public String doUpdate(Connection conn, String changelog) throws ProcessFailedException {
        try {
            LiquibaseActions.setLbParameter("isSqlCl", "false");
            LiquibaseActions.setLbParameter("changelog", changelog);
        }
        catch (PropertyNotFoundException e) {
            LbExceptionHandler.handleError(e, e.getStackTrace()[1].getMethodName(), false);
            throw new ProcessFailedException(e, Thread.currentThread().getStackTrace()[1].getMethodName());
        }
        return LiquibaseActions.doUpdateWork(conn, null);
    }

    public String doUpdateSql(Connection conn, String changelog, StringWriter writer) throws ProcessFailedException {
        try {
            LiquibaseActions.setLbParameter("isSqlCl", "false");
            LiquibaseActions.setLbParameter("changelog", changelog);
        }
        catch (PropertyNotFoundException e) {
            LbExceptionHandler.handleError(e, e.getStackTrace()[1].getMethodName(), false);
            throw new ProcessFailedException(e, Thread.currentThread().getStackTrace()[1].getMethodName());
        }
        return LiquibaseActions.doUpdateWork(conn, writer);
    }

    public HashMap<String, String> genApexObjectChangelogs(Connection conn) throws ProcessFailedException {
        try {
            LiquibaseActions.setLbParameter("isSqlCl", "false");
        }
        catch (PropertyNotFoundException e) {
            LbExceptionHandler.handleError(e, e.getStackTrace()[1].getMethodName(), false);
            throw new ProcessFailedException(e, Thread.currentThread().getStackTrace()[1].getMethodName());
        }
        return LiquibaseActions.genApexObjectChangelogsWork(conn);
    }

    public String genControlFile(Connection conn, String changelog) throws ProcessFailedException {
        try {
            LiquibaseActions.setLbParameter("changelog", changelog);
            LiquibaseActions.setLbParameter("isSqlCl", "false");
        }
        catch (PropertyNotFoundException e) {
            LbExceptionHandler.handleError(e, e.getStackTrace()[1].getMethodName(), false);
            throw new ProcessFailedException(e, Thread.currentThread().getStackTrace()[1].getMethodName());
        }
        return LiquibaseActions.genControlFileWork(conn);
    }

    public String genDbDoc(Connection conn, String changelog, String dir) throws ProcessFailedException {
        try {
            LiquibaseActions.setLbParameter("changelog", changelog);
            LiquibaseActions.setLbParameter("dir", dir);
            LiquibaseActions.setLbParameter("isSqlCl", "false");
        }
        catch (PropertyNotFoundException e) {
            LbExceptionHandler.handleError(e, e.getStackTrace()[1].getMethodName(), false);
            throw new ProcessFailedException(e, Thread.currentThread().getStackTrace()[1].getMethodName());
        }
        return LiquibaseActions.genDbDocWork(conn);
    }

    public String genDbObjectChangelog(Connection conn, String name, String type) throws ProcessFailedException {
        try {
            LiquibaseActions.setLbParameter("name", name);
            LiquibaseActions.setLbParameter("type", type);
            LiquibaseActions.setLbParameter("isSqlCl", "false");
        }
        catch (PropertyNotFoundException e) {
            LbExceptionHandler.handleError(e, e.getStackTrace()[1].getMethodName(), false);
            throw new ProcessFailedException(e, Thread.currentThread().getStackTrace()[1].getMethodName());
        }
        return LiquibaseActions.genDbObjectChangelogWork(conn);
    }

    public HashMap<String, String> genDbSchema(Connection conn) throws ProcessFailedException {
        try {
            LiquibaseActions.setLbParameter("isSqlCl", "false");
        }
        catch (PropertyNotFoundException e) {
            LbExceptionHandler.handleError(e, e.getStackTrace()[1].getMethodName(), false);
            throw new ProcessFailedException(e, Thread.currentThread().getStackTrace()[1].getMethodName());
        }
        return LiquibaseActions.genDbSchemaWork(conn);
    }

    public HashMap<String, String> genDiff(Connection conn, String user, String pass, String url, String style) throws ProcessFailedException {
        try {
            LiquibaseActions.setLbParameter("user", user);
            LiquibaseActions.setLbParameter("password", pass);
            LiquibaseActions.setLbParameter("url", url);
            LiquibaseActions.setLbParameter("log", "false");
            if (style.equals("changelog")) {
                LiquibaseActions.setLbParameter("report", "false");
            } else {
                LiquibaseActions.setLbParameter("report", "true");
            }
            LiquibaseActions.setLbParameter("isSqlCl", "false");
        }
        catch (PropertyNotFoundException e) {
            LbExceptionHandler.handleError(e, e.getStackTrace()[1].getMethodName(), false);
            throw new ProcessFailedException(e, Thread.currentThread().getStackTrace()[1].getMethodName());
        }
        return LiquibaseActions.genDiffWork(conn);
    }

    public String genOrdsObjectChangelog(Connection conn, String name, String type) throws ProcessFailedException, PropertyNotFoundException {
        LiquibaseActions.setLbParameter("name", name);
        LiquibaseActions.setLbParameter("type", type);
        LiquibaseActions.setLbParameter("isSqlCl", "false");
        return LiquibaseActions.genOrdsObjectChangelogWork(conn);
    }

    public String genTableData(Connection conn) throws ProcessFailedException {
        try {
            LiquibaseActions.setLbParameter("isSqlCl", "false");
        }
        catch (PropertyNotFoundException e) {
            LbExceptionHandler.handleError(e, e.getStackTrace()[1].getMethodName(), false);
            throw new ProcessFailedException(e, Thread.currentThread().getStackTrace()[1].getMethodName());
        }
        return LiquibaseActions.genTableDataWork(conn);
    }

    public String lbChangeLogSync(Connection conn, String changelog) throws ProcessFailedException {
        try {
            LiquibaseActions.setLbParameter("changelog", changelog);
            LiquibaseActions.setLbParameter("isSqlCl", "false");
        }
        catch (PropertyNotFoundException e) {
            LbExceptionHandler.handleError(e, e.getStackTrace()[1].getMethodName(), false);
            throw new ProcessFailedException(e, Thread.currentThread().getStackTrace()[1].getMethodName());
        }
        return LiquibaseActions.lbChangeLogSyncWork(conn);
    }

    public String lbClearCheckSums(Connection conn, String changelog) throws ProcessFailedException {
        try {
            LiquibaseActions.setLbParameter("changelog", changelog);
            LiquibaseActions.setLbParameter("isSqlCl", "false");
        }
        catch (PropertyNotFoundException e) {
            LbExceptionHandler.handleError(e, e.getStackTrace()[1].getMethodName(), false);
            throw new ProcessFailedException(e, Thread.currentThread().getStackTrace()[1].getMethodName());
        }
        return LiquibaseActions.lbClearCheckSumsWork(conn);
    }

    public String lbListLocks(Connection conn, String changelog) throws ProcessFailedException {
        try {
            LiquibaseActions.setLbParameter("changelog", changelog);
            LiquibaseActions.setLbParameter("isSqlCl", "false");
        }
        catch (PropertyNotFoundException e) {
            LbExceptionHandler.handleError(e, e.getStackTrace()[1].getMethodName(), false);
            throw new ProcessFailedException(e, Thread.currentThread().getStackTrace()[1].getMethodName());
        }
        return LiquibaseActions.lbListLocksWork(conn);
    }

    public String lbReleaseLocks(Connection conn, String changelog) throws ProcessFailedException {
        try {
            LiquibaseActions.setLbParameter("changelog", changelog);
            LiquibaseActions.setLbParameter("isSqlCl", "false");
        }
        catch (PropertyNotFoundException e) {
            LbExceptionHandler.handleError(e, e.getStackTrace()[1].getMethodName(), false);
            throw new ProcessFailedException(e, Thread.currentThread().getStackTrace()[1].getMethodName());
        }
        return LiquibaseActions.lbReleaseLocksWork(conn);
    }

    public String lbStatus(Connection conn, String changelog) throws ProcessFailedException {
        try {
            LiquibaseActions.setLbParameter("changelog", changelog);
            LiquibaseActions.setLbParameter("isSqlCl", "false");
        }
        catch (PropertyNotFoundException e) {
            LbExceptionHandler.handleError(e, e.getStackTrace()[1].getMethodName(), false);
            throw new ProcessFailedException(e, Thread.currentThread().getStackTrace()[1].getMethodName());
        }
        return LiquibaseActions.lbStatusWork(conn);
    }

    public String lbValidate(Connection conn, String changelog) throws ProcessFailedException {
        try {
            LiquibaseActions.setLbParameter("changelog", changelog);
            LiquibaseActions.setLbParameter("isSqlCl", "false");
        }
        catch (PropertyNotFoundException e) {
            LbExceptionHandler.handleError(e, e.getStackTrace()[1].getMethodName(), false);
            throw new ProcessFailedException(e, Thread.currentThread().getStackTrace()[1].getMethodName());
        }
        return LiquibaseActions.lbValidateWork(conn);
    }
}

