/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.scriptrunner.commands.liquibase;

import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.FileWriter;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.HashMap;
import java.util.logging.Level;
import liquibase.configuration.SqlclConfig;
import liquibase.configuration.SqlclConfigWrapper;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.liquibase.exceptions.ProcessFailedException;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.scriptrunner.commands.liquibase.LiquibaseActions;

public class LiquibaseActionTest {
    private static void modifyDDL(DBUtil dbUtil, String state, String option) throws ProcessFailedException {
        String optionSQL = "";
        optionSQL = state.toLowerCase().equals("on") ? "begin dbms_metadata.set_transform_param(dbms_metadata.session_transform,:OPTION,true); end;" : "begin dbms_metadata.set_transform_param(dbms_metadata.session_transform,:OPTION,false); end;";
        HashMap<String, String> binds = new HashMap<String, String>();
        binds.put("OPTION", option);
        try {
            dbUtil.execute(optionSQL, binds);
        }
        catch (Exception e) {
            if (e instanceof ProcessFailedException) {
                throw (ProcessFailedException)e;
            }
            throw new ProcessFailedException(e, Thread.currentThread().getStackTrace()[1].getMethodName());
        }
    }

    public static void main(String[] argv) {
        try {
            Class.forName("oracle.jdbc.driver.OracleDriver");
        }
        catch (ClassNotFoundException e) {
            System.out.println("Where is your Oracle JDBC Driver?");
            e.printStackTrace();
            return;
        }
        String dbURL = "jdbc:oracle:thin:@denab215:2213/DB213P";
        Connection hrConn = null;
        Connection hr2Conn = null;
        ScriptRunnerContext ctx = null;
        try {
            hrConn = DriverManager.getConnection("jdbc:oracle:thin:@denab215:2213/DB213P", "hr", "oracle");
            hr2Conn = DriverManager.getConnection("jdbc:oracle:thin:@denab215:2213/DB213P", "hr2", "oracle");
            DBUtil dbUtil = DBUtil.getInstance((Connection)hrConn);
            LiquibaseActionTest.modifyDDL(dbUtil, "off", "STORAGE");
            LiquibaseActionTest.modifyDDL(dbUtil, "off", "TABLESPACE");
            LiquibaseActionTest.modifyDDL(dbUtil, "off", "SEGMENT_ATTRIBUTES");
            LiquibaseActions lba = new LiquibaseActions();
            ctx = LiquibaseActions.getContext();
            LiquibaseActions.setLbParameter("fail", "true");
            LiquibaseActions.setLbParameter("debug", "true");
            LiquibaseActions.setContext(ctx);
            LiquibaseActions.setLogLevel(Level.OFF);
            ByteArrayOutputStream BaS = new ByteArrayOutputStream();
            BufferedOutputStream BoS = new BufferedOutputStream(BaS);
            ctx.putProperty("script.runner.using.systemout", (Object)Boolean.TRUE);
            ctx.set_autoprint(-6);
            ctx.setOutputStreamWrapper(BoS);
            StringWriter stringWriter = new StringWriter();
            System.out.println("############################# GENSCHEMA ############################");
            HashMap<String, String> HashResult = lba.genDbSchema(hrConn);
            HashResult.forEach((key, value) -> System.out.println(key + " = " + value));
            System.out.println("#####ScreenOutput###################################################");
            System.out.println(HashResult.get(((SqlclConfig)SqlclConfigWrapper.SQLCL_CONFIG.getCurrentValue()).getScreenFileName()));
            System.out.println("#                                                                  #");
            System.out.println("#                                                                  #");
            System.out.println("######################## END GENSCHEMA #############################");
            System.out.println("#                                                                  #");
            System.out.println("#                                                                  #");
            System.out.println("############################ GENOBJECT #############################");
            String StringResult = lba.genDbObjectChangelog(hrConn, "jobs", "table");
            System.out.println(StringResult);
            BufferedWriter writer = new BufferedWriter(new FileWriter("jobs_table.xml"));
            writer.write(StringResult);
            writer.close();
            System.out.println("######################### END GENOBJECT ############################");
            System.out.println("#                                                                  #");
            System.out.println("#                                                                  #");
            System.out.println("############################# UPDATESQL ############################");
            String ScreenOutput = lba.doUpdateSql(hr2Conn, "jobs_table.xml", stringWriter);
            System.out.println(ScreenOutput);
            System.out.println("######################### END UPDATESQL ############################");
            System.out.println("#                                                                  #");
            System.out.println("#                                                                  #");
            System.out.println("################################ UPDATE ############################");
            ScreenOutput = lba.doUpdate(hr2Conn, "jobs_table.xml");
            System.out.println(ScreenOutput);
            System.out.println("############################ END UPDATE ############################");
            System.out.println("#                                                                  #");
            System.out.println("#                                                                  #");
            System.out.println("########################## ROLLBACK SQL ############################");
            ScreenOutput = lba.doRollbackSql(hr2Conn, "jobs_table.xml", 1, stringWriter);
            System.out.println(ScreenOutput);
            System.out.println("###################### END ROLLBACK SQL ############################");
            System.out.println("#                                                                  #");
            System.out.println("#                                                                  #");
            System.out.println("########### ########### ROLLBACK OBJECT ############################");
            ScreenOutput = lba.doRollback(hr2Conn, "jobs_table.xml", 1);
            System.out.println(ScreenOutput);
            System.out.println("################### END ROLLBACK OBJECT ############################");
            System.out.println("#                                                                  #");
            System.out.println("#                                                                  #");
            System.out.println("############################# DATA ########%########################");
            StringResult = lba.genTableData(hrConn);
            System.out.println(StringResult);
            System.out.println("############################# END DATA #############################");
            System.out.println("#                                                                  #");
            System.out.println("#                                                                  #");
            System.out.println("############################# gencontrolfile #######################");
            StringResult = lba.genControlFile(hrConn, "jobs_table.xml");
            System.out.println(StringResult);
            System.out.println("############################# END gencontrolfile ###################");
            System.out.println("#                                                                  #");
            System.out.println("#                                                                  #");
            System.out.println("############################# genDbDoc #############################");
            ScreenOutput = lba.genDbDoc(hrConn, "jobs_table.xml", "./doc");
            System.out.println(ScreenOutput);
            System.out.println("############################# END genDbDoc #########################");
            System.out.println("#                                                                  #");
            System.out.println("#                                                                  #");
            System.out.println("############################# lbChangeLogSync ######################");
            ScreenOutput = lba.lbChangeLogSync(hrConn, "jobs_table.xml");
            System.out.println(ScreenOutput);
            System.out.println("############################# END lbChangeLogSync ##################");
            System.out.println("#                                                                  #");
            System.out.println("#                                                                  #");
            System.out.println("############################# lbClearCheckSums #####################");
            ScreenOutput = lba.lbClearCheckSums(hrConn, "jobs_table.xml");
            System.out.println(ScreenOutput);
            System.out.println("############################# END lbClearCheckSums #################");
            System.out.println("#                                                                  #");
            System.out.println("#                                                                  #");
            System.out.println("############################# lbListLocks ##########################");
            ScreenOutput = lba.lbListLocks(hrConn, "jobs_table.xml");
            System.out.println(ScreenOutput);
            System.out.println("############################# END lbListLocks ######################");
            System.out.println("#                                                                  #");
            System.out.println("#                                                                  #");
            System.out.println("############################# lbReleaseLocks #####$#################");
            ScreenOutput = lba.lbReleaseLocks(hrConn, "jobs_table.xml");
            System.out.println(ScreenOutput);
            System.out.println("############################# END lbReleaseLocks ###################");
            System.out.println("#                                                                  #");
            System.out.println("#                                                                  #");
            System.out.println("############################# lbStatus #############################");
            ScreenOutput = lba.lbStatus(hrConn, "jobs_table.xml");
            System.out.println(ScreenOutput);
            System.out.println("############################# END lbStatus #########################");
            System.out.println("#                                                                  #");
            System.out.println("#                                                                  #");
            System.out.println("############################# lbValidate ###########################");
            ScreenOutput = lba.lbValidate(hrConn, "jobs_table.xml");
            System.out.println(ScreenOutput);
            System.out.println("############################# END lbValidate #######################");
            System.out.println("#                                                                  #");
            System.out.println("#                                                                  #");
            System.out.println("############################# lbVersion ############################");
            ScreenOutput = LiquibaseActions.getLbVersion();
            System.out.println(ScreenOutput);
            System.out.println("############################# END lbVersion ########################");
        }
        catch (Exception e) {
            return;
        }
    }
}

