/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.liquibase.utils;

import java.io.BufferedOutputStream;
import java.sql.Connection;
import liquibase.database.Database;
import liquibase.database.jvm.JdbcConnection;
import liquibase.ext.ora.oraclestatement.AbstractOracleStatement;
import liquibase.ext.ora.runoraclescript.RunOracleScriptStatement;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.structure.DatabaseObject;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.liquibase.exceptions.CustomSqlException;
import oracle.dbtools.raptor.liquibase.exceptions.ProcessFailedException;
import oracle.dbtools.raptor.liquibase.generator.SchemaGenerator;
import oracle.dbtools.raptor.liquibase.utils.DbmsMetaUtils;
import oracle.dbtools.raptor.liquibase.utils.LbExceptionHandler;
import oracle.dbtools.raptor.liquibase.utils.LbStringUtils;
import oracle.dbtools.raptor.liquibase.utils.NullOutputStream;
import oracle.dbtools.raptor.liquibase.utils.QueryUtils;
import oracle.dbtools.raptor.newscriptrunner.ScriptExecutor;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.scriptrunner.commands.liquibase.LiquibaseActions;
import oracle.dbtools.util.Service;

public class LbMetaUtils {
    public static void createCaptureObjects(Connection conn) throws ProcessFailedException {
        try {
            if (!LbMetaUtils.doesCaptureTableExist(conn)) {
                LbMetaUtils.createCaptureTable(conn);
            } else {
                LbMetaUtils.dropCaptureTable(conn);
                LbMetaUtils.createCaptureTable(conn);
            }
            if (!LbMetaUtils.doesCapturePackageExist(conn)) {
                LbMetaUtils.createCapturePackage(conn);
            }
        }
        catch (Exception e) {
            LbExceptionHandler.handleError(e, e.getStackTrace()[1].getMethodName(), true);
            throw new ProcessFailedException(e, Thread.currentThread().getStackTrace()[1].getMethodName());
        }
    }

    public static void createCapturePackage(Connection conn) throws CustomSqlException {
        ScriptExecutor m_executor = new ScriptExecutor(conn);
        String createOrderRowProc = QueryUtils.getXMLQueries().getQuery("createCapturePackage", conn).getSql();
        m_executor.setStmt(createOrderRowProc);
        m_executor.setOut(new BufferedOutputStream(new NullOutputStream()));
        m_executor.run();
        ScriptRunnerContext m_scriptRunnerContext = m_executor.getScriptRunnerContext();
        Boolean hasErrors = (Boolean)m_scriptRunnerContext.getProperties().get("sqldev.error");
        String error = (String)m_scriptRunnerContext.getProperties().get("sqldev.last.err.message.forsqlcode");
        if (hasErrors.booleanValue()) {
            throw new CustomSqlException(error);
        }
    }

    public static void createCaptureTable(Connection conn) throws CustomSqlException {
        ScriptExecutor m_executor = new ScriptExecutor(conn);
        String createCaptureTable = QueryUtils.getXMLQueries().getQuery("createCaptureTable", conn).getSql();
        m_executor.setStmt(createCaptureTable);
        m_executor.setOut(new BufferedOutputStream(new NullOutputStream()));
        m_executor.run();
        ScriptRunnerContext m_scriptRunnerContext = m_executor.getScriptRunnerContext();
        Boolean hasErrors = (Boolean)m_scriptRunnerContext.getProperties().get("sqldev.error");
        String error = (String)m_scriptRunnerContext.getProperties().get("sqldev.last.err.message.forsqlcode");
        if (hasErrors.booleanValue()) {
            throw new CustomSqlException(error);
        }
    }

    public static boolean doesCapturePackageExist(Connection conn) {
        DBUtil dbUtil = DBUtil.getInstance((Connection)conn);
        String count = dbUtil.executeReturnOneCol(QueryUtils.getXMLQueries().getQuery("checkLbPackage", conn).getSql());
        return Integer.parseInt(count) != 0;
    }

    public static boolean doesCaptureTableExist(Connection conn) {
        DBUtil dbUtil = DBUtil.getInstance((Connection)conn);
        String count = dbUtil.executeReturnOneCol(QueryUtils.getXMLQueries().getQuery("checkLbtable", conn).getSql());
        return Integer.parseInt(count) != 0;
    }

    public static void dropCaptureObjects(Connection conn) throws ProcessFailedException {
        try {
            LbMetaUtils.dropCapturePackage(conn);
        }
        catch (CustomSqlException customSqlException) {
            // empty catch block
        }
        try {
            LbMetaUtils.dropCaptureTable(conn);
        }
        catch (CustomSqlException customSqlException) {
            // empty catch block
        }
    }

    public static void dropCapturePackage(Connection conn) throws CustomSqlException {
        ScriptExecutor m_executor = new ScriptExecutor(conn);
        String dropCapturePackage = QueryUtils.getXMLQueries().getQuery("dropCapturePackage", conn).getSql();
        m_executor.setStmt(dropCapturePackage);
        m_executor.setOut(new BufferedOutputStream(new NullOutputStream()));
        m_executor.run();
        ScriptRunnerContext m_scriptRunnerContext = m_executor.getScriptRunnerContext();
        Boolean hasErrors = (Boolean)m_scriptRunnerContext.getProperties().get("sqldev.error");
        String error = (String)m_scriptRunnerContext.getProperties().get("sqldev.last.err.message.forsqlcode");
        if (hasErrors.booleanValue()) {
            throw new CustomSqlException(error);
        }
    }

    public static void dropCaptureTable(Connection conn) throws CustomSqlException {
        ScriptExecutor m_executor = new ScriptExecutor(conn);
        String dropCaptureTable = QueryUtils.getXMLQueries().getQuery("dropCaptureTable", conn).getSql();
        m_executor.setStmt(dropCaptureTable);
        m_executor.setOut(new BufferedOutputStream(new NullOutputStream()));
        m_executor.run();
        ScriptRunnerContext m_scriptRunnerContext = m_executor.getScriptRunnerContext();
        Boolean hasErrors = (Boolean)m_scriptRunnerContext.getProperties().get("sqldev.error");
        String error = (String)m_scriptRunnerContext.getProperties().get("sqldev.last.err.message.forsqlcode");
        if (hasErrors.booleanValue()) {
            throw new CustomSqlException(error);
        }
    }

    public static Sql[] getCreateSqlPlSql(AbstractOracleStatement statement, Database database) {
        String outSql = null;
        StringBuilder sql = new StringBuilder();
        if (!(statement.getObjectType().equals("GRANT") || statement.getObjectType().equals("JOB") || statement.getSource().toUpperCase().substring(0, 15).contains("CREATE") || statement.getSource().toUpperCase().substring(0, 15).contains("ALTER"))) {
            sql.append("CREATE ");
            if (statement.getReplaceIfExists() != null && statement.getReplaceIfExists().booleanValue()) {
                sql.append("OR REPLACE ");
            }
        }
        sql.append(statement.getSource());
        sql.toString().replace("%USER_NAME%", database.getDefaultSchemaName());
        if (!Boolean.parseBoolean(statement.getEmitSchema())) {
            outSql = sql.toString().replaceAll("\"" + statement.getOwnerName() + "\".", "");
            outSql = outSql.replaceAll("\"" + database.getDefaultCatalogName() + "\".", "");
        } else {
            outSql = sql.toString();
        }
        outSql = outSql.replaceAll("/ALTER", "/\nALTER");
        if (outSql != null && !outSql.trim().equals("")) {
            return new Sql[]{new UnparsedSql(outSql, new DatabaseObject[0])};
        }
        return new Sql[]{new UnparsedSql("-- object is the same nothing to do", new DatabaseObject[0])};
    }

    public static Sql[] getCreateSqlSxml(AbstractOracleStatement stmt, Database database) {
        try {
            Connection conn = ((JdbcConnection)database.getConnection()).getUnderlyingConnection();
            String sql = null;
            String oName = stmt.getObjectName();
            String oType = stmt.getObjectType();
            String destXml = stmt.getSource();
            String schema = stmt.getOwnerName();
            if (schema == null) {
                schema = stmt.getOwnerName();
            }
            if (stmt.getFile() == null) {
                stmt.setObjectOwner(database.getDefaultSchemaName());
                stmt.setSource(stmt.getSource().replaceAll("%USER_NAME%", database.getDefaultSchemaName()));
                destXml = destXml.replaceAll("%USER_NAME%", database.getDefaultSchemaName());
            }
            if (!oType.equalsIgnoreCase("VIEW") && QueryUtils.doesObjectExist(conn, oName, oType)) {
                String sourceXml = DbmsMetaUtils.getObjectFromDb(conn, stmt.getObjectType(), stmt.getObjectName());
                sql = DbmsMetaUtils.getAlterDdl(conn, sourceXml, destXml, stmt.getObjectType());
            } else {
                sql = DbmsMetaUtils.getDdlFromSxml(conn, destXml, stmt.getObjectType());
                sql.replaceAll(",\\s+\\);", ");\n");
            }
            if (sql == null) {
                sql = "";
            }
            if (LiquibaseActions.getBoolenParameter("emit_schema")) {
                sql = sql.replaceAll("\"" + schema + "\".", "\"" + database.getDefaultCatalogName() + "\".");
            } else {
                sql = sql.replaceAll("\"" + schema + "\".", "");
                sql = sql.replaceAll("\"" + database.getDefaultCatalogName() + "\".", "");
            }
            if (sql.trim().equalsIgnoreCase("")) {
                sql = "-- object is the same nothing to do";
            }
            if (sql.endsWith(";;")) {
                sql = sql.replace(";;", ";");
            }
            return new Sql[]{new UnparsedSql(sql.trim(), new DatabaseObject[0])};
        }
        catch (Exception e) {
            LbExceptionHandler.handleError(e, e.getStackTrace()[1].getMethodName(), true);
            return null;
        }
    }

    public static Sql[] getDropSqlPlSql(AbstractOracleStatement statement, Database database) throws ProcessFailedException {
        String outSql = null;
        String oName = null;
        Connection conn = ((JdbcConnection)database.getConnection()).getUnderlyingConnection();
        StringBuilder sql = new StringBuilder();
        String action = null;
        if (statement instanceof RunOracleScriptStatement) {
            return null;
        }
        try {
            if (statement.getObjectName() != null && !statement.getObjectName().equals("%OBJECT_NAME%")) {
                oName = Service.handleMixedCase((String)statement.getObjectName());
            }
            try {
                action = QueryUtils.getXmlFromActionsLog(conn, statement);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (action == null || action.equalsIgnoreCase("")) {
                if (statement.getObjectType() != null && statement.getObjectType().contentEquals("JOB")) {
                    String subType = QueryUtils.getSchedulerObjectType(oName, database);
                    if (subType != null) {
                        return new Sql[]{new UnparsedSql("BEGIN DBMS_SCHEDULER.drop_" + subType.toLowerCase() + " (" + subType.toLowerCase() + "_name => '" + oName + "' ,FORCE=>TRUE); end;", new DatabaseObject[0])};
                    }
                    return null;
                }
                if (oName != null && !oName.equals("%OBJECT_NAME%")) {
                    sql.append("DROP ");
                    if (SchemaGenerator.typeChanges.containsKey(statement.getObjectType())) {
                        sql.append(SchemaGenerator.typeChanges.get(statement.getObjectType()) + " ");
                    } else {
                        sql.append(statement.getObjectType() + " ");
                    }
                    sql.append("\"" + oName + "\"");
                } else if (statement.getObjectType().equalsIgnoreCase("GRANT")) {
                    String dropsql = statement.getSource();
                    dropsql = dropsql.replaceAll("GRANT", "REVOKE");
                    dropsql = dropsql.replaceAll("TO", "FROM");
                    sql.append(dropsql);
                } else if (statement.getObjectType().equalsIgnoreCase("MATERIALIZED_VIEW_LOG")) {
                    String dropsql = statement.getSource();
                    dropsql = dropsql.replaceAll("CREATE", "DROP");
                }
                if (statement.getObjectType() != null && statement.getObjectType().equalsIgnoreCase("JOB")) {
                    return null;
                }
            }
            if (statement.getObjectType().equalsIgnoreCase("TABLE")) {
                sql.append(" CASCADE CONSTRAINTS");
            }
            if (!Boolean.parseBoolean(statement.getEmitSchema())) {
                outSql = sql.toString().replaceAll("\"" + statement.getOwnerName() + "\".", "");
                outSql = outSql.replaceAll("\"" + database.getDefaultCatalogName() + "\".", "");
            } else {
                outSql = sql.toString();
            }
            return new Sql[]{new UnparsedSql(outSql, new DatabaseObject[0])};
        }
        catch (Exception e) {
            LbExceptionHandler.handleError(e, e.getStackTrace()[1].getMethodName(), true);
            if (e instanceof ProcessFailedException) {
                throw (ProcessFailedException)e;
            }
            throw new ProcessFailedException(e, Thread.currentThread().getStackTrace()[1].getMethodName());
        }
    }

    public static Sql[] getDropSqlSxml(AbstractOracleStatement statement, Database database) throws ProcessFailedException {
        String sourceXml = null;
        Connection conn = ((JdbcConnection)database.getConnection()).getUnderlyingConnection();
        StringBuilder sql = new StringBuilder();
        try {
            String oType = statement.getObjectType();
            String destXml = statement.getSource();
            sourceXml = QueryUtils.getXmlFromActionsLog(conn, statement);
            if (sourceXml != null) {
                sql.append(DbmsMetaUtils.getAlterDdl(conn, sourceXml, destXml, statement.getObjectType()));
            } else if (oType.equals("MATERIALIZED_VIEW_LOG")) {
                String create = DbmsMetaUtils.getDdlFromSxml(conn, destXml, statement.getObjectType());
                String drop = create.replace("CREATE", "DROP");
                int loc = LbStringUtils.nthOccurrence(drop, '\"', 4);
                drop = drop.substring(0, loc + 1);
                sql.append(drop);
            } else {
                sql.append("DROP ");
                if (SchemaGenerator.typeChanges.containsKey(statement.getObjectType())) {
                    sql.append(SchemaGenerator.typeChanges.get(statement.getObjectType()) + " ");
                } else {
                    sql.append(statement.getObjectType() + " ");
                }
                if (LiquibaseActions.getBoolenParameter("emit_schema")) {
                    sql.append("\"" + database.getDefaultCatalogName() + "\".");
                }
                sql.append("\"" + statement.getObjectName() + "\"");
                if (statement.getObjectType().equals("TABLE")) {
                    sql.append(" CASCADE CONSTRAINTS");
                }
            }
            return new Sql[]{new UnparsedSql(sql.toString(), new DatabaseObject[0])};
        }
        catch (Exception e) {
            LbExceptionHandler.handleError(e, e.getStackTrace()[1].getMethodName(), true);
            if (e instanceof ProcessFailedException) {
                throw (ProcessFailedException)e;
            }
            throw new ProcessFailedException(e, Thread.currentThread().getStackTrace()[1].getMethodName());
        }
    }
}

