/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.liquibase.utils;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import oracle.dbtools.common.utils.FileUtils;
import oracle.dbtools.raptor.liquibase.exceptions.ProcessFailedException;
import oracle.dbtools.raptor.liquibase.utils.LbExceptionHandler;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;

public class LbFileUtils {
    public static String writeFile(ScriptRunnerContext ctx, String fileName, String data) throws ProcessFailedException {
        try {
            String cwd = FileUtils.getCWD((ScriptRunnerContext)ctx);
            Path path = Paths.get(cwd + "/" + fileName, new String[0]);
            int i = 1;
            String newFile = null;
            while (Files.exists(path, new LinkOption[0])) {
                newFile = fileName.replace(".", i + ".");
                ++i;
                path = Paths.get(cwd + "/" + newFile, new String[0]);
            }
            BufferedWriter writer = new BufferedWriter(new FileWriter(path.toFile()));
            writer.write(data);
            writer.close();
            return path.getFileName().toString();
        }
        catch (Exception e) {
            LbExceptionHandler.handleError(e, e.getStackTrace()[1].getMethodName(), true);
            if (e instanceof ProcessFailedException) {
                throw (ProcessFailedException)e;
            }
            throw new ProcessFailedException(e, Thread.currentThread().getStackTrace()[1].getMethodName());
        }
    }
}

