/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.liquibase.utils;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import liquibase.configuration.SqlclConfig;
import liquibase.configuration.SqlclConfigWrapper;
import oracle.dbtools.raptor.liquibase.exceptions.ProcessFailedException;
import oracle.dbtools.raptor.scriptrunner.commands.liquibase.LiquibaseActions;

public class LbExceptionHandler {
    public static void handleError(Exception e) {
        LbExceptionHandler.handleError(e, "Exception", false);
    }

    public static void handleError(Exception e, String message) {
        LbExceptionHandler.handleError(e, message, false);
    }

    public static void handleError(Exception except, String message, boolean addError) {
        if (message == null) {
            throw new IllegalArgumentException("Messaqe can not be null");
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        if (LiquibaseActions.getBoolenParameter("debug")) {
            LiquibaseActions.getContext().write("--------------------------------------------------------------------------------\n");
            LiquibaseActions.getContext().write("Oracle Liquibase Exception Handler additional information available using -debug\n");
            LiquibaseActions.getContext().write("--------------------------------------------------------------------------------\n");
        }
        Exception e = except;
        try {
            if (LiquibaseActions.getBoolenParameter("debug")) {
                if (except instanceof ProcessFailedException) {
                    e = ((ProcessFailedException)except).getOriginalException();
                }
                LiquibaseActions.getContext().write(message + "\n");
                LiquibaseActions.getContext().write("--------------------------------------------------------------------------------\n");
                if (e != null) {
                    e.printStackTrace(pw);
                    pw.close();
                    try {
                        sw.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    LiquibaseActions.getContext().write(sw.toString() + "\n");
                    LiquibaseActions.getContext().write("--------------------------------------------------------------------------------\n");
                } else {
                    LiquibaseActions.getContext().write("No Exception was passed in LbExceptionHandler.handleError()\n");
                    LiquibaseActions.getContext().write("--------------------------------------------------------------------------------\n");
                }
            }
            if (addError) {
                if (LiquibaseActions.getBoolenParameter("debug")) {
                    LiquibaseActions.getContext().write("Error added\n");
                    LiquibaseActions.getContext().write("--------------------------------------------------------------------------------\n");
                    LiquibaseActions.getContext().write("END Exception Handler\n");
                    LiquibaseActions.getContext().write("--------------------------------------------------------------------------------\n");
                }
                ((SqlclConfig)SqlclConfigWrapper.SQLCL_CONFIG.getCurrentValue()).addError(message + "\n" + e.getMessage());
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }
}

