/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.ora.runoraclescript;

import java.text.MessageFormat;
import liquibase.change.Change;
import liquibase.change.DatabaseChange;
import liquibase.database.Database;
import liquibase.ext.ora.abstractplsqlobject.AbstractCommonPlSqlChange;
import liquibase.ext.ora.runoraclescript.RunOracleScriptStatement;
import liquibase.statement.SqlStatement;

@DatabaseChange(name="runOracleScript", description="Run Oracle Script", priority=1)
public class RunOracleScriptChange
extends AbstractCommonPlSqlChange {
    public RunOracleScriptChange() {
        this.setObjectType("SCRIPT");
    }

    public String getConfirmationMessage() {
        return MessageFormat.format("Script executed successfully", this.getObjectName());
    }

    public SqlStatement[] generateStatements(Database database) {
        RunOracleScriptStatement stmt = new RunOracleScriptStatement();
        stmt.setObjectName(this.getObjectName());
        stmt.setObjectOwner(this.getOwnerName());
        stmt.setSourceType(this.getSourceType());
        stmt.setReplaceIfExists(this.getReplaceIfExists());
        stmt.setSource(this.getSource());
        if (this.getChangeSet() != null) {
            stmt.setId(this.getChangeSet().getId());
            stmt.setFile(this.getChangeSet().getFilePath());
            stmt.setAuthor(this.getChangeSet().getAuthor());
        }
        return new SqlStatement[]{stmt};
    }

    protected Change[] createInverses() {
        return null;
    }
}

