/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.ora.droporacleynonym;

import java.text.MessageFormat;
import liquibase.change.Change;
import liquibase.change.DatabaseChange;
import liquibase.database.Database;
import liquibase.ext.ora.abstractplsqlobject.AbstractCommonPlSqlChange;
import liquibase.ext.ora.droporacleynonym.DropSynonymStatement;
import liquibase.statement.SqlStatement;

@DatabaseChange(name="dropOracleSynonym", description="Drop oracle synonym", priority=1)
public class DropSynonymChange
extends AbstractCommonPlSqlChange {
    public DropSynonymChange() {
        this.setObjectType("SYNONYM");
    }

    public String getConfirmationMessage() {
        return MessageFormat.format("Synonym {0} dropped", this.getObjectName());
    }

    public SqlStatement[] generateStatements(Database database) {
        DropSynonymStatement statement = new DropSynonymStatement();
        statement.setObjectName(this.getObjectName());
        statement.setObjectOwner(this.getOwnerName());
        statement.setSource(this.getSource());
        if (this.getChangeSet() != null) {
            statement.setId(this.getChangeSet().getId());
            statement.setFile(this.getChangeSet().getFilePath());
            statement.setAuthor(this.getChangeSet().getAuthor());
        }
        return new SqlStatement[]{statement};
    }

    public boolean supportsRollback(Database database) {
        return false;
    }

    protected Change[] createInverses() {
        return null;
    }
}

