/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.ora.droporacletrigger;

import java.text.MessageFormat;
import liquibase.change.Change;
import liquibase.change.DatabaseChange;
import liquibase.database.Database;
import liquibase.ext.ora.abstractplsqlobject.AbstractCommonPlSqlChange;
import liquibase.ext.ora.droporacletrigger.DropTriggerStatement;
import liquibase.statement.SqlStatement;

@DatabaseChange(name="dropOracleTrigger", description="Drop oracle trigger", priority=1)
public class DropTriggerChange
extends AbstractCommonPlSqlChange {
    public DropTriggerChange() {
        this.setObjectType("TRIGGER");
    }

    public String getConfirmationMessage() {
        return MessageFormat.format("Trigger {0} dropped", this.getObjectName());
    }

    public SqlStatement[] generateStatements(Database database) {
        DropTriggerStatement statement = new DropTriggerStatement();
        statement.setObjectName(this.getObjectName());
        statement.setObjectOwner(this.getOwnerName());
        statement.setSource(this.getSource());
        if (this.getChangeSet() != null) {
            statement.setId(this.getChangeSet().getId());
            statement.setFile(this.getChangeSet().getFilePath());
            statement.setAuthor(this.getChangeSet().getAuthor());
        }
        return new SqlStatement[]{statement};
    }

    public boolean supportsRollback(Database database) {
        return false;
    }

    protected Change[] createInverses() {
        return null;
    }
}

