/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.ora.droporaclerefconstraint;

import java.text.MessageFormat;
import liquibase.change.Change;
import liquibase.change.DatabaseChange;
import liquibase.database.Database;
import liquibase.ext.ora.abstractplsqlobject.AbstractCommonPlSqlChange;
import liquibase.ext.ora.droporaclerefconstraint.DropRefConstraintStatement;
import liquibase.statement.SqlStatement;

@DatabaseChange(name="dropOracleRefConstraint", description="Drop oracle Ref Constraint", priority=1)
public class DropRefConstraintChange
extends AbstractCommonPlSqlChange {
    public DropRefConstraintChange() {
        this.setObjectType("REFCONSTRAINT");
    }

    public String getConfirmationMessage() {
        return MessageFormat.format("Ref Constraint {0} dropped", this.getObjectName());
    }

    public boolean supportsRollback(Database database) {
        return false;
    }

    public SqlStatement[] generateStatements(Database database) {
        DropRefConstraintStatement statement = new DropRefConstraintStatement();
        statement.setObjectName(this.getObjectName());
        statement.setObjectOwner(this.getOwnerName());
        statement.setSource(this.getSource());
        if (this.getChangeSet() != null) {
            statement.setId(this.getChangeSet().getId());
            statement.setFile(this.getChangeSet().getFilePath());
            statement.setAuthor(this.getChangeSet().getAuthor());
        }
        return new SqlStatement[]{statement};
    }

    protected Change[] createInverses() {
        return null;
    }
}

