/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.ora.droporaclegrant;

import java.text.MessageFormat;
import liquibase.change.Change;
import liquibase.change.DatabaseChange;
import liquibase.database.Database;
import liquibase.ext.ora.abstractplsqlobject.AbstractCommonPlSqlChange;
import liquibase.ext.ora.droporaclegrant.DropGrantStatement;
import liquibase.statement.SqlStatement;

@DatabaseChange(name="dropOracleGrant", description="Drop oracle grant", priority=1)
public class DropGrantChange
extends AbstractCommonPlSqlChange {
    public DropGrantChange() {
        this.setObjectType("GRANT");
    }

    public String getConfirmationMessage() {
        return MessageFormat.format("Grant {0} dropped", this.getObjectName());
    }

    public SqlStatement[] generateStatements(Database database) {
        DropGrantStatement statement = new DropGrantStatement();
        statement.setObjectName(this.getObjectName());
        statement.setObjectOwner(this.getOwnerName());
        statement.setSource(this.getSource());
        if (this.getChangeSet() != null) {
            statement.setId(this.getChangeSet().getId());
            statement.setFile(this.getChangeSet().getFilePath());
            statement.setAuthor(this.getChangeSet().getAuthor());
        }
        return new SqlStatement[]{statement};
    }

    public boolean supportsRollback(Database database) {
        return false;
    }

    protected Change[] createInverses() {
        return null;
    }
}

