/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.ora.droporaclefunction;

import java.text.MessageFormat;
import liquibase.change.Change;
import liquibase.change.DatabaseChange;
import liquibase.database.Database;
import liquibase.ext.ora.abstractplsqlobject.AbstractCommonPlSqlChange;
import liquibase.ext.ora.droporaclefunction.DropFunctionStatement;
import liquibase.statement.SqlStatement;

@DatabaseChange(name="dropOracleFunction", description="Drop oracle function", priority=1)
public class DropFunctionChange
extends AbstractCommonPlSqlChange {
    public DropFunctionChange() {
        this.setObjectType("FUNCTION");
    }

    public String getConfirmationMessage() {
        return MessageFormat.format("Function {0} dropped", this.getObjectName());
    }

    public SqlStatement[] generateStatements(Database database) {
        DropFunctionStatement statement = new DropFunctionStatement();
        statement.setObjectName(this.getObjectName());
        statement.setObjectOwner(this.getOwnerName());
        statement.setSource(this.getSource());
        if (this.getChangeSet() != null) {
            statement.setId(this.getChangeSet().getId());
            statement.setFile(this.getChangeSet().getFilePath());
            statement.setAuthor(this.getChangeSet().getAuthor());
        }
        return new SqlStatement[]{statement};
    }

    public boolean supportsRollback(Database database) {
        return false;
    }

    protected Change[] createInverses() {
        return null;
    }
}

