/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.ora.createoracletypebody;

import java.text.MessageFormat;
import liquibase.change.Change;
import liquibase.change.DatabaseChange;
import liquibase.database.Database;
import liquibase.ext.ora.abstractplsqlobject.AbstractCommonPlSqlChange;
import liquibase.ext.ora.createoracletypebody.CreateTypeBodyStatement;
import liquibase.ext.ora.droporacletypebody.DropTypeBodyChange;
import liquibase.statement.SqlStatement;

@DatabaseChange(name="createOracleTypeBody", description="Create oracle Type Body", priority=1)
public class CreateTypeBodyChange
extends AbstractCommonPlSqlChange {
    public CreateTypeBodyChange() {
        this.setObjectType("TYPE_BODY");
    }

    public String getConfirmationMessage() {
        return MessageFormat.format("Type Body {0} created", this.getObjectName());
    }

    public SqlStatement[] generateStatements(Database database) {
        CreateTypeBodyStatement stmt = new CreateTypeBodyStatement();
        stmt.setObjectName(this.getObjectName());
        stmt.setObjectOwner(this.getOwnerName());
        stmt.setReplaceIfExists(true);
        stmt.setSource(this.getSource());
        if (this.getChangeSet() != null) {
            stmt.setId(this.getChangeSet().getId());
            stmt.setFile(this.getChangeSet().getFilePath());
            stmt.setAuthor(this.getChangeSet().getAuthor());
        }
        return new SqlStatement[]{stmt};
    }

    protected Change[] createInverses() {
        DropTypeBodyChange inverse = new DropTypeBodyChange();
        inverse.setObjectName(this.getObjectName());
        inverse.setOwnerName(this.getOwnerName());
        inverse.setSource(this.getSource());
        if (this.getChangeSet() != null) {
            inverse.setId(this.getChangeSet().getId());
            inverse.setFile(this.getChangeSet().getFilePath());
            inverse.setAuthor(this.getChangeSet().getAuthor());
        }
        return new Change[]{inverse};
    }
}

