/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.ora.createoraclerefconstraint;

import java.text.MessageFormat;
import liquibase.change.Change;
import liquibase.change.DatabaseChange;
import liquibase.database.Database;
import liquibase.ext.ora.abstractplsqlobject.AbstractCommonPlSqlChange;
import liquibase.ext.ora.createoraclerefconstraint.CreateRefConstraintStatement;
import liquibase.statement.SqlStatement;

@DatabaseChange(name="createOracleRefConstraint", description="Create oracle Ref Constraint", priority=1)
public class CreateRefConstraintChange
extends AbstractCommonPlSqlChange {
    public CreateRefConstraintChange() {
        this.setObjectType("REFCONSTRAINT");
    }

    public String getConfirmationMessage() {
        return MessageFormat.format("Ref Constraint {0} created", this.getObjectName());
    }

    public SqlStatement[] generateStatements(Database database) {
        CreateRefConstraintStatement stmt = new CreateRefConstraintStatement();
        stmt.setObjectName(this.getObjectName());
        stmt.setObjectOwner(this.getOwnerName());
        stmt.setReplaceIfExists(true);
        stmt.setSource(this.getSource());
        if (this.getChangeSet() != null) {
            stmt.setId(this.getChangeSet().getId());
            stmt.setFile(this.getChangeSet().getFilePath());
            stmt.setAuthor(this.getChangeSet().getAuthor());
        }
        return new SqlStatement[]{stmt};
    }

    public boolean supportsRollback(Database database) {
        return false;
    }

    protected Change[] createInverses() {
        return null;
    }
}

