/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.ora.createoraclepackagebody;

import java.text.MessageFormat;
import liquibase.change.Change;
import liquibase.change.DatabaseChange;
import liquibase.database.Database;
import liquibase.ext.ora.abstractplsqlobject.AbstractCommonPlSqlChange;
import liquibase.ext.ora.createoraclepackagebody.CreatePackageBodyStatement;
import liquibase.ext.ora.droporaclepackagebody.DropPackageBodyChange;
import liquibase.statement.SqlStatement;

@DatabaseChange(name="createOraclePackageBody", description="Create oracle Package body", priority=1)
public class CreatePackageBodyChange
extends AbstractCommonPlSqlChange {
    public CreatePackageBodyChange() {
        this.setObjectType("PACKAGE_BODY");
    }

    public String getConfirmationMessage() {
        return MessageFormat.format("Package Body {0} created", this.getObjectName());
    }

    public SqlStatement[] generateStatements(Database database) {
        CreatePackageBodyStatement stmt = new CreatePackageBodyStatement();
        stmt.setObjectName(this.getObjectName());
        stmt.setObjectOwner(this.getOwnerName());
        stmt.setObjectType(this.getObjectType());
        stmt.setReplaceIfExists(this.getReplaceIfExists());
        stmt.setSource(this.getSource());
        if (this.getChangeSet() != null) {
            stmt.setId(this.getChangeSet().getId());
            stmt.setFile(this.getChangeSet().getFilePath());
            stmt.setAuthor(this.getChangeSet().getAuthor());
        }
        return new SqlStatement[]{stmt};
    }

    protected Change[] createInverses() {
        DropPackageBodyChange inverse = new DropPackageBodyChange();
        inverse.setObjectName(this.getObjectName());
        inverse.setOwnerName(this.getOwnerName());
        inverse.setObjectType(this.getObjectType());
        inverse.setReplaceIfExists(this.getReplaceIfExists());
        inverse.setSource(this.getSource());
        if (this.getChangeSet() != null) {
            inverse.setId(this.getChangeSet().getId());
            inverse.setFile(this.getChangeSet().getFilePath());
            inverse.setAuthor(this.getChangeSet().getAuthor());
        }
        return new Change[]{inverse};
    }
}

