/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.ora.createoracleconstraint;

import java.text.MessageFormat;
import liquibase.change.Change;
import liquibase.change.DatabaseChange;
import liquibase.database.Database;
import liquibase.ext.ora.abstractplsqlobject.AbstractCommonPlSqlChange;
import liquibase.ext.ora.createoracleconstraint.CreateConstraintStatement;
import liquibase.ext.ora.droporacleconstraint.DropConstraintChange;
import liquibase.statement.SqlStatement;

@DatabaseChange(name="createOracleConstraint", description="Create oracle Constraint", priority=1)
public class CreateConstraintChange
extends AbstractCommonPlSqlChange {
    public CreateConstraintChange() {
        this.setObjectType("CONSTRAINT");
    }

    public String getConfirmationMessage() {
        return MessageFormat.format("Constraint {0} created", this.getObjectName());
    }

    public SqlStatement[] generateStatements(Database database) {
        CreateConstraintStatement stmt = new CreateConstraintStatement();
        stmt.setObjectName(this.getObjectName());
        stmt.setObjectOwner(this.getOwnerName());
        stmt.setReplaceIfExists(this.getReplaceIfExists());
        stmt.setSource(this.getSource());
        if (this.getChangeSet() != null) {
            stmt.setId(this.getChangeSet().getId());
            stmt.setFile(this.getChangeSet().getFilePath());
            stmt.setAuthor(this.getChangeSet().getAuthor());
        }
        return new SqlStatement[]{stmt};
    }

    protected Change[] createInverses() {
        DropConstraintChange inverse = new DropConstraintChange();
        inverse.setObjectName(this.getObjectName());
        inverse.setOwnerName(this.getOwnerName());
        inverse.setSource(this.getSource());
        if (this.getChangeSet() != null) {
            inverse.setId(this.getChangeSet().getId());
            inverse.setFile(this.getChangeSet().getFilePath());
            inverse.setAuthor(this.getChangeSet().getAuthor());
        }
        return new Change[]{inverse};
    }
}

