/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.ext;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Connection;
import java.text.MessageFormat;
import java.util.List;
import liquibase.Scope;
import liquibase.change.Change;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.configuration.SqlclConfig;
import liquibase.configuration.SqlclConfigWrapper;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.core.OracleDatabase;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.DatabaseException;
import liquibase.exception.LiquibaseException;
import liquibase.executor.Executor;
import liquibase.executor.ExecutorService;
import liquibase.executor.LoggingExecutor;
import liquibase.executor.jvm.JdbcExecutor;
import liquibase.ext.ora.abstractplsqlobject.AbstractCommonPlSqlChange;
import liquibase.ext.ora.abstractplsqlobject.AbstractCommonPlSqlStatement;
import liquibase.ext.ora.abstractsxmlobject.AbstractCommonSxmlChange;
import liquibase.ext.ora.abstractsxmlobject.AbstractCommonSxmlStatement;
import liquibase.ext.ora.oraclestatement.AbstractOracleStatement;
import liquibase.ext.ora.rollback.RollbackOraclePlSqlChange;
import liquibase.ext.ora.rollback.RollbackOraclePlSqlStatement;
import liquibase.ext.ora.rollback.RollbackOracleSxmlChange;
import liquibase.ext.ora.rollback.RollbackOracleSxmlStatement;
import liquibase.ext.ora.runoraclescript.RunOracleScriptStatement;
import liquibase.sql.Sql;
import liquibase.sql.visitor.SqlVisitor;
import liquibase.sqlgenerator.SqlGeneratorFactory;
import liquibase.statement.AbstractSqlStatement;
import liquibase.statement.SqlStatement;
import oracle.dbtools.raptor.liquibase.exceptions.ProcessFailedException;
import oracle.dbtools.raptor.liquibase.logging.LogTableManager;
import oracle.dbtools.raptor.liquibase.utils.DbmsMetaUtils;
import oracle.dbtools.raptor.liquibase.utils.LbExceptionHandler;
import oracle.dbtools.raptor.liquibase.utils.QueryUtils;
import oracle.dbtools.raptor.newscriptrunner.ScriptExecutor;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.scriptrunner.commands.liquibase.LiquibaseActions;
import oracle.dbtools.raptor.scriptrunner.commands.liquibase.Messages;

public class OracleDatabaseV2
extends OracleDatabase {
    public void execute(SqlStatement[] statements, List<SqlVisitor> sqlVisitors) throws LiquibaseException {
        this.executeWithActionLogging(statements, sqlVisitors, null);
    }

    public void executeRollbackStatements(Change change, List<SqlVisitor> sqlVisitors) throws LiquibaseException {
        try {
            String action = null;
            boolean skipped = false;
            String id = null;
            String author = null;
            String file = null;
            boolean drop = false;
            SqlStatement[] statements = null;
            if (change instanceof AbstractCommonSxmlChange) {
                id = ((AbstractCommonSxmlChange)change).getId();
                author = ((AbstractCommonSxmlChange)change).getAuthor();
                file = ((AbstractCommonSxmlChange)change).getFile();
                action = LogTableManager.getActionFromActionLog((Database)this, id, author, file);
                if (!change.supportsRollback((Database)this)) {
                    String logid = file + "::" + id + "::" + author;
                    LiquibaseActions.getConfig().getContext().write("Rollback not supported: " + logid + "\n");
                    return;
                }
                if (action != null && action.equalsIgnoreCase("--skipped")) {
                    skipped = true;
                } else if (action != null && !action.equalsIgnoreCase("")) {
                    ((AbstractCommonSxmlChange)change).setSource(action);
                } else {
                    drop = true;
                }
            } else if (change instanceof AbstractCommonPlSqlChange) {
                id = ((AbstractCommonPlSqlChange)change).getId();
                author = ((AbstractCommonPlSqlChange)change).getAuthor();
                file = ((AbstractCommonPlSqlChange)change).getFile();
                action = LogTableManager.getActionFromActionLog((Database)this, id, author, file);
                if (!change.supportsRollback((Database)this)) {
                    String logid = file + "::" + id + "::" + author;
                    LiquibaseActions.getConfig().getContext().write("Rollback not supported: " + logid + "\n");
                    return;
                }
                if (action != null && action.equalsIgnoreCase("--skipped")) {
                    skipped = true;
                } else if (action != null && !action.equalsIgnoreCase("")) {
                    ((AbstractCommonPlSqlChange)change).setSource(action);
                } else {
                    drop = true;
                }
            } else {
                super.executeRollbackStatements(change, sqlVisitors);
            }
            if (skipped) {
                Executor currentExecutor = ((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).getExecutor("jdbc", (Database)this);
                SqlStatement logstmt = this.getRollbackAction(id, author, file);
                if (currentExecutor instanceof LoggingExecutor) {
                    currentExecutor.execute(logstmt, sqlVisitors);
                } else {
                    Sql[] sql2 = SqlGeneratorFactory.getInstance().generateSql(logstmt, (Database)this);
                    this.runRollbackSql(sql2[0].toSql(), ((JdbcConnection)this.getConnection()).getUnderlyingConnection());
                }
            } else {
                if (change instanceof AbstractCommonSxmlChange) {
                    RollbackOracleSxmlChange rb = new RollbackOracleSxmlChange((AbstractCommonSxmlChange)change);
                    if (drop) {
                        rb.setSource(null);
                    }
                    statements = rb.generateStatements((Database)this);
                } else if (change instanceof AbstractCommonPlSqlChange) {
                    RollbackOraclePlSqlChange rb = new RollbackOraclePlSqlChange((AbstractCommonPlSqlChange)change);
                    if (drop) {
                        rb.setSource(null);
                    }
                    statements = rb.generateStatements((Database)this);
                }
                this.executeRollbackStatements(statements, sqlVisitors);
            }
        }
        catch (Exception e) {
            LbExceptionHandler.handleError(e, e.getStackTrace()[1].getMethodName(), true);
            if (e instanceof LiquibaseException) {
                throw (LiquibaseException)e;
            }
            throw new LiquibaseException(e.getStackTrace()[0].getMethodName(), (Throwable)e);
        }
    }

    public void executeRollbackStatements(SqlStatement[] statements, List<SqlVisitor> sqlVisitors) throws LiquibaseException {
        this.executeWithActionLogging(statements, sqlVisitors, null);
    }

    public void executeStatements(Change change, DatabaseChangeLog changeLog, List<SqlVisitor> sqlVisitors) throws LiquibaseException {
        try {
            if (change instanceof AbstractCommonSxmlChange || change instanceof AbstractCommonPlSqlChange) {
                SqlStatement[] statements;
                for (SqlStatement stmt : statements = change.generateStatements((Database)this)) {
                    if (!(stmt instanceof AbstractSqlStatement)) continue;
                    AbstractSqlStatement a = (AbstractSqlStatement)stmt;
                    if (change.getChangeSet().getFailOnError() == null) continue;
                    a.setContinueOnError(change.getChangeSet().getFailOnError() == false);
                }
                if (change instanceof AbstractCommonSxmlChange) {
                    this.executeWithActionLogging(statements, sqlVisitors, DbmsMetaUtils.getObjectFromDb(this.getBaseConnection(), ((AbstractCommonSxmlStatement)statements[0]).getObjectType(), ((AbstractCommonSxmlStatement)statements[0]).getObjectName()));
                } else if (change instanceof AbstractCommonPlSqlChange) {
                    AbstractCommonPlSqlChange xmlChange = (AbstractCommonPlSqlChange)change;
                    if (QueryUtils.doesObjectExist(((JdbcConnection)this.getConnection()).getUnderlyingConnection(), xmlChange.getObjectName(), xmlChange.getObjectType())) {
                        this.executeWithActionLogging(statements, sqlVisitors, DbmsMetaUtils.getObjectFromDb(this.getBaseConnection(), ((AbstractCommonPlSqlStatement)statements[0]).getObjectType(), ((AbstractCommonPlSqlStatement)statements[0]).getObjectName()));
                    } else {
                        this.executeWithActionLogging(statements, sqlVisitors, null);
                    }
                }
            } else {
                super.executeStatements(change, changeLog, sqlVisitors);
            }
        }
        catch (Exception e) {
            LbExceptionHandler.handleError(e, e.getStackTrace()[1].getMethodName(), true);
            if (e instanceof DatabaseException) {
                throw (DatabaseException)((Object)e);
            }
            throw new DatabaseException(e.getStackTrace()[0].getMethodName(), (Throwable)e);
        }
    }

    public void executeWithActionLogging(SqlStatement[] statements, List<SqlVisitor> sqlVisitors, String sxml) throws DatabaseException {
        String logid = null;
        Sql[] sql = null;
        String sqlToRun = null;
        for (SqlStatement statement : statements) {
            SqlStatement logstmt;
            AbstractOracleStatement stmt;
            if (statement.skipOnUnsupported() && !SqlGeneratorFactory.getInstance().supports(statement, (Database)this)) continue;
            Executor currentExecutor = ((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).getExecutor("jdbc", (Database)this);
            String actionType = null;
            actionType = currentExecutor instanceof LoggingExecutor ? "ScriptRunner Logging: " : "ScriptRunner Executing: ";
            if (statement instanceof AbstractOracleStatement) {
                stmt = (AbstractOracleStatement)statement;
                logid = stmt.getFile() + "::" + stmt.getId() + "::" + stmt.getAuthor();
                LiquibaseActions.getConfig().getContext().write(actionType + logid + "\n");
            } else {
                LiquibaseActions.getConfig().getContext().write(actionType + statement.toString() + "\n");
            }
            if (statement instanceof AbstractOracleStatement && ((AbstractOracleStatement)statement).useScriptRunner() && currentExecutor instanceof JdbcExecutor) {
                sql = SqlGeneratorFactory.getInstance().generateSql(statement, (Database)this);
                sqlToRun = sql != null ? sql[0].toSql() : "-- object is the same nothing to do;";
                try {
                    String result = null;
                    result = statement instanceof RollbackOracleSxmlStatement || statement instanceof RollbackOraclePlSqlStatement ? this.runRollbackSql(sqlToRun, ((JdbcConnection)this.getConnection()).getUnderlyingConnection()) : QueryUtils.runSqlReturnResult(sqlToRun, ((JdbcConnection)this.getConnection()).getUnderlyingConnection());
                    LiquibaseActions.getConfig().getContext().write(" -- DONE\n");
                    BufferedOutputStream m_out = LiquibaseActions.getConfig().getOutputBuffer();
                    if (m_out != null) {
                        logid = "-- " + logid + "\n";
                        m_out.write(logid.getBytes());
                        m_out.write(sqlToRun.getBytes());
                        m_out.write(result.getBytes());
                        m_out.flush();
                    }
                    try {
                        Sql[] sql2;
                        AbstractOracleStatement rb;
                        logstmt = null;
                        if (statement instanceof RollbackOracleSxmlStatement) {
                            rb = (RollbackOracleSxmlStatement)statement;
                            logstmt = this.getRollbackAction(rb.getId(), rb.getAuthor(), rb.getFile());
                            sql2 = SqlGeneratorFactory.getInstance().generateSql(logstmt, (Database)this);
                            result = this.runRollbackSql(sql2[0].toSql(), ((JdbcConnection)this.getConnection()).getUnderlyingConnection());
                            continue;
                        }
                        if (statement instanceof RollbackOraclePlSqlStatement) {
                            rb = (RollbackOraclePlSqlStatement)statement;
                            logstmt = this.getRollbackAction(rb.getId(), rb.getAuthor(), rb.getFile());
                            sql2 = SqlGeneratorFactory.getInstance().generateSql(logstmt, (Database)this);
                            result = this.runRollbackSql(sql2[0].toSql(), ((JdbcConnection)this.getConnection()).getUnderlyingConnection());
                            continue;
                        }
                        AbstractOracleStatement st = (AbstractOracleStatement)statement;
                        logstmt = LogTableManager.logAction(st.getId(), st.getAuthor(), st.getFile(), sqlToRun, sxml, (Database)this);
                        sql2 = SqlGeneratorFactory.getInstance().generateSql(logstmt, (Database)this);
                        if (statement instanceof RunOracleScriptStatement) {
                            result = QueryUtils.runSqlReturnResult(sql2[0].toSql(), ((JdbcConnection)this.getConnection()).getUnderlyingConnection(), true);
                            continue;
                        }
                        result = QueryUtils.runSqlReturnResult(sql2[0].toSql(), ((JdbcConnection)this.getConnection()).getUnderlyingConnection());
                        continue;
                    }
                    catch (Exception e) {
                        if (e instanceof ProcessFailedException) {
                            Exception e1 = ((ProcessFailedException)e).getOriginalException();
                            throw new DatabaseException((Throwable)e1);
                        }
                        throw new DatabaseException((Throwable)e);
                    }
                }
                catch (Exception e) {
                    LbExceptionHandler.handleError(e, e.getStackTrace()[1].getMethodName(), true);
                    LiquibaseActions.getConfig().getContext().write(" -- ERROR\n");
                    if (statement.continueOnError()) {
                        String error = null;
                        if (e instanceof ProcessFailedException) {
                            LiquibaseActions.getConfig().getContext().write("Error executing statement '" + statement.toString() + "', but continuing\n" + ((ProcessFailedException)e).getOriginalException().getMessage() + "\n");
                            error = ((ProcessFailedException)e).getOriginalException().getMessage();
                        } else {
                            LiquibaseActions.getConfig().getContext().write("Error executing statement '" + statement.toString() + "', but continuing\n" + e.getMessage() + "\n");
                            error = e.getMessage();
                        }
                        try {
                            if (statement instanceof AbstractOracleStatement) {
                                AbstractOracleStatement stmt2 = (AbstractOracleStatement)statement;
                                logid = stmt2.getFile() + "::" + stmt2.getId() + "::" + stmt2.getAuthor();
                            } else {
                                logid = statement.toString();
                            }
                            BufferedOutputStream m_out = LiquibaseActions.getConfig().getOutputBuffer();
                            if (m_out != null) {
                                logid = "-- " + logid + "\n";
                                m_out.write(logid.getBytes());
                                m_out.write(sqlToRun.getBytes());
                                m_out.write(error.getBytes());
                                m_out.flush();
                            }
                        }
                        catch (Exception m_out) {
                            // empty catch block
                        }
                        ((SqlclConfig)SqlclConfigWrapper.SQLCL_CONFIG.getCurrentValue()).addError(logid + "\n" + error);
                        continue;
                    }
                    if (e instanceof ProcessFailedException) {
                        throw new DatabaseException((Throwable)((ProcessFailedException)e).getOriginalException());
                    }
                    if (e instanceof DatabaseException) {
                        throw (DatabaseException)((Object)e);
                    }
                    throw new DatabaseException((Throwable)e);
                }
            }
            if (statement instanceof AbstractOracleStatement && currentExecutor instanceof LoggingExecutor) {
                try {
                    AbstractOracleStatement rb;
                    stmt = (AbstractOracleStatement)statement;
                    currentExecutor.execute(statement, sqlVisitors);
                    if (statement instanceof RollbackOracleSxmlStatement) {
                        rb = (RollbackOracleSxmlStatement)statement;
                        logstmt = this.getRollbackAction(rb.getId(), rb.getAuthor(), rb.getFile());
                        currentExecutor.execute(logstmt, sqlVisitors);
                    } else if (statement instanceof RollbackOraclePlSqlStatement) {
                        rb = (RollbackOraclePlSqlStatement)statement;
                        logstmt = this.getRollbackAction(rb.getId(), rb.getAuthor(), rb.getFile());
                        currentExecutor.execute(logstmt, sqlVisitors);
                    } else {
                        sql = SqlGeneratorFactory.getInstance().generateSql(statement, (Database)this);
                        sqlToRun = sql != null ? sql[0].toSql() : "-- object is the same nothing to do;";
                        SqlStatement logstmt2 = LogTableManager.logAction(stmt.getId(), stmt.getAuthor(), stmt.getFile(), sqlToRun, sxml, (Database)this);
                        currentExecutor.execute(logstmt2, sqlVisitors);
                    }
                    LiquibaseActions.getConfig().getContext().write(" -- DONE\n");
                }
                catch (DatabaseException e) {
                    LbExceptionHandler.handleError((Exception)((Object)e), e.getStackTrace()[1].getMethodName(), true);
                    if (!statement.continueOnError()) {
                        throw e;
                    }
                    LiquibaseActions.getConfig().getContext().write("-- ERROR , but continuing\n" + e.getMessage() + "\n");
                }
                continue;
            }
            try {
                currentExecutor.execute(statement, sqlVisitors);
                if (currentExecutor instanceof LoggingExecutor) continue;
                LiquibaseActions.getConfig().getContext().write("Liquibase Executed:" + statement.toString() + "\n");
            }
            catch (DatabaseException e) {
                LbExceptionHandler.handleError((Exception)((Object)e), e.getStackTrace()[1].getMethodName(), true);
                if (!statement.continueOnError()) {
                    throw e;
                }
                LiquibaseActions.getConfig().getContext().write(MessageFormat.format(Messages.getString("LB_DB_ERROR") + "\n", e.getMessage()));
            }
        }
    }

    public int getPriority() {
        return 999;
    }

    public SqlStatement getRollbackAction(String id, String author, String filename) {
        StringBuffer sb = new StringBuffer();
        sb.append("delete from DATABASECHANGELOG_actions where id = '" + id + "' and filename = '" + filename + "' and author ='" + author + "' and sequence = (select Max(sequence) from DATABASECHANGELOG_actions where id = '" + id + "' and filename = '" + filename + "' and author ='" + author + "')");
        RunOracleScriptStatement stmt = new RunOracleScriptStatement();
        stmt.setObjectName("rollbackAction");
        stmt.setContinueOnError(true);
        stmt.setObjectOwner(author);
        stmt.setUseScriptRunner(true);
        stmt.setSource(sb.toString());
        stmt.setSourceType("STRING");
        return stmt;
    }

    public boolean isCorrectDatabaseImplementation(DatabaseConnection conn) throws DatabaseException {
        return "oracle".equalsIgnoreCase(conn.getDatabaseProductName());
    }

    public String runRollbackSql(String sql, Connection conn) throws ProcessFailedException {
        try {
            String encoding = ScriptRunnerContext.getOutputEncoding();
            StringReader rdr = new StringReader(sql);
            ScriptExecutor runner = new ScriptExecutor((Reader)rdr, conn);
            ScriptRunnerContext ctx = new ScriptRunnerContext();
            ctx.putProperty("script.runner.using.systemout", (Object)true);
            ctx.setSubstitutionOn(false);
            ctx.setScanOn(false);
            runner.setScriptRunnerContext(ctx);
            ByteArrayOutputStream BaS = new ByteArrayOutputStream();
            BufferedOutputStream BoS = new BufferedOutputStream(BaS);
            runner.setOut(BoS);
            runner.run();
            BoS.flush();
            conn.commit();
            return BaS.toString(encoding);
        }
        catch (Exception e) {
            LbExceptionHandler.handleError(e, e.getStackTrace()[1].getMethodName(), true);
            if (e instanceof ProcessFailedException) {
                throw (ProcessFailedException)e;
            }
            throw new ProcessFailedException(e, e.getStackTrace()[0].getMethodName());
        }
    }

    private Connection getBaseConnection() {
        return ((JdbcConnection)this.getConnection()).getUnderlyingConnection();
    }
}

