/*
 * Decompiled with CFR 0.152.
 */
package liquibase.changelog.visitor;

import java.sql.Connection;
import java.util.Set;
import liquibase.Scope;
import liquibase.change.AbstractChange;
import liquibase.change.Change;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.changelog.filter.ChangeSetFilterResult;
import liquibase.changelog.visitor.ChangeSetVisitor;
import liquibase.changelog.visitor.SkippedChangeSetVisitor;
import liquibase.database.Database;
import liquibase.database.ext.OracleDatabaseV2;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.LiquibaseException;
import liquibase.executor.ExecutorService;
import liquibase.ext.ora.abstractplsqlobject.AbstractCommonPlSqlChange;
import liquibase.ext.ora.abstractsxmlobject.AbstractCommonSxmlChange;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.MarkChangeSetRanStatement;
import oracle.dbtools.raptor.liquibase.exceptions.ProcessFailedException;
import oracle.dbtools.raptor.liquibase.utils.LbExceptionHandler;
import oracle.dbtools.raptor.liquibase.utils.QueryUtils;

public class OracleSkippedChangeVisitor
implements ChangeSetVisitor,
SkippedChangeSetVisitor {
    private String dep_id = null;

    public OracleSkippedChangeVisitor(String deployment) {
        this.dep_id = deployment;
    }

    public void skipped(ChangeSet changeSet, DatabaseChangeLog databaseChangeLog, Database database, Set<ChangeSetFilterResult> filterResults) throws LiquibaseException {
        ((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).getExecutor("jdbc", database).execute((SqlStatement)new MarkChangeSetRanStatement(changeSet, ChangeSet.ExecType.SKIPPED));
        database.commit();
        this.LogSkippedChangeset(database, changeSet);
    }

    private void LogSkippedChangeset(Database database, ChangeSet changeSet) throws LiquibaseException {
        Connection conn = ((JdbcConnection)database.getConnection()).getUnderlyingConnection();
        String id = null;
        String author = null;
        String filename = null;
        if (database instanceof OracleDatabaseV2) {
            OracleDatabaseV2 db = (OracleDatabaseV2)database;
            for (Change change : changeSet.getChanges()) {
                AbstractChange chg;
                if (change instanceof AbstractCommonPlSqlChange) {
                    chg = (AbstractCommonPlSqlChange)change;
                    id = chg.getId();
                    author = chg.getAuthor();
                    filename = chg.getFile();
                } else if (change instanceof AbstractCommonSxmlChange) {
                    chg = (AbstractCommonSxmlChange)change;
                    id = chg.getId();
                    author = chg.getAuthor();
                    filename = chg.getFile();
                } else {
                    return;
                }
                try {
                    QueryUtils.runSqlReturnResult("insert into DATABASECHANGELOG_ACTIONS (id,author,filename,sql,sxml,deployment_id) values ('" + id + "','" + author + "','" + filename + "','--skipped','--skipped','" + this.dep_id + "')", conn);
                    db.commit();
                }
                catch (ProcessFailedException e) {
                    LbExceptionHandler.handleError(e, null, false);
                    throw new LiquibaseException((Throwable)e);
                }
                catch (Exception e) {
                    LbExceptionHandler.handleError(e, null, false);
                    if (e instanceof LiquibaseException) {
                        throw e;
                    }
                    throw new LiquibaseException((Throwable)e);
                }
            }
        }
    }

    public ChangeSetVisitor.Direction getDirection() {
        return ChangeSetVisitor.Direction.FORWARD;
    }

    public void visit(ChangeSet changeSet, DatabaseChangeLog databaseChangeLog, Database database, Set<ChangeSetFilterResult> filterResults) throws LiquibaseException {
        boolean doit = true;
    }
}

