/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudstorage.api.retry;

import oracle.cloudstorage.api.IReply;
import oracle.cloudstorage.api.auth.IAuthReply;
import oracle.cloudstorage.api.request.processor.IResponseAdapter;
import oracle.cloudstorage.api.retry.AbstractDelayedRetry;
import oracle.cloudstorage.text.Strings;

public class RetryState {
    private final long start = System.currentTimeMillis();
    private boolean retryAttemptable = true;
    private int attempt = 0;
    private IResponseAdapter<? extends IReply> responseAdapter;
    private IAuthReply authReply;
    private int evaluation = 0;

    public int getAttempt() {
        return this.attempt;
    }

    public void setRetryAttemptable(boolean retryAttemptable) {
        this.retryAttemptable = retryAttemptable;
    }

    public boolean isRetryAttemptable() {
        return this.retryAttemptable;
    }

    public int getEvaluation() {
        return this.evaluation;
    }

    public void incrementAttempt() {
        ++this.attempt;
    }

    public void incrementEvaluation() {
        ++this.evaluation;
    }

    public long getRemainingElapsedMillis(long maxElapsedMillis) {
        long remaining = maxElapsedMillis > (long)AbstractDelayedRetry.UNLIMITED ? maxElapsedMillis - this.getElapsedMillis() : Long.MAX_VALUE;
        return remaining;
    }

    public int getRemainingAttempts(int maxAttempts, int maxEvaluations) {
        int attempts = maxAttempts > AbstractDelayedRetry.UNLIMITED ? maxAttempts - this.getAttempt() : Integer.MAX_VALUE;
        int evaluations = maxEvaluations > AbstractDelayedRetry.UNLIMITED ? maxEvaluations - this.getEvaluation() : Integer.MAX_VALUE;
        int remaining = Math.min(attempts, evaluations);
        return remaining;
    }

    public long getElapsedMillis() {
        return System.currentTimeMillis() - this.start;
    }

    public void setResponseAdapter(IResponseAdapter<? extends IReply> responseAdapter) {
        this.responseAdapter = responseAdapter;
    }

    public void closeResponseAdapter(boolean usedByReply) {
        if (this.responseAdapter != null) {
            this.responseAdapter.close(usedByReply);
        }
    }

    public void setAuthReply(IAuthReply authReply) {
        this.authReply = authReply;
    }

    public IAuthReply getAuthReply() {
        return this.authReply;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "@" + Strings.identity(this) + " attempt: " + this.getAttempt() + ", elapsed time: " + this.getElapsedMillis() + " ms";
    }
}

