/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.common;

import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.sql.SQLRecoverableException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import oracle.ucp.ConnectionAffinityCallback;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.UniversalPooledConnection;
import oracle.ucp.actors.InterruptableActor;
import oracle.ucp.common.AffinityContext;
import oracle.ucp.common.Clock;
import oracle.ucp.common.ConnectionCreationBroker;
import oracle.ucp.common.ConnectionSource;
import oracle.ucp.common.CoreConnection;
import oracle.ucp.common.CoreConnectionImpl;
import oracle.ucp.common.FailoverDriver;
import oracle.ucp.common.LoadBalancer;
import oracle.ucp.common.Selector;
import oracle.ucp.common.Selectors;
import oracle.ucp.common.ServiceMember;
import oracle.ucp.common.Topology;
import oracle.ucp.jdbc.JDBCConnectionRetrievalInfo;
import oracle.ucp.jdbc.oracle.OracleJDBCConnectionRetrievalInfo;
import oracle.ucp.logging.ClioSupport;
import oracle.ucp.logging.annotations.DefaultLogger;
import oracle.ucp.logging.annotations.DisableTrace;
import oracle.ucp.logging.annotations.Feature;
import oracle.ucp.logging.annotations.Supports;
import oracle.ucp.routing.DataDependentRoutingCache;
import oracle.ucp.routing.RACDataAffinityRoutingCache;
import oracle.ucp.routing.ShardRoutingCache;
import oracle.ucp.util.Pair;
import oracle.ucp.util.UCPErrorHandler;

@DefaultLogger(value="oracle.ucp.common")
@Supports(value={Feature.CHECK_IN, Feature.CHECK_OUT, Feature.CONN_CONSTRUCTION, Feature.CONN_DESTRUCTION, Feature.LOAD_BALANCING, Feature.HIGH_AVAILABILITY})
public class Service {
    private static final short DB_VERSION_122 = 12200;
    private String name;
    private boolean active = true;
    final Set<String> placement = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Topology connectionSource;
    final FailoverDriver failoverDriver;
    final LoadBalancer loadBalancer;
    final AtomicInteger activeCount = new AtomicInteger(0);
    final AtomicInteger borrowedCount = new AtomicInteger(0);
    final AtomicInteger pendingCreateCount = new AtomicInteger(0);
    private final ConcurrentMap<ServiceMember.Key, ServiceMember> serviceMembers = new ConcurrentHashMap<ServiceMember.Key, ServiceMember>();
    final AtomicInteger activeMembers = new AtomicInteger(0);
    final AtomicInteger idCount = new AtomicInteger(0);
    final LoadBalancer.Stats lbStats = new LoadBalancer.Stats();
    final FailoverDriver.Stats fdStats = new FailoverDriver.Stats();
    final AtomicReference<ConnectionSource.RebalanceCallback.Result> pendingRebalance = new AtomicReference<ConnectionSource.RebalanceCallback.Result>(new ConnectionSource.RebalanceCallback.Result());
    final AtomicInteger pendingCloseCount = new AtomicInteger(0);
    private String containerName = null;
    private final AtomicInteger lastDrainTimeout = new AtomicInteger(0);
    private volatile CountDownLatch registered = null;
    private final AtomicReference<DataDependentRoutingCache> routingCache = new AtomicReference<Object>(null);
    private String hostName = null;
    private AtomicReference<String[]> distributionTable = new AtomicReference<String[]>(new String[0]);
    private static Random rand;
    private final AtomicReference<Object> mostRecentONSEvent = new AtomicReference<Object>(null);
    private ConnectionCreationBroker connectionCreationBroker = new ConnectionCreationBroker();
    private static final InterruptableActor<UniversalPooledConnection, String, UniversalConnectionPoolException> interruptableActor;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;
    private static Executable $$$methodRef$$$29;
    private static Logger $$$loggerRef$$$29;
    private static Executable $$$methodRef$$$30;
    private static Logger $$$loggerRef$$$30;
    private static Executable $$$methodRef$$$31;
    private static Logger $$$loggerRef$$$31;
    private static Executable $$$methodRef$$$32;
    private static Logger $$$loggerRef$$$32;
    private static Executable $$$methodRef$$$33;
    private static Logger $$$loggerRef$$$33;
    private static Executable $$$methodRef$$$34;
    private static Logger $$$loggerRef$$$34;
    private static Executable $$$methodRef$$$35;
    private static Logger $$$loggerRef$$$35;
    private static Executable $$$methodRef$$$36;
    private static Logger $$$loggerRef$$$36;
    private static Executable $$$methodRef$$$37;
    private static Logger $$$loggerRef$$$37;
    private static Executable $$$methodRef$$$38;
    private static Logger $$$loggerRef$$$38;
    private static Executable $$$methodRef$$$39;
    private static Logger $$$loggerRef$$$39;
    private static Executable $$$methodRef$$$40;
    private static Logger $$$loggerRef$$$40;
    private static Executable $$$methodRef$$$41;
    private static Logger $$$loggerRef$$$41;
    private static Executable $$$methodRef$$$42;
    private static Logger $$$loggerRef$$$42;
    private static Executable $$$methodRef$$$43;
    private static Logger $$$loggerRef$$$43;
    private static Executable $$$methodRef$$$44;
    private static Logger $$$loggerRef$$$44;
    private static Executable $$$methodRef$$$45;
    private static Logger $$$loggerRef$$$45;
    private static Executable $$$methodRef$$$46;
    private static Logger $$$loggerRef$$$46;
    private static Executable $$$methodRef$$$47;
    private static Logger $$$loggerRef$$$47;
    private static Executable $$$methodRef$$$48;
    private static Logger $$$loggerRef$$$48;
    private static Executable $$$methodRef$$$49;
    private static Logger $$$loggerRef$$$49;
    private static Executable $$$methodRef$$$50;
    private static Logger $$$loggerRef$$$50;
    private static Executable $$$methodRef$$$51;
    private static Logger $$$loggerRef$$$51;
    private static Executable $$$methodRef$$$52;
    private static Logger $$$loggerRef$$$52;
    private static Executable $$$methodRef$$$53;
    private static Logger $$$loggerRef$$$53;
    private static Executable $$$methodRef$$$54;
    private static Logger $$$loggerRef$$$54;

    Service(Topology connectionSource, String name, ConnectionSource.FailoverCallback failoverCallback, ConnectionSource.RebalanceCallback rebalanceCallback) {
        this.connectionSource = connectionSource;
        this.name = name;
        this.failoverDriver = this.prepareFailoverDriver(failoverCallback);
        this.loadBalancer = this.prepareLoadBalancer(rebalanceCallback);
        ClioSupport.ilogFinest(null, null, null, null, "service " + name + " registered");
    }

    void onRegister() {
        if (this.registered != null) {
            this.registered.countDown();
        }
    }

    private void awaitRegister() {
        try {
            if (this.registered == null) {
                return;
            }
            this.registered.await();
        }
        catch (InterruptedException e) {
            ClioSupport.ilogThrowing(null, null, null, null, e);
        }
    }

    private void checkAndRegister() {
        if (this.registered == null) {
            this.registered = new CountDownLatch(1);
        }
    }

    int activeMembersCount() {
        if (!this.active) {
            return 0;
        }
        return this.activeMembers.get();
    }

    public void setName(String name) {
        this.name = name;
    }

    String containerName() {
        return this.containerName;
    }

    void setContainerName(String containerName) {
        this.containerName = containerName;
    }

    public ServiceMember insertMember(ServiceMember memberToInsert) {
        String h;
        if (this.name == null) {
            this.name = memberToInsert.service();
        }
        if (null == this.hostName) {
            this.hostName = memberToInsert.host();
        }
        String host = null == (h = memberToInsert.host()) || "".equals(h) ? this.hostName : h;
        ServiceMember inst = this.getMember(memberToInsert.name(), memberToInsert.database(), memberToInsert.service());
        if (null != inst) {
            if (!inst.host().equals("")) {
                return inst;
            }
            if (!memberToInsert.host().equals("")) {
                this.serviceMembers.remove(inst.key());
                this.serviceMembers.putIfAbsent(memberToInsert.key(), memberToInsert);
                return memberToInsert;
            }
            return inst;
        }
        if (null == this.serviceMembers.putIfAbsent(memberToInsert.key(), memberToInsert)) {
            memberToInsert.initId();
            this.activeMembers.incrementAndGet();
        }
        return memberToInsert;
    }

    public ServiceMember getMember(String instName, String dbName, String hostName, String serviceName) {
        return (ServiceMember)this.serviceMembers.get(new ServiceMember.Key(instName, dbName, hostName, serviceName));
    }

    public ServiceMember getMember(String instName, String dbName, String serviceName) {
        for (ServiceMember inst : this.getAllMembers()) {
            if (!inst.name().equals(instName) || !inst.database().equals(dbName) || !inst.service().equals(serviceName)) continue;
            return inst;
        }
        return null;
    }

    Collection<ServiceMember> getAllMembers() {
        return this.serviceMembers.values();
    }

    Collection<ServiceMember> getAllMembers(ConnectionRetrievalInfo cri) {
        return this.getAllMembers(cri, false);
    }

    Collection<ServiceMember> getAllMembers(ConnectionRetrievalInfo cri, boolean checkRoomToGrow) {
        if (!this.connectionSource.isDataDependentRoutingEnabled() || cri == null || this.routingCache() == null) {
            return this.getAllMembers();
        }
        if (checkRoomToGrow) {
            return this.routingCache().instancesToGrow(cri);
        }
        return this.routingCache().allInstances(cri);
    }

    void markup(FailoverDriver.Event event) {
        FailoverDriver.Event.Status status = event.status();
        String instname = event.instance();
        String hostname = event.host();
        String service = event.serviceName();
        String database = event.database();
        FailoverDriver.Event.EventType eventType = event.event_type();
        ClioSupport.ilogFinest(null, null, null, null, "FF markup:" + " event=" + event.toString());
        if ((FailoverDriver.Event.EventType.INSTANCE == eventType || FailoverDriver.Event.EventType.SERVICEMEMBER == eventType) && null != instname) {
            this.insertMember(new ServiceMember(instname, database, hostname, service, this));
        }
        for (ServiceMember instance : this.serviceMembers.values()) {
            instance.clearRLBHistory();
            if ((FailoverDriver.Event.EventType.INSTANCE == eventType || FailoverDriver.Event.EventType.SERVICEMEMBER == eventType) && instname.equals(instance.name()) && database.equals(instance.database()) && service.equals(instance.service())) {
                instance.markActive(FailoverDriver.Event.Status.UP == status);
                continue;
            }
            if (FailoverDriver.Event.EventType.SERVICE == eventType && database.equals(instance.database()) && service.equals(instance.service())) {
                this.active = FailoverDriver.Event.Status.UP == status;
                continue;
            }
            if (FailoverDriver.Event.EventType.NODE != eventType || !hostname.equals(instance.host())) continue;
            instance.markActive(FailoverDriver.Event.Status.UP == status);
        }
    }

    void markup(LoadBalancer.Event event) {
        ClioSupport.ilogFinest(null, null, null, null, "load balancer markup:" + " event=" + event.toString());
        for (String instname : event.instances()) {
            if (null == instname) {
                ClioSupport.ilogWarning(null, null, null, null, "instaname is null, skipping");
                continue;
            }
            ServiceMember instance = this.insertMember(new ServiceMember(instname, event.database(), event.host(), event.service(), this));
            instance.markAffined(event.affinity(instname));
            ClioSupport.ilogFinest(null, null, null, null, " instance " + instance.toString() + " marked as affined");
            LoadBalancer.Event.Flag flag = event.flag(instname);
            instance.markActive(LoadBalancer.Event.Flag.NO_DATA != flag && LoadBalancer.Event.Flag.BLOCKED != flag);
            instance.markViolating(LoadBalancer.Event.Flag.VIOLATING == flag);
        }
    }

    int activeCount() {
        return this.activeCount.get();
    }

    int borrowedCount() {
        return this.borrowedCount.get();
    }

    private static int gcd(Integer ... n) {
        switch (n.length) {
            case 0: {
                return 1;
            }
            case 1: {
                return n[0];
            }
            case 2: {
                return 0 == n[1] ? n[0] : Service.gcd(n[1], n[0] % n[1]);
            }
        }
        Integer[] rest = new Integer[n.length - 1];
        rest[0] = Service.gcd(n[0], n[1]);
        System.arraycopy(n, 2, rest, 1, rest.length - 1);
        return Service.gcd(rest);
    }

    void buildDistributionTable() {
        ArrayList<String> listNames = new ArrayList<String>();
        ArrayList<Integer> listConns = new ArrayList<Integer>();
        for (ServiceMember inst : this.getAllMembers()) {
            int count = inst.activeCount.get();
            if (count <= 0) continue;
            listConns.add(count);
            listNames.add(inst.name());
        }
        Integer[] conns = listConns.toArray(new Integer[0]);
        String[] names = listNames.toArray(new String[0]);
        int gcd = Service.gcd(conns);
        ArrayList<String> dt = new ArrayList<String>();
        for (int i = 0; i < conns.length; ++i) {
            dt.addAll(Collections.nCopies(conns[i] / gcd, names[i]));
        }
        this.distributionTable.set(dt.toArray(new String[0]));
    }

    Selector proportionalDistributionSelector() {
        return new Selector(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;

            @Override
            public boolean selected(CoreConnection conn) {
                String[] dt = (String[])Service.this.distributionTable.get();
                return 0 == dt.length ? true : conn.serviceMember().name().equals(dt[rand.nextInt(dt.length)]);
            }

            static {
                try {
                    $$$methodRef$$$1 = 1.class.getDeclaredConstructor(Service.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$0 = 1.class.getDeclaredMethod("selected", CoreConnection.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            }
        };
    }

    public Topology connectionSource() {
        return this.connectionSource;
    }

    DataDependentRoutingCache routingCache() {
        if (this.routingCache.get() != null) {
            return this.routingCache.get();
        }
        this.routingCache.compareAndSet(null, this.prepareRoutingCache());
        return this.routingCache.get();
    }

    public String name() {
        return this.name;
    }

    void markConnCreationBrokerOperable() {
        this.connectionCreationBroker.markOperable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CoreConnection create(ConnectionRetrievalInfo cri, ConnectionAffinityCallback affinityCallback, EnumSet<ConnectionSource.CreateMode> createModes, long timeToRetry) throws UniversalConnectionPoolException {
        block21: {
            createdUpc = null;
            try {
                ClioSupport.ilogFinest(null, null, null, null, "create:  cri=" + cri.toString() + ", createModes=" + createModes + ", timeToRetry=" + timeToRetry);
                giveUp = Clock.clock() + Math.max(0L, timeToRetry);
                ucpEx = null;
lbl6:
                // 2 sources

                while (true) {
                    if (0L == (interval = this.connectionCreationBroker.appointNextAttempt())) {
                        this.pendingCreateCount.incrementAndGet();
                        try {
                            if (this.activeCount.get() + this.pendingCreateCount.get() > this.connectionSource.limits().getMaxPerService()) {
                                ClioSupport.ilogFinest(null, null, null, null, "Cannot create new connections, max connections per service limit reached");
                                interval = null;
                                return interval;
                            }
                            break;
                        }
                        catch (UniversalConnectionPoolException e) {
                            ClioSupport.ilogThrowing(null, null, null, null, e);
                            ucpEx = e;
                            if (!(e.getCause() instanceof SQLRecoverableException)) {
                                if (Service.isUnableToCreateConnection(e) == false) throw e;
                            }
                            this.connectionCreationBroker.markInoperable();
                            if (Service.isUnableToCreateConnection(e)) {
                                createModes = EnumSet.noneOf(ConnectionSource.CreateMode.class);
                                ClioSupport.ilogFinest(null, null, null, null, " unable to connect to specific instance, setting createModes = EnumSet.noneOf(CreateMode.class)");
                            }
                            break block21;
                        }
                    }
                    try {
                        Thread.sleep(Math.min(Math.max(0L, giveUp - Clock.clock()), interval));
                    }
                    catch (InterruptedException e) {
                        ClioSupport.ilogThrowing(null, null, null, null, e);
                    }
                    continue;
                    break;
                }
            }
            catch (Throwable var14_15) {
                ClioSupport.ilogFinest(null, null, null, null, "created:  cri=" + cri.toString() + ", createModes=" + createModes + ", timeToRetry=" + timeToRetry + ", createdUpc=" + createdUpc);
                throw var14_15;
            }
            conn = this.create(cri, affinityCallback, createModes);
            if (null != conn) {
                ClioSupport.ilogFinest(null, null, null, null, conn + " created");
                this.connectionCreationBroker.markOperable();
                var11_13 = createdUpc = conn;
                this.pendingCreateCount.decrementAndGet();
                ClioSupport.ilogFinest(null, null, null, null, "created:  cri=" + cri.toString() + ", createModes=" + createModes + ", timeToRetry=" + timeToRetry + ", createdUpc=" + createdUpc);
                return var11_13;
            }
            this.pendingCreateCount.decrementAndGet();
            this.connectionCreationBroker.markInoperable();
            break block21;
            finally {
                this.pendingCreateCount.decrementAndGet();
            }
        }
        if (Clock.clock() > giveUp) ** break;
        ** while (true)
        if (ucpEx != null) {
            throw ucpEx;
        }
        ClioSupport.ilogFinest(null, null, null, null, "gave up to create a connection");
        var10_10 = null;
        ClioSupport.ilogFinest(null, null, null, null, "created:  cri=" + cri.toString() + ", createModes=" + createModes + ", timeToRetry=" + timeToRetry + ", createdUpc=" + createdUpc);
        return var10_10;
    }

    private static boolean isUnableToCreateConnection(UniversalConnectionPoolException e) {
        return e.getErrorCode() == 45067;
    }

    private UniversalPooledConnection createConnectionInterruptably(final ConnectionRetrievalInfo cri) throws UniversalConnectionPoolException {
        return interruptableActor.doAction(new InterruptableActor.Action<UniversalPooledConnection, String, UniversalConnectionPoolException>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;
            private static Executable $$$methodRef$$$3;
            private static Logger $$$loggerRef$$$3;
            private static Executable $$$methodRef$$$4;
            private static Logger $$$loggerRef$$$4;

            @Override
            public UniversalPooledConnection exec() throws UniversalConnectionPoolException {
                return Service.this.connectionSource.createPooledConnection(cri);
            }

            @Override
            public String getDescriptor() {
                return ((OracleJDBCConnectionRetrievalInfo)cri).getInstanceName();
            }

            static {
                try {
                    $$$methodRef$$$4 = 2.class.getDeclaredConstructor(Service.class, ConnectionRetrievalInfo.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$3 = 2.class.getDeclaredMethod("exec", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$2 = 2.class.getDeclaredMethod("getDescriptor", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$1 = 2.class.getDeclaredMethod("getDescriptor", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$0 = 2.class.getDeclaredMethod("exec", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            }
        });
    }

    void interruptPendingCreations() {
        Map<String, ServiceMember> memberMap = this.getAllMembers().stream().collect(Collectors.toMap(ServiceMember::name, p -> p));
        ClioSupport.ilogFinest(null, null, null, null, "memberMap: " + memberMap.toString());
        interruptableActor.registerPredicate(p -> {
            String instName = (String)((InterruptableActor.Action)p.get1st()).getDescriptor();
            if (null == instName) {
                return false;
            }
            ServiceMember sm = (ServiceMember)memberMap.get(instName);
            return null == sm ? false : !sm.active();
        });
        interruptableActor.triggerInterrupts();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CoreConnection create(ConnectionRetrievalInfo cri, ConnectionAffinityCallback affinityCallback, EnumSet<ConnectionSource.CreateMode> createModes) throws UniversalConnectionPoolException {
        UniversalPooledConnection upc;
        Object context;
        Set<Object> possibleInstances;
        ServiceMember[] bestInstance = new ServiceMember[]{null};
        boolean isRoutingEnabled = this.connectionSource.isDataDependentRoutingEnabled();
        if (isRoutingEnabled && !this.routingCache().hasInstanceToGrow(cri)) {
            return null;
        }
        Set<Object> set = possibleInstances = isRoutingEnabled ? this.routingCache().instancesToGrow(cri) : new HashSet();
        if (isRoutingEnabled && possibleInstances.size() == 0) {
            createModes = EnumSet.noneOf(ConnectionSource.CreateMode.class);
        }
        if (createModes.contains((Object)ConnectionSource.CreateMode.USE_BEST_INSTANCE) && null != affinityCallback && null != (context = affinityCallback.getConnectionAffinityContext()) && context instanceof AffinityContext) {
            AffinityContext affinityContext = (AffinityContext)context;
            String affInstName = affinityContext.getInstanceName();
            if (null != affInstName) {
                int upperLimit;
                Object event = this.mostRecentONSEvent.get();
                if (null == event || event instanceof FailoverDriver.Event) {
                    upperLimit = this.connectionSource.limits().getMax();
                } else if (event instanceof LoadBalancer.Event) {
                    int max = this.connectionSource.limits().getMax();
                    if (max < Integer.MAX_VALUE) {
                        switch (affinityCallback.getAffinityPolicy()) {
                            case WEBSESSION_BASED_AFFINITY: 
                            case DATA_BASED_AFFINITY: {
                                LoadBalancer.Event lbEvent = (LoadBalancer.Event)event;
                                upperLimit = (int)((float)max * lbEvent.normalizedPercent(affInstName) / 100.0f);
                                break;
                            }
                            case TRANSACTION_BASED_AFFINITY: {
                                upperLimit = max;
                                break;
                            }
                            default: {
                                ClioSupport.ilogWarning(null, null, null, null, "unknown affinity policy");
                                upperLimit = max;
                                break;
                            }
                        }
                    } else {
                        upperLimit = Integer.MAX_VALUE;
                    }
                } else {
                    throw new IllegalStateException("wrong ONS event object");
                }
                ServiceMember inst = this.getMember(affInstName, affinityContext.getDatabaseUniqueName(), affinityContext.getServiceName());
                if (null != inst && inst.activeCount.get() < upperLimit) {
                    if (!possibleInstances.stream().anyMatch(k -> k.name().equals(affInstName))) {
                        this.lbStats.onFailedAffBorrowed();
                        inst.lbStats.onFailedAffBorrowed();
                        affinityCallback.setConnectionAffinityContext(null);
                    } else {
                        bestInstance[0] = inst;
                        this.lbStats.onSuccessfulAffBorrowed();
                        inst.lbStats.onSuccessfulAffBorrowed();
                    }
                } else {
                    this.lbStats.onFailedAffBorrowed();
                    inst.lbStats.onFailedAffBorrowed();
                    affinityCallback.setConnectionAffinityContext(null);
                }
            } else {
                affinityCallback.setConnectionAffinityContext(null);
                throw new IllegalStateException("wrong affinity context (missing instance name)");
            }
        }
        if (createModes.contains((Object)ConnectionSource.CreateMode.USE_BEST_INSTANCE) && null == bestInstance[0]) {
            bestInstance[0] = this.underloadedInstance(cri);
        }
        try {
            if (bestInstance[0] == null && isRoutingEnabled) {
                bestInstance[0] = this.routingCache().getBestInstanceToGrow(cri);
                if (bestInstance[0] != null) {
                    this.routingCache().onConnectionRequest(bestInstance[0]);
                }
            }
            String targetInst = bestInstance[0] != null ? bestInstance[0].name() : null;
            ClioSupport.ilogFinest(null, null, null, null, "targetInst=" + targetInst);
            ClioSupport.ilogFinest(null, null, null, null, "instances=" + this.serviceMembers.values().toString());
            ConnectionRetrievalInfo targetCri = cri instanceof JDBCConnectionRetrievalInfo ? new OracleJDBCConnectionRetrievalInfo((JDBCConnectionRetrievalInfo)cri, targetInst) : cri;
            ClioSupport.ilogFinest(null, null, null, null, "about to make an attempt to create a connection");
            UniversalPooledConnection lupc = null;
            try {
                lupc = this.createConnectionInterruptably(targetCri);
            }
            catch (UniversalConnectionPoolException e) {
                ClioSupport.ilogThrowing(null, null, null, null, e);
                Throwable cause = e.getCause();
                if (null == cause) {
                    throw e;
                }
                int errorCode = ((SQLException)cause).getErrorCode();
                ClioSupport.ilogFinest(null, null, null, null, "errorCode=" + errorCode);
                if (cause instanceof SQLException && (12521 == errorCode || 12514 == errorCode || 12757 == errorCode)) {
                    ClioSupport.ilogFinest(null, null, null, null, "caught " + cause.getMessage());
                    UCPErrorHandler.throwUniversalConnectionPoolException(67, e);
                } else {
                    ClioSupport.ilogFinest(null, null, null, null, "caught e.getCause().getErrorCode()= " + ((SQLException)cause).getErrorCode());
                }
                throw e;
            }
            upc = lupc;
        }
        finally {
            if (isRoutingEnabled && bestInstance[0] != null) {
                this.routingCache().onConnectionRequestComplete(bestInstance[0]);
            }
        }
        if (null == upc) {
            ClioSupport.ilogFine(null, null, null, null, "unable to create a connection");
            return null;
        }
        this.checkAndRegister();
        upc.plugDelegator(CoreConnectionImpl.create(this, upc));
        return upc.getDelegator();
    }

    private FailoverDriver prepareFailoverDriver(final ConnectionSource.FailoverCallback failoverCallback) {
        return new FailoverDriver(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected ConnectionSource.FailoverCallback.Result onEvent(FailoverDriver.Event event, Selector cleanupSelector, Selector markupSelector, boolean isGracefulDraining, boolean restoreAfterCleanup) {
                Service.this.mostRecentONSEvent.set(event);
                if (Service.this.connectionSource.isDataDependentRoutingEnabled()) {
                    Service.this.routingCache().onHAEvent(event);
                }
                return null != failoverCallback ? failoverCallback.handle(cleanupSelector, markupSelector, isGracefulDraining, restoreAfterCleanup) : new ConnectionSource.FailoverCallback.Result();
            }

            @Override
            protected Service service() {
                return Service.this;
            }

            static {
                try {
                    $$$methodRef$$$2 = 3.class.getDeclaredConstructor(Service.class, ConnectionSource.FailoverCallback.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$1 = 3.class.getDeclaredMethod("service", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$0 = 3.class.getDeclaredMethod("onEvent", FailoverDriver.Event.class, Selector.class, Selector.class, Boolean.TYPE, Boolean.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            }
        };
    }

    private LoadBalancer prepareLoadBalancer(final ConnectionSource.RebalanceCallback rebalanceCallback) {
        return new LoadBalancer(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected ConnectionSource.RebalanceCallback.Result onEvent(LoadBalancer.Event event, Selector gravitationCleanupSelector, Selector gravitationMarkupSelector) {
                Service.this.mostRecentONSEvent.set(event);
                return null != rebalanceCallback ? rebalanceCallback.handle(gravitationCleanupSelector, gravitationMarkupSelector) : new ConnectionSource.RebalanceCallback.Result();
            }

            @Override
            protected Service service() {
                return Service.this;
            }

            static {
                try {
                    $$$methodRef$$$2 = 4.class.getDeclaredConstructor(Service.class, ConnectionSource.RebalanceCallback.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$1 = 4.class.getDeclaredMethod("service", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$0 = 4.class.getDeclaredMethod("onEvent", LoadBalancer.Event.class, Selector.class, Selector.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            }
        };
    }

    public FailoverDriver.Stats failoverDriverStats() {
        return this.fdStats;
    }

    public LoadBalancer.Stats loadBalancerStats() {
        return this.lbStats;
    }

    ServiceMember underloadedInstance() {
        return this.underloadedInstance(null);
    }

    ServiceMember underloadedInstance(ConnectionRetrievalInfo cri) {
        Object event = this.mostRecentONSEvent.get();
        if (null == event) {
            return null;
        }
        ServiceMember underloadedInstance = null;
        if (event instanceof LoadBalancer.Event) {
            underloadedInstance = this.loadBalancer.underloadedInstance(cri);
        } else if (event instanceof FailoverDriver.Event) {
            underloadedInstance = this.failoverDriver.underloadedInstance(cri);
        } else {
            throw new IllegalStateException("wrong ONS event object");
        }
        return underloadedInstance;
    }

    public Selector loadBalancedBorrowSelector(ConnectionRetrievalInfo cri, ConnectionAffinityCallback affCallback) {
        return this.loadBalancer.borrowSelector(cri, affCallback);
    }

    private Properties getProperties(CoreConnection conn) {
        UniversalPooledConnection upc = (UniversalPooledConnection)conn.getDelegate();
        return upc.getDatabaseConnectionProperties();
    }

    void stop() {
        this.failoverDriver.stop();
        this.loadBalancer.stop();
    }

    @DisableTrace
    public String toString() {
        return this.name == null ? "Unnamed Service" : this.name;
    }

    public long totalBorrowTimes(ConnectionRetrievalInfo cri, Collection<ServiceMember> allMembers) {
        if (cri == null) {
            return this.lbStats.borrowTimes.totalDelta();
        }
        return allMembers.stream().mapToLong(sm -> sm.lbStats.borrowTimes.totalDelta()).sum();
    }

    int getLastDrainTimeout() {
        return this.lastDrainTimeout.get();
    }

    void setLastDrainTimeout(int drainTimeout) {
        this.lastDrainTimeout.set(drainTimeout);
    }

    private DataDependentRoutingCache prepareRoutingCache() {
        if (this.connectionSource.isShardedDatabase()) {
            return new ShardRoutingCache(){
                private static Executable $$$methodRef$$$0;
                private static Logger $$$loggerRef$$$0;
                private static Executable $$$methodRef$$$1;
                private static Logger $$$loggerRef$$$1;

                @Override
                protected Service service() {
                    return Service.this;
                }

                static {
                    try {
                        $$$methodRef$$$1 = 5.class.getDeclaredConstructor(Service.class);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                    try {
                        $$$methodRef$$$0 = 5.class.getDeclaredMethod("service", new Class[0]);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                }
            };
        }
        return new RACDataAffinityRoutingCache(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;

            @Override
            protected Service service() {
                return Service.this;
            }

            static {
                try {
                    $$$methodRef$$$1 = 6.class.getDeclaredConstructor(Service.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$0 = 6.class.getDeclaredMethod("service", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            }
        };
    }

    Selector serviceBasedRepurposeSelector(ConnectionRetrievalInfo cri, boolean balanced) {
        this.awaitRegister();
        if (this.activeCount.get() + this.pendingCreateCount.get() >= this.connectionSource.limits().getMaxPerService()) {
            return Selectors.NONE;
        }
        HashSet<String> dbInstsForRepurpose = new HashSet<String>(this.placement.size());
        ServiceMember underLoadedInst = this.underloadedInstance();
        if (balanced && underLoadedInst != null) {
            dbInstsForRepurpose.add(underLoadedInst.name());
        } else {
            dbInstsForRepurpose.addAll(this.placement);
        }
        return conn -> {
            if (!conn.available()) {
                return false;
            }
            if (conn.closed()) {
                return false;
            }
            return dbInstsForRepurpose.size() > 0 && dbInstsForRepurpose.contains(conn.serviceMember().name());
        };
    }

    public boolean isActive() {
        return this.active;
    }

    static {
        try {
            $$$methodRef$$$54 = Service.class.getDeclaredConstructor(Topology.class, String.class, ConnectionSource.FailoverCallback.class, ConnectionSource.RebalanceCallback.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$54 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$53 = Service.class.getDeclaredMethod("access$300", Service.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$53 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$52 = Service.class.getDeclaredMethod("access$200", Service.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$52 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$51 = Service.class.getDeclaredMethod("access$100", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$51 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$50 = Service.class.getDeclaredMethod("access$000", Service.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$50 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$49 = Service.class.getDeclaredMethod("lambda$interruptPendingCreations$0", ServiceMember.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$49 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$48 = Service.class.getDeclaredMethod("lambda$interruptPendingCreations$1", Map.class, Pair.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$48 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$47 = Service.class.getDeclaredMethod("lambda$create$2", String.class, ServiceMember.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$47 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$46 = Service.class.getDeclaredMethod("lambda$totalBorrowTimes$3", ServiceMember.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$46 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$45 = Service.class.getDeclaredMethod("lambda$serviceBasedRepurposeSelector$4", Set.class, CoreConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$45 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$44 = Service.class.getDeclaredMethod("isActive", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$44 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$43 = Service.class.getDeclaredMethod("serviceBasedRepurposeSelector", ConnectionRetrievalInfo.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$43 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$42 = Service.class.getDeclaredMethod("prepareRoutingCache", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$42 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$41 = Service.class.getDeclaredMethod("setLastDrainTimeout", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$41 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$40 = Service.class.getDeclaredMethod("getLastDrainTimeout", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$40 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$39 = Service.class.getDeclaredMethod("totalBorrowTimes", ConnectionRetrievalInfo.class, Collection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$39 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$38 = Service.class.getDeclaredMethod("toString", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$38 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$37 = Service.class.getDeclaredMethod("stop", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$37 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$36 = Service.class.getDeclaredMethod("getProperties", CoreConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$36 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$35 = Service.class.getDeclaredMethod("loadBalancedBorrowSelector", ConnectionRetrievalInfo.class, ConnectionAffinityCallback.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$35 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$34 = Service.class.getDeclaredMethod("underloadedInstance", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$34 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$33 = Service.class.getDeclaredMethod("underloadedInstance", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$33 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$32 = Service.class.getDeclaredMethod("loadBalancerStats", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$32 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$31 = Service.class.getDeclaredMethod("failoverDriverStats", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$31 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$30 = Service.class.getDeclaredMethod("prepareLoadBalancer", ConnectionSource.RebalanceCallback.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$29 = Service.class.getDeclaredMethod("prepareFailoverDriver", ConnectionSource.FailoverCallback.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$28 = Service.class.getDeclaredMethod("create", ConnectionRetrievalInfo.class, ConnectionAffinityCallback.class, EnumSet.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$27 = Service.class.getDeclaredMethod("interruptPendingCreations", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$26 = Service.class.getDeclaredMethod("createConnectionInterruptably", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$25 = Service.class.getDeclaredMethod("isUnableToCreateConnection", UniversalConnectionPoolException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$24 = Service.class.getDeclaredMethod("create", ConnectionRetrievalInfo.class, ConnectionAffinityCallback.class, EnumSet.class, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$23 = Service.class.getDeclaredMethod("markConnCreationBrokerOperable", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$22 = Service.class.getDeclaredMethod("name", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$21 = Service.class.getDeclaredMethod("routingCache", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$20 = Service.class.getDeclaredMethod("connectionSource", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$19 = Service.class.getDeclaredMethod("proportionalDistributionSelector", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$18 = Service.class.getDeclaredMethod("buildDistributionTable", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$17 = Service.class.getDeclaredMethod("gcd", Integer[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$16 = Service.class.getDeclaredMethod("borrowedCount", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$15 = Service.class.getDeclaredMethod("activeCount", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$14 = Service.class.getDeclaredMethod("markup", LoadBalancer.Event.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$13 = Service.class.getDeclaredMethod("markup", FailoverDriver.Event.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$12 = Service.class.getDeclaredMethod("getAllMembers", ConnectionRetrievalInfo.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$11 = Service.class.getDeclaredMethod("getAllMembers", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$10 = Service.class.getDeclaredMethod("getAllMembers", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$9 = Service.class.getDeclaredMethod("getMember", String.class, String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$8 = Service.class.getDeclaredMethod("getMember", String.class, String.class, String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$7 = Service.class.getDeclaredMethod("insertMember", ServiceMember.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$6 = Service.class.getDeclaredMethod("setContainerName", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$5 = Service.class.getDeclaredMethod("containerName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$4 = Service.class.getDeclaredMethod("setName", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$3 = Service.class.getDeclaredMethod("activeMembersCount", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$2 = Service.class.getDeclaredMethod("checkAndRegister", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$1 = Service.class.getDeclaredMethod("awaitRegister", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$0 = Service.class.getDeclaredMethod("onRegister", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        rand = new Random();
        interruptableActor = new InterruptableActor();
    }
}

