/*
 * Decompiled with CFR 0.152.
 */
package oracle.json.parser;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Map;
import javax.json.JsonException;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import javax.json.stream.JsonParsingException;
import oracle.json.common.JsonFactoryProvider;
import oracle.json.parser.DocumentLoader;
import oracle.json.parser.PathParser;
import oracle.json.parser.QueryException;
import oracle.json.parser.QueryMessage;
import oracle.json.util.ByteArray;

public class ProjectionSpec {
    private final InputStream source;
    private final JsonFactoryProvider jProvider;
    private boolean is_parsed = false;
    private boolean is_checked_for_array_steps = false;
    private boolean is_checked_for_paths_overlap = false;
    private boolean is_validated = false;
    private String rendition = null;
    private boolean includeSeen = false;
    private boolean excludeSeen = false;
    private boolean badValueSeen = false;
    private boolean arrayStepSeen = false;
    private boolean overlappingPathsSeen = false;
    private ArrayList<String[]> paths = new ArrayList();

    public ProjectionSpec(JsonFactoryProvider jsonFactoryProvider, InputStream inputStream) {
        this.jProvider = jsonFactoryProvider;
        this.source = inputStream;
    }

    private void makeException(QueryMessage queryMessage, Object ... objectArray) throws QueryException {
        QueryException.throwSyntaxException(queryMessage, objectArray);
    }

    private void close() throws QueryException {
        try {
            this.source.close();
        }
        catch (IOException iOException) {
            throw new QueryException(QueryMessage.EX_INVALID_PROJECTION.get(new Object[0]), iOException);
        }
    }

    public String getAsString() throws QueryException {
        if (this.rendition == null) {
            try {
                ByteArray byteArray = ByteArray.loadStream(this.source);
                this.rendition = byteArray.getString();
            }
            catch (IOException iOException) {
                throw new QueryException(QueryMessage.EX_INVALID_PROJECTION.get(new Object[0]), iOException);
            }
        }
        return this.rendition;
    }

    public boolean hasIncludeRules() {
        return this.includeSeen;
    }

    public boolean hasExcludeRules() {
        return this.excludeSeen;
    }

    public boolean hasArraySteps() {
        if (this.is_checked_for_array_steps) {
            return this.arrayStepSeen;
        }
        for (String[] stringArray : this.paths) {
            this.arrayStepSeen = this.hasArrayStep(stringArray);
            if (!this.arrayStepSeen) continue;
            this.is_checked_for_array_steps = true;
            return this.arrayStepSeen;
        }
        this.is_checked_for_array_steps = true;
        return this.arrayStepSeen;
    }

    public boolean hasOverlappingPaths() {
        if (this.is_checked_for_paths_overlap) {
            return this.overlappingPathsSeen;
        }
        block0: while (this.paths.size() >= 2) {
            for (int i = 1; i < this.paths.size(); ++i) {
                if (!ProjectionSpec.isPrefix(this.paths.get(0), this.paths.get(i))) continue;
                this.overlappingPathsSeen = true;
                break block0;
            }
            this.paths.remove(0);
        }
        this.is_checked_for_paths_overlap = true;
        return this.overlappingPathsSeen;
    }

    static boolean isPrefix(String[] stringArray, String[] stringArray2) {
        int n = stringArray.length <= stringArray2.length ? stringArray.length : stringArray2.length;
        for (int i = 0; i < n; ++i) {
            if (stringArray[i].equals(stringArray2[i]) || stringArray[i].equals("*") || stringArray2[i].equals("*")) continue;
            return false;
        }
        return true;
    }

    boolean hasArrayStep(String[] stringArray) {
        for (String string : stringArray) {
            if (!string.startsWith("[")) continue;
            return true;
        }
        return false;
    }

    public boolean validate(boolean bl) throws QueryException {
        if (this.is_validated) {
            return !this.badValueSeen;
        }
        String string = this.getAsString();
        QueryException queryException = null;
        this.badValueSeen = false;
        this.excludeSeen = false;
        this.includeSeen = false;
        try {
            DocumentLoader documentLoader = new DocumentLoader(this.jProvider, string);
            JsonStructure jsonStructure = documentLoader.parse();
            if (!(jsonStructure instanceof JsonObject)) {
                throw new QueryException(QueryMessage.EX_INVALID_PROJECTION.get(new Object[0]));
            }
            JsonObject jsonObject = (JsonObject)jsonStructure;
            this.close();
            block17: for (Map.Entry entry : jsonObject.entrySet()) {
                Object object;
                Object object2;
                String string2 = (String)entry.getKey();
                JsonValue jsonValue = (JsonValue)entry.getValue();
                JsonValue.ValueType valueType = jsonValue.getValueType();
                if (bl) {
                    object2 = new PathParser(string2);
                    object = ((PathParser)object2).splitAndSQLEscape();
                    if (object == null) {
                        this.makeException(QueryMessage.EX_INDEX_ILLEGAL_PATH, string2);
                    }
                    this.paths.add((String[])object);
                }
                switch (valueType) {
                    case TRUE: {
                        this.includeSeen = true;
                        continue block17;
                    }
                    case FALSE: {
                        this.excludeSeen = true;
                        continue block17;
                    }
                    case STRING: {
                        object2 = ((JsonString)jsonValue).getString();
                        if (((String)object2).equals("include")) {
                            this.includeSeen = true;
                            continue block17;
                        }
                        if (((String)object2).equals("exclude")) {
                            this.excludeSeen = true;
                            continue block17;
                        }
                        this.badValueSeen = true;
                        continue block17;
                    }
                    case NUMBER: {
                        object = ((JsonNumber)jsonValue).bigDecimalValue();
                        if (((BigDecimal)object).compareTo(BigDecimal.ZERO) == 0) {
                            this.excludeSeen = true;
                            continue block17;
                        }
                        if (((BigDecimal)object).compareTo(BigDecimal.ONE) == 0) {
                            this.includeSeen = true;
                            continue block17;
                        }
                        this.badValueSeen = true;
                        continue block17;
                    }
                }
                this.badValueSeen = true;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new QueryException(QueryMessage.EX_INVALID_PROJECTION.get(new Object[0]), illegalArgumentException);
        }
        catch (JsonParsingException jsonParsingException) {
            throw new QueryException(QueryMessage.EX_INVALID_PROJECTION.get(new Object[0]), (Exception)((Object)jsonParsingException));
        }
        catch (JsonException jsonException) {
            throw new QueryException(QueryMessage.EX_INVALID_PROJECTION.get(new Object[0]), (Exception)((Object)jsonException));
        }
        finally {
            try {
                this.close();
            }
            catch (QueryException queryException2) {
                queryException = queryException2;
            }
        }
        if (queryException != null) {
            throw queryException;
        }
        this.is_validated = true;
        return !this.badValueSeen;
    }
}

