/*
 * Decompiled with CFR 0.152.
 */
package oracle.json.parser;

import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import javax.json.JsonException;
import javax.json.JsonObjectBuilder;
import javax.json.stream.JsonParser;
import javax.json.stream.JsonParsingException;
import oracle.json.common.JsonFactoryProvider;
import oracle.json.parser.DocumentLoader;

public class FilterLoader
extends DocumentLoader {
    private boolean parseOrderBy = false;
    private boolean orderByParsed = false;
    static final String MULTIPLE_ORDERBY_OPS = "SODA FOR JAVA: ENCOUNTERED MULTIPLE $orderby";
    private boolean queryParsed = false;
    static final String MULTIPLE_QUERY_OPS = "SODA FOR JAVA: ENCOUNTERED MULTIPLE $query";
    private ArrayList<String> orderKeys = null;
    private ArrayList<String> orderVals = null;
    private final String ORDERBY = "$orderby";
    private final String QUERY = "$query";

    FilterLoader(JsonFactoryProvider jsonFactoryProvider, InputStream inputStream) throws JsonException {
        super(jsonFactoryProvider, inputStream);
    }

    int getOrderCount() {
        if (this.orderKeys == null || this.orderVals == null) {
            return 0;
        }
        return this.orderKeys.size();
    }

    String getOrderPath(int n) {
        if (n < 0) {
            return null;
        }
        if (this.orderKeys == null) {
            return null;
        }
        if (n >= this.orderKeys.size()) {
            return null;
        }
        return this.orderKeys.get(n);
    }

    String getOrderDirection(int n) {
        if (n < 0) {
            return null;
        }
        if (this.orderVals == null) {
            return null;
        }
        if (n >= this.orderVals.size()) {
            return null;
        }
        return this.orderVals.get(n);
    }

    private void appendOrderBy(int n, String string, String string2) {
        if (!this.parseOrderBy || n != 1) {
            return;
        }
        if (this.orderKeys == null) {
            this.orderKeys = new ArrayList();
        }
        if (this.orderVals == null) {
            this.orderVals = new ArrayList();
        }
        this.orderKeys.add(string);
        this.orderVals.add(string2);
    }

    @Override
    protected JsonObjectBuilder parseObject(int n) throws JsonParsingException {
        JsonObjectBuilder jsonObjectBuilder = this.jProvider.createObjectBuilder();
        String string = null;
        String string2 = null;
        block11: while (this.parser.hasNext()) {
            JsonParser.Event event = this.parser.next();
            switch (event) {
                case START_OBJECT: {
                    if (n == 0) {
                        this.parseOrderBy = "$orderby".equals(string);
                    }
                    jsonObjectBuilder.add(string, this.parseObject(n + 1));
                    if (n == 0) {
                        this.parseOrderBy = false;
                    }
                    this.appendOrderBy(n, string, null);
                    string = null;
                    continue block11;
                }
                case START_ARRAY: {
                    jsonObjectBuilder.add(string, this.parseArray(n + 1));
                    this.appendOrderBy(n, string, null);
                    string = null;
                    continue block11;
                }
                case END_OBJECT: {
                    return jsonObjectBuilder;
                }
                case KEY_NAME: {
                    string = this.parser.getString();
                    if (this.orderByParsed) {
                        if (string.equals("$orderby") && n == 0) {
                            throw new JsonParsingException(MULTIPLE_ORDERBY_OPS, null);
                        }
                    } else if (string.equals("$orderby") && n == 0) {
                        this.orderByParsed = true;
                    }
                    if (this.queryParsed) {
                        if (!string.equals("$query") || n != 0) continue block11;
                        throw new JsonParsingException(MULTIPLE_QUERY_OPS, null);
                    }
                    if (!string.equals("$query") || n != 0) continue block11;
                    this.queryParsed = true;
                    continue block11;
                }
                case VALUE_STRING: {
                    string2 = this.parser.getString();
                    jsonObjectBuilder.add(string, string2);
                    this.appendOrderBy(n, string, string2);
                    string = null;
                    continue block11;
                }
                case VALUE_NUMBER: {
                    BigDecimal bigDecimal = this.parser.getBigDecimal();
                    if (bigDecimal.scale() <= 0) {
                        jsonObjectBuilder.add(string, bigDecimal.toBigInteger());
                    } else {
                        jsonObjectBuilder.add(string, bigDecimal);
                    }
                    this.appendOrderBy(n, string, bigDecimal.toString());
                    string = null;
                    continue block11;
                }
                case VALUE_NULL: {
                    jsonObjectBuilder.addNull(string);
                    this.appendOrderBy(n, string, null);
                    string = null;
                    continue block11;
                }
                case VALUE_TRUE: {
                    jsonObjectBuilder.add(string, true);
                    this.appendOrderBy(n, string, null);
                    string = null;
                    continue block11;
                }
                case VALUE_FALSE: {
                    jsonObjectBuilder.add(string, false);
                    this.appendOrderBy(n, string, null);
                    string = null;
                    continue block11;
                }
            }
            throw new IllegalStateException();
        }
        return jsonObjectBuilder;
    }
}

