/*
 * Decompiled with CFR 0.152.
 */
package oracle.json.common;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.util.logging.Logger;
import javax.json.Json;
import javax.json.JsonException;
import javax.json.stream.JsonGenerationException;
import javax.json.stream.JsonGenerator;
import javax.json.stream.JsonParser;
import oracle.json.common.Configuration;
import oracle.json.common.Message;

public class DocumentKeyer {
    protected static final Logger log = Logger.getLogger(DocumentKeyer.class.getName());
    private final String[] keySteps;
    private InputStream jsonStream = null;
    private StringWriter strWriter = null;
    private JsonGenerator generator = null;
    private JsonParser jParser = null;
    private String key = null;
    private int level = 0;
    private int arrLevel = 0;
    private int stepNum = 0;
    private boolean foundKey = false;
    private boolean wroteKey = false;
    private static boolean DISALLOW_KEY_OVERWRITE = true;

    DocumentKeyer(String[] stringArray) {
        this.keySteps = stringArray;
    }

    public void setInput(InputStream inputStream) {
        this.jsonStream = inputStream;
    }

    public void setInput(byte[] byArray) {
        this.setInput(new ByteArrayInputStream(byArray));
    }

    public void setInput(String string) {
        this.setInput(string.getBytes(Configuration.DEFAULT_CHARSET));
    }

    private JsonException makeException(Message message, Object ... objectArray) {
        return new JsonException(message.get(objectArray));
    }

    private void serializeItem(Object object) {
        if (this.generator != null) {
            if (object == null) {
                if (this.key != null) {
                    this.generator.writeNull(this.key);
                } else {
                    this.generator.writeNull();
                }
            } else if (object instanceof Boolean) {
                boolean bl = (Boolean)object;
                if (this.key != null) {
                    this.generator.write(this.key, bl);
                } else {
                    this.generator.write(bl);
                }
            } else if (object instanceof BigDecimal) {
                BigDecimal bigDecimal = (BigDecimal)object;
                if (bigDecimal.scale() <= 0) {
                    if (this.key != null) {
                        this.generator.write(this.key, bigDecimal.toBigInteger());
                    } else {
                        this.generator.write(bigDecimal.toBigInteger());
                    }
                } else if (this.key != null) {
                    this.generator.write(this.key, bigDecimal);
                } else {
                    this.generator.write(bigDecimal);
                }
            } else if (object instanceof String) {
                String string = (String)object;
                if (this.key != null) {
                    this.generator.write(this.key, string);
                } else {
                    this.generator.write(string);
                }
            } else if (object instanceof JsonParser.Event) {
                JsonParser.Event event = (JsonParser.Event)object;
                if (event == JsonParser.Event.START_ARRAY) {
                    if (this.key == null) {
                        this.generator.writeStartArray();
                    } else {
                        this.generator.writeStartArray(this.key);
                    }
                } else if (event == JsonParser.Event.START_OBJECT) {
                    if (this.key == null) {
                        this.generator.writeStartObject();
                    } else {
                        this.generator.writeStartObject(this.key);
                    }
                } else if (event == JsonParser.Event.END_OBJECT || event == JsonParser.Event.END_ARRAY) {
                    this.generator.writeEnd();
                }
            } else {
                String string = object.toString();
                if (this.key != null) {
                    this.generator.write(this.key, string);
                } else {
                    this.generator.write(string);
                }
            }
        }
        this.key = null;
    }

    private void serializeItem(String string, Object object) {
        this.key = string;
        this.serializeItem(object);
        this.key = null;
    }

    private void createKey(String string) {
        int n;
        int n2 = this.keySteps.length - 1;
        for (n = this.stepNum; n < n2; ++n) {
            this.serializeItem(this.keySteps[n], JsonParser.Event.START_OBJECT);
        }
        this.serializeItem(this.keySteps[n], string);
        for (n = this.stepNum; n < n2; ++n) {
            this.serializeItem(null, JsonParser.Event.END_OBJECT);
        }
    }

    private String processEvent(JsonParser.Event event, String string) throws JsonGenerationException {
        String string2 = null;
        if (event == JsonParser.Event.KEY_NAME) {
            this.key = this.jParser.getString();
            if (this.arrLevel == 0 && this.level == this.stepNum + 1 && this.keySteps.length > this.stepNum && this.key.equals(this.keySteps[this.stepNum]) && ++this.stepNum == this.keySteps.length) {
                this.foundKey = true;
            }
        } else if (event == JsonParser.Event.VALUE_STRING) {
            String string3 = this.jParser.getString();
            if (this.foundKey) {
                string2 = string3;
                if (string != null) {
                    string3 = string;
                }
                this.foundKey = false;
                this.wroteKey = true;
                --this.stepNum;
                if (DISALLOW_KEY_OVERWRITE && string != null && !string2.equals(string)) {
                    throw this.makeException(Message.EX_KEY_MISMATCH, new Object[0]);
                }
            }
            this.serializeItem(string3);
        } else if (event == JsonParser.Event.VALUE_NUMBER) {
            BigDecimal bigDecimal = this.jParser.getBigDecimal();
            if (!this.foundKey) {
                this.serializeItem(bigDecimal);
            } else {
                if (string != null) {
                    this.serializeItem(string);
                } else {
                    this.serializeItem(bigDecimal);
                }
                string2 = bigDecimal.scale() > 0 ? bigDecimal.toString() : bigDecimal.toBigInteger().toString();
                this.foundKey = false;
                this.wroteKey = true;
                --this.stepNum;
                if (DISALLOW_KEY_OVERWRITE && string != null) {
                    boolean bl = false;
                    try {
                        BigDecimal bigDecimal2 = new BigDecimal(string);
                        bl = bigDecimal.equals(bigDecimal2);
                    }
                    catch (NumberFormatException numberFormatException) {
                        bl = false;
                    }
                    if (!bl) {
                        throw this.makeException(Message.EX_KEY_MISMATCH, new Object[0]);
                    }
                }
            }
        } else if (event == JsonParser.Event.VALUE_TRUE) {
            if (this.foundKey) {
                throw this.makeException(Message.EX_KEY_MUST_BE_STRING, new Object[0]);
            }
            this.serializeItem(Boolean.TRUE);
        } else if (event == JsonParser.Event.VALUE_FALSE) {
            if (this.foundKey) {
                throw this.makeException(Message.EX_KEY_MUST_BE_STRING, new Object[0]);
            }
            this.serializeItem(Boolean.FALSE);
        } else if (event == JsonParser.Event.VALUE_NULL) {
            if (this.foundKey) {
                throw this.makeException(Message.EX_KEY_MUST_BE_STRING, new Object[0]);
            }
            this.serializeItem(null);
        } else if (event == JsonParser.Event.START_ARRAY) {
            if (this.foundKey) {
                throw this.makeException(Message.EX_KEY_MUST_BE_STRING, new Object[0]);
            }
            ++this.level;
            ++this.arrLevel;
            this.serializeItem(event);
        } else if (event == JsonParser.Event.START_OBJECT) {
            if (this.foundKey) {
                throw this.makeException(Message.EX_KEY_MUST_BE_STRING, new Object[0]);
            }
            ++this.level;
            this.serializeItem(event);
        } else if (event == JsonParser.Event.END_OBJECT) {
            --this.level;
            if (this.level == this.stepNum) {
                if (!this.wroteKey && string != null) {
                    this.createKey(string);
                    this.wroteKey = true;
                    string2 = string;
                }
                if (this.stepNum > 0) {
                    --this.stepNum;
                }
            }
            this.serializeItem(event);
        } else if (event == JsonParser.Event.END_ARRAY) {
            --this.level;
            --this.arrLevel;
            this.serializeItem(event);
        }
        return string2;
    }

    private void clearParse() {
        this.key = null;
        this.level = 0;
        this.arrLevel = 0;
        this.stepNum = 0;
        this.foundKey = false;
        this.wroteKey = false;
    }

    private String parseStream(String string, boolean bl) throws JsonException {
        this.clearParse();
        if (this.jsonStream == null) {
            throw this.makeException(Message.EX_NO_INPUT_DOCUMENT, new Object[0]);
        }
        JsonParser jsonParser = Json.createParser((InputStream)this.jsonStream);
        boolean bl2 = true;
        String string2 = null;
        if (this.keySteps.length <= 0) {
            throw this.makeException(Message.EX_KEY_PATH_EMPTY, new Object[0]);
        }
        while (jsonParser.hasNext()) {
            String string3;
            JsonParser.Event event = jsonParser.next();
            if (bl2) {
                bl2 = false;
                if (event != JsonParser.Event.START_OBJECT) {
                    throw this.makeException(Message.EX_DOCUMENT_NOT_OBJECT, new Object[0]);
                }
            }
            if ((string3 = this.processEvent(event, string)) == null) continue;
            if (string2 != null) {
                throw this.makeException(Message.EX_DUPLICATE_KEY, new Object[0]);
            }
            string2 = string3;
            if (!bl) continue;
            break;
        }
        if (!bl && this.level != 0) {
            throw this.makeException(Message.EX_DOCUMENT_NOT_CLOSED, new Object[0]);
        }
        jsonParser.close();
        return string2;
    }

    public String extractKey() throws JsonException {
        return this.extractKey(false);
    }

    public String extractKey(boolean bl) throws JsonException {
        this.generator = null;
        return this.parseStream(null, !bl);
    }

    public String insertKey(String string) throws JsonException {
        this.strWriter = new StringWriter();
        this.generator = Json.createGenerator((Writer)this.strWriter);
        String string2 = this.parseStream(string, false);
        this.generator.flush();
        this.generator.close();
        String string3 = this.strWriter.toString();
        this.generator = null;
        this.strWriter = null;
        return string3;
    }
}

