/*
 * Decompiled with CFR 0.152.
 */
package liquibase.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import liquibase.GlobalConfiguration;
import liquibase.Scope;
import liquibase.util.StreamUtil;

public class FileUtil {
    private FileUtil() {
        throw new IllegalStateException("This utility class must not be instantiated. Sorry.");
    }

    private static void cleanDirectory(File directory) throws IOException {
        if (!directory.exists()) {
            return;
        }
        if (!directory.isDirectory()) {
            return;
        }
        IOException exception = null;
        File[] files = directory.listFiles();
        if (files != null) {
            for (File file : files) {
                try {
                    FileUtil.cleanDirectory(file);
                    if (!file.delete()) {
                        throw new IOException("Cannot delete " + file.getAbsolutePath());
                    }
                }
                catch (IOException ioe) {
                    exception = ioe;
                }
            }
        }
        if (null != exception) {
            throw exception;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getContents(File file) throws IOException {
        if (!file.exists()) {
            return null;
        }
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            String string = StreamUtil.readStreamAsString(fileInputStream);
            return string;
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    public static void write(String contents, File file) throws IOException {
        file.getParentFile().mkdirs();
        try (FileOutputStream output = new FileOutputStream(file);){
            StreamUtil.copy(new ByteArrayInputStream(contents.getBytes(GlobalConfiguration.OUTPUT_FILE_ENCODING.getCurrentValue())), output);
        }
    }

    public static String getFileNotFoundMessage(String physicalChangeLogLocation) {
        String message = "The file " + physicalChangeLogLocation + " was not found in" + System.lineSeparator();
        for (String location : Scope.getCurrentScope().getResourceAccessor().describeLocations()) {
            message = message + "    - " + location + System.lineSeparator();
        }
        message = message + "Specifying files by absolute path was removed in Liquibase 4.0. Please use a relative path or add '/' to the classpath parameter.";
        return message;
    }
}

