/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.core;

import java.util.Arrays;
import liquibase.Scope;
import liquibase.database.DatabaseConnection;
import liquibase.database.core.MySQLDatabase;
import liquibase.exception.DatabaseException;
import liquibase.util.StringUtil;

public class MariaDBDatabase
extends MySQLDatabase {
    private static final String PRODUCT_NAME = "MariaDB";

    public MariaDBDatabase() {
        this.addReservedWords(Arrays.asList("PERIOD"));
        this.sequenceNextValueFunction = "NEXT VALUE FOR %s";
        this.unmodifiableDataTypes.addAll(Arrays.asList("boolean", "tinyint", "smallint", "mediumint", "int", "integer", "bigint", "dec", "numeric", "fixed", "float", "bit"));
    }

    @Override
    public String getShortName() {
        return "mariadb";
    }

    @Override
    protected String getDefaultDatabaseProductName() {
        return PRODUCT_NAME;
    }

    @Override
    public String getDefaultDriver(String url) {
        if (url.startsWith("jdbc:mariadb")) {
            return "org.mariadb.jdbc.Driver";
        }
        return null;
    }

    @Override
    public int getMaxFractionalDigitsForTimestamp() {
        int major = 0;
        int minor = 0;
        int patch = 0;
        try {
            major = this.getDatabaseMajorVersion();
            minor = this.getDatabaseMinorVersion();
            patch = this.getDatabasePatchVersion();
        }
        catch (DatabaseException x) {
            Scope.getCurrentScope().getLog(this.getClass()).warning("Unable to determine exact database server version - specified TIMESTAMP precision will not be set: ", x);
            return 0;
        }
        String minimumVersion = "5.3.0";
        if (StringUtil.isMinimumVersion(minimumVersion, major, minor, patch)) {
            return 6;
        }
        return 0;
    }

    @Override
    public boolean isCorrectDatabaseImplementation(DatabaseConnection conn) throws DatabaseException {
        if (PRODUCT_NAME.equalsIgnoreCase(conn.getDatabaseProductName())) {
            return true;
        }
        return "MYSQL".equalsIgnoreCase(conn.getDatabaseProductName()) && conn.getDatabaseProductVersion().toLowerCase().contains("mariadb");
    }

    @Override
    protected String getMinimumVersionForFractionalDigitsForTimestamp() {
        return "5.3.0";
    }

    @Override
    public boolean supportsSequences() {
        try {
            int majorVersion = this.getDatabaseMajorVersion();
            return majorVersion > 10 || majorVersion == 10 && this.getDatabaseMinorVersion() >= 3;
        }
        catch (DatabaseException e) {
            Scope.getCurrentScope().getLog(this.getClass()).fine("Cannot retrieve database version", e);
            return false;
        }
    }
}

